/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;

public class TestTypedSpeed
implements XMLStreamConstants {
    private int REPS;
    private static final int TEST_PER_GC = 7;
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_INT = 1;
    static final int MIN_RUN_TIME = 5;
    static final int MAX_RUN_TIME = 1000;
    final XMLInputFactory mInputFactory = new InputFactoryImpl();
    final ByteArrayInputStream mIn;
    boolean mUseAttr;
    int mType;

    private TestTypedSpeed(byte[] byArray) {
        this.mInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.mInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.mInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.mIn = new ByteArrayInputStream(byArray);
        this.REPS = 100 + 8000000 / byArray.length;
        System.out.println("Based on size, will use " + this.REPS + " repetitions");
    }

    protected int test() throws Exception {
        this.mIn.reset();
        String string = this.findFirstValue(this.mIn);
        if (this.mUseAttr) {
            this.REPS += this.REPS;
            System.out.println("(data stored as attributes: doubling REPS to " + this.REPS + ")");
        } else {
            System.out.println("(data stored as element content)");
        }
        this.mType = 0;
        if ("true".equals(string) || "false".equals(string)) {
            this.mType = 1;
            System.out.println("Type detected as: BOOLEAN");
        } else {
            try {
                Integer.parseInt(string);
                this.mType = 1;
                System.out.println("Type detected as: INT");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mType == 0) {
            throw new IllegalArgumentException("Can not auto-detect type from value '" + string + "'");
        }
        return this.test2();
    }

    private String findFirstValue(InputStream inputStream) throws XMLStreamException {
        String string;
        XMLStreamReader xMLStreamReader = this.mInputFactory.createXMLStreamReader(inputStream);
        xMLStreamReader.nextTag();
        xMLStreamReader.nextTag();
        if (xMLStreamReader.getAttributeCount() > 0) {
            this.mUseAttr = true;
            string = xMLStreamReader.getAttributeValue(0);
        } else {
            this.mUseAttr = false;
            string = xMLStreamReader.getElementText();
        }
        xMLStreamReader.close();
        return string;
    }

    private int test2() throws Exception {
        int n = 0;
        int n2 = 0;
        while (true) {
            String string;
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n3 = n++ % 2;
            long l = System.currentTimeMillis();
            int n4 = 0;
            block5 : switch (n3) {
                case 0: {
                    string = "Access using Stax 1.0";
                    switch (this.mType) {
                        case 1: {
                            n4 = this.mUseAttr ? this.testUntypedBooleanAttr(this.REPS) : this.testUntypedBooleanElem(this.REPS);
                            break block5;
                        }
                    }
                    throw new Error("Internal error");
                }
                case 1: {
                    string = "Access using Stax2 Typed API";
                    switch (this.mType) {
                        case 1: {
                            n4 = this.mUseAttr ? this.testTypedBooleanAttr(this.REPS) : this.testTypedBooleanElem(this.REPS);
                            break block5;
                        }
                    }
                    throw new Error("Internal error");
                }
                default: {
                    throw new Error("Internal error");
                }
            }
            l = System.currentTimeMillis() - l;
            if (n3 == 0) {
                System.out.println();
            }
            System.out.println("Test '" + string + "' -> " + l + " msecs (" + n4 + " -> " + (n2 & 0xFF) + ").");
            n2 += n4;
            if (n % 7 != 0) continue;
            System.out.println("[GC]");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l < 5L) {
                this.REPS += this.REPS / 5;
                System.out.println("[NOTE: increasing reps, now: " + this.REPS + "]");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (l <= 1000L || n <= 20) continue;
            this.REPS -= this.REPS / 10;
            System.out.println("[NOTE: decreasing reps, now: " + this.REPS + "]");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected int testUntypedBooleanAttr(int n) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLStreamReader2 xMLStreamReader2 = this.constructAndFindRoot();
            while (xMLStreamReader2.nextTag() == 1) {
                int n3 = xMLStreamReader2.getAttributeCount();
                while (--n3 >= 0) {
                    String string = xMLStreamReader2.getAttributeValue(n3).trim();
                    if (string.equals("true")) {
                        ++n2;
                        continue;
                    }
                    if (string.equals("false") || string.equals("0")) continue;
                    if (string.equals("1")) {
                        ++n2;
                        continue;
                    }
                    throw new XMLStreamException("Illegal value '" + string + "', not boolean");
                }
            }
            xMLStreamReader2.close();
        }
        return n2;
    }

    protected int testUntypedBooleanElem(int n) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLStreamReader2 xMLStreamReader2 = this.constructAndFindRoot();
            while (xMLStreamReader2.nextTag() == 1) {
                String string = xMLStreamReader2.getElementText().trim();
                if (string.equals("true")) {
                    ++n2;
                    continue;
                }
                if (string.equals("false") || string.equals("0")) continue;
                if (string.equals("1")) {
                    ++n2;
                    continue;
                }
                throw new XMLStreamException("Illegal value '" + string + "', not boolean");
            }
            xMLStreamReader2.close();
        }
        return n2;
    }

    protected int testTypedBooleanAttr(int n) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLStreamReader2 xMLStreamReader2 = this.constructAndFindRoot();
            while (xMLStreamReader2.nextTag() == 1) {
                int n3 = xMLStreamReader2.getAttributeCount();
                while (--n3 >= 0) {
                    if (!xMLStreamReader2.getAttributeAsBoolean(n3)) continue;
                    ++n2;
                }
            }
            xMLStreamReader2.close();
        }
        return n2;
    }

    protected int testTypedBooleanElem(int n) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLStreamReader2 xMLStreamReader2 = this.constructAndFindRoot();
            while (xMLStreamReader2.nextTag() == 1) {
                if (!xMLStreamReader2.getElementAsBoolean()) continue;
                ++n2;
            }
            xMLStreamReader2.close();
        }
        return n2;
    }

    XMLStreamReader2 constructAndFindRoot() throws XMLStreamException {
        this.mIn.reset();
        XMLStreamReader xMLStreamReader = this.mInputFactory.createXMLStreamReader(this.mIn);
        if (xMLStreamReader.nextTag() != 1) {
            throw new XMLStreamException("Couldn't locate root");
        }
        return (XMLStreamReader2)xMLStreamReader;
    }

    static byte[] readData(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4000);
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... <file>");
            System.exit(1);
        }
        byte[] byArray = TestTypedSpeed.readData(new File(stringArray[0]));
        System.out.println(" -> " + byArray.length + " bytes read.");
        new TestTypedSpeed(byArray).test();
    }
}

