/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.impl;

import java.util.HashMap;

public abstract class CommonConfig {
    protected static final String IMPL_NAME = "aalto";
    protected static final String IMPL_VERSION = "0.9";
    static final int PROP_IMPL_NAME = 1;
    static final int PROP_IMPL_VERSION = 2;
    static final int PROP_SUPPORTS_XML11 = 3;
    static final int PROP_SUPPORTS_XMLID = 4;
    static final HashMap<String, Integer> sStdProperties = new HashMap(16);
    protected int _flags;
    protected int _flagMods;

    protected CommonConfig(int n, int n2) {
        this._flags = n;
        this._flagMods = n2;
    }

    public Object getProperty(String string, boolean bl) {
        Integer n = sStdProperties.get(string);
        if (n != null) {
            switch (n) {
                case 1: {
                    return IMPL_NAME;
                }
                case 2: {
                    return IMPL_VERSION;
                }
                case 3: {
                    return Boolean.FALSE;
                }
                case 4: {
                    return Boolean.FALSE;
                }
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Unrecognized property '" + string + "'");
        }
        return null;
    }

    public boolean isPropertySupported(String string) {
        return sStdProperties.containsKey(string);
    }

    public boolean setProperty(String string, Object object) {
        Integer n = sStdProperties.get(string);
        if (n != null) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized property '" + string + "'");
    }

    public abstract String getExternalEncoding();

    public abstract String getActualEncoding();

    public abstract boolean isXml11();

    protected final boolean hasFlag(int n) {
        return (this._flags & n) != 0;
    }

    protected final boolean hasExplicitFlag(int n) {
        return this.hasFlag(n) && this.hasFlagBeenModified(n);
    }

    protected final void setFlag(int n, boolean bl) {
        this._flags = bl ? (this._flags |= n) : (this._flags &= ~n);
        this._flagMods |= n;
    }

    protected final boolean hasFlagBeenModified(int n) {
        return (this._flagMods & n) != 0;
    }

    static {
        sStdProperties.put("org.codehaus.stax2.implName", 1);
        sStdProperties.put("org.codehaus.stax2.implVersion", 2);
        sStdProperties.put("org.codehaus.stax2.supportsXml11", 3);
        sStdProperties.put("org.codehaus.stax2.supportXmlId", 4);
        sStdProperties.put("http://java.sun.com/xml/stream/properties/implementation-name", 1);
    }
}

