/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public abstract class ByteXmlWriter
extends XmlWriter {
    static final int DEFAULT_FULL_BUFFER_SIZE = 4000;
    static final int DEFAULT_COPY_BUFFER_SIZE = 1000;
    static final int SMALL_WRITE = 250;
    static final byte BYTE_SPACE = 32;
    static final byte BYTE_COLON = 58;
    static final byte BYTE_SEMICOLON = 59;
    static final byte BYTE_LBRACKET = 91;
    static final byte BYTE_RBRACKET = 93;
    static final byte BYTE_QMARK = 63;
    static final byte BYTE_EQ = 61;
    static final byte BYTE_SLASH = 47;
    static final byte BYTE_HASH = 35;
    static final byte BYTE_HYPHEN = 45;
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_AMP = 38;
    static final byte BYTE_QUOT = 34;
    static final byte BYTE_APOS = 39;
    static final byte BYTE_A = 97;
    static final byte BYTE_G = 103;
    static final byte BYTE_L = 108;
    static final byte BYTE_M = 109;
    static final byte BYTE_O = 111;
    static final byte BYTE_P = 112;
    static final byte BYTE_Q = 113;
    static final byte BYTE_S = 115;
    static final byte BYTE_T = 116;
    static final byte BYTE_U = 117;
    static final byte BYTE_X = 120;
    static final byte[] BYTES_CDATA_START = ByteXmlWriter.getAscii("<![CDATA[");
    static final byte[] BYTES_CDATA_END = ByteXmlWriter.getAscii("]]>");
    static final byte[] BYTES_COMMENT_START = ByteXmlWriter.getAscii("<!--");
    static final byte[] BYTES_COMMENT_END = ByteXmlWriter.getAscii("-->");
    static final byte[] BYTES_XMLDECL_START = ByteXmlWriter.getAscii("<?xml version='");
    static final byte[] BYTES_XMLDECL_ENCODING = ByteXmlWriter.getAscii(" encoding='");
    static final byte[] BYTES_XMLDECL_STANDALONE = ByteXmlWriter.getAscii(" standalone='");
    protected OutputStream _out;
    protected byte[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    protected int mSurrogate = 0;
    protected char[] mCopyBuffer;
    protected final int mCopyBufferLen;
    protected final XmlCharTypes mCharTypes;

    protected ByteXmlWriter(WriterConfig writerConfig, OutputStream outputStream, XmlCharTypes xmlCharTypes) {
        super(writerConfig);
        this._out = outputStream;
        this._outputBuffer = writerConfig.allocFullBBuffer(4000);
        this._outputBufferLen = this._outputBuffer.length;
        this.mCopyBuffer = writerConfig.allocFullCBuffer(1000);
        this.mCopyBufferLen = this.mCopyBuffer.length;
        this._outputPtr = 0;
        this.mCharTypes = xmlCharTypes;
    }

    @Override
    protected final int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public final WName constructName(String string) throws XMLStreamException {
        this.verifyNameComponent(string);
        return this.doConstructName(string);
    }

    @Override
    public WName constructName(String string, String string2) throws XMLStreamException {
        this.verifyNameComponent(string);
        this.verifyNameComponent(string2);
        return this.doConstructName(string, string2);
    }

    protected abstract WName doConstructName(String var1) throws XMLStreamException;

    protected abstract WName doConstructName(String var1, String var2) throws XMLStreamException;

    protected void verifyNameComponent(String string) throws XMLStreamException {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            this.reportNwfName(ErrorConsts.WERR_NAME_EMPTY);
        }
        int n3 = string.charAt(0);
        int n4 = string.length();
        if (n3 >= 55296 && n3 <= 57343) {
            if (n3 >= 56320) {
                this.reportNwfName("Illegal surrogate pairing in name: first character (" + XmlChars.getCharDesc(n3) + ") not valid surrogate first character");
            }
            if (n4 < 2) {
                this.reportNwfName("Illegal surrogate pairing in name: incomplete surrogate (missing second half)");
            }
            n3 = this.calcSurrogate(n3, string.charAt(1), " in name");
            n2 = 2;
        } else {
            n2 = 1;
        }
        if (!XmlChars.is10NameStartChar(n3)) {
            this.reportNwfName("Invalid name start character " + XmlChars.getCharDesc(n3) + " (name \"" + string + "\")");
        }
        if (n3 > (n = this.getHighestEncodable())) {
            this.reportNwfName("Illegal name start character " + XmlChars.getCharDesc(n3) + " (name \"" + string + "\"): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
        }
        while (n2 < n4) {
            n3 = string.charAt(n2);
            if (n3 >= 55296 && n3 <= 57343) {
                if (n3 >= 56320) {
                    this.reportNwfName("Illegal surrogate pairing in name: character at #" + n2 + " (" + XmlChars.getCharDesc(n3) + ") not valid surrogate first character");
                }
                if (++n2 >= n4) {
                    this.reportNwfName("Illegal surrogate pairing in name: name ends with incomplete surrogate pair");
                }
                n3 = this.calcSurrogate(n3, string.charAt(n2), " in name");
            }
            if (n3 > n) {
                this.reportNwfName("Illegal name character " + XmlChars.getCharDesc(n3) + " (name \"" + string + "\", index #" + n2 + "): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
            }
            if (!XmlChars.is10NameChar(n3)) {
                this.reportNwfName("Invalid name character " + XmlChars.getCharDesc(n3) + ") in name (\"" + string + "\"), index #" + n2);
            }
            ++n2;
        }
    }

    protected abstract void outputSurrogates(int var1, int var2) throws IOException, XMLStreamException;

    protected abstract void output2ByteChar(int var1) throws IOException, XMLStreamException;

    protected abstract int outputStrictMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    protected abstract int outputMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullBBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
        if (this.mCopyBuffer != null) {
            this._config.freeFullCBuffer(this.mCopyBuffer);
            this.mCopyBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean bl) throws IOException {
        if (this._out != null && bl) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public final void writeRaw(String string, int n, int n2) throws IOException, XMLStreamException {
        while (n2 > 0) {
            char[] cArray = this.mCopyBuffer;
            int n3 = cArray.length;
            int n4 = n2 < n3 ? n2 : n3;
            string.getChars(n, n + n4, cArray, 0);
            this.writeRaw(cArray, 0, n4);
            n += n4;
            n2 -= n4;
        }
    }

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    @Override
    public final void writeStartTagStart(WName wName) throws IOException, XMLStreamException {
        int n;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n = this._outputPtr) + wName.serializedLength() + 1 > this._outputBufferLen) {
            this.writeName((byte)60, wName);
            return;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n++] = 60;
        n += wName.appendBytes(byArray, n);
        this._outputPtr = n;
    }

    @Override
    public final void writeStartTagEnd() throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 62;
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int n = this._outputPtr;
        if (n + 2 > this._outputBufferLen) {
            this.flushBuffer();
            n = this._outputPtr;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n++] = 47;
        byArray[n++] = 62;
        this._outputPtr = n;
    }

    @Override
    public final void writeEndTag(WName wName) throws IOException, XMLStreamException {
        int n;
        int n2;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n2 = this._outputPtr) + (n = wName.serializedLength()) + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                wName.writeBytes(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            n2 = this._outputPtr;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 60;
        byArray[n2++] = 47;
        n2 += wName.appendBytes(byArray, n2);
        byArray[n2++] = 62;
        this._outputPtr = n2;
    }

    @Override
    public final void writeAttribute(WName wName, String string) throws IOException, XMLStreamException {
        int n = string.length();
        if (n > this.mCopyBufferLen) {
            this.writeLongAttribute(wName, string, n);
            return;
        }
        char[] cArray = this.mCopyBuffer;
        if (n > 0) {
            string.getChars(0, n, cArray, 0);
        }
        this.writeAttribute(wName, cArray, 0, n);
    }

    @Override
    public final void writeAttribute(WName wName, char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int n3 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        if (n3 + wName.serializedLength() >= this._outputBufferLen) {
            this.writeName((byte)32, wName);
            n3 = this._outputPtr;
        } else {
            byArray[n3++] = 32;
            n3 += wName.appendBytes(byArray, n3);
        }
        if (n3 + 3 + n2 > this._outputBufferLen) {
            this._outputPtr = n3;
            this.flushBuffer();
            byArray[this._outputPtr++] = 61;
            byArray[this._outputPtr++] = 34;
            if (this._outputPtr + n2 + 1 > this._outputBufferLen) {
                this.writeAttrValue(cArray, n, n2);
                this.writeRaw((byte)34);
                return;
            }
            n3 = this._outputPtr;
        } else {
            byArray[n3++] = 61;
            byArray[n3++] = 34;
        }
        if (n2 > 0) {
            n3 = this.fastWriteAttrValue(cArray, n, n2, byArray, n3);
        }
        byArray[n3++] = 34;
        this._outputPtr = n3;
    }

    protected final int fastWriteAttrValue(char[] cArray, int n, int n2, byte[] byArray, int n3) throws IOException, XMLStreamException {
        n2 += n;
        block4: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.ATTR_CHARS;
            while ((c = cArray[n]) < '\u0800' && nArray[c] == 0) {
                byArray[n3++] = (byte)c;
                if (++n < n2) continue;
                break block4;
            }
            this._outputPtr = n3;
            if ((c = cArray[n++]) < '\u0800') {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                        break;
                    }
                    case 5: {
                        this.output2ByteChar(c);
                        break;
                    }
                    default: {
                        this.writeAsEntity(c);
                        break;
                    }
                }
            } else {
                n = this.outputMultiByteChar(c, cArray, n, n2);
            }
            if (n2 - n >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            n3 = this._outputPtr;
        }
        return n3;
    }

    protected final void writeAttrValue(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.outputSurrogates(this.mSurrogate, cArray[n]);
            ++n;
            --n2;
        }
        n2 += n;
        block4: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.ATTR_CHARS;
            while ((c = cArray[n]) < '\u0800' && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                if (++n < n2) continue;
                break block4;
            }
            if ((c = cArray[n++]) < '\u0800') {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 5: {
                        this.output2ByteChar(c);
                        break;
                    }
                    default: {
                        this.writeAsEntity(c);
                        break;
                    }
                }
            } else {
                n = this.outputMultiByteChar(c, cArray, n, n2);
            }
            this._outputBuffer[this._outputPtr++] = (byte)c;
        }
    }

    protected final void writeLongAttribute(WName wName, String string, int n) throws IOException, XMLStreamException {
        this.writeRaw((byte)32);
        int n2 = wName.serializedLength();
        if (this._outputPtr + n2 > this._outputBufferLen) {
            this.flushBuffer();
            if (n2 > this._outputBufferLen) {
                wName.writeBytes(this._out);
            } else {
                this._outputPtr += wName.appendBytes(this._outputBuffer, this._outputPtr);
            }
        } else {
            this._outputPtr += wName.appendBytes(this._outputBuffer, this._outputPtr);
        }
        this.writeRaw((byte)61, (byte)34);
        int n3 = 0;
        while (n > 0) {
            char[] cArray = this.mCopyBuffer;
            int n4 = cArray.length;
            int n5 = n < n4 ? n : n4;
            string.getChars(n3, n3 + n5, cArray, 0);
            this.writeAttrValue(cArray, 0, n5);
            n3 += n5;
            n -= n5;
        }
        this.writeRaw((byte)34);
    }

    protected final void writeName(WName wName) throws IOException {
        int n = this._outputPtr;
        int n2 = wName.serializedLength();
        if (n + n2 > this._outputBufferLen) {
            this.flushBuffer();
            if (n2 >= this._outputBufferLen) {
                wName.writeBytes(this._out);
                return;
            }
            n = this._outputPtr;
        }
        n += wName.appendBytes(this._outputBuffer, n);
        this._outputPtr = n;
    }

    protected final void writeName(byte by, WName wName) throws IOException {
        this.flushBuffer();
        int n = wName.serializedLength();
        if (n >= this._outputBufferLen) {
            this._out.write(by);
            wName.writeBytes(this._out);
            return;
        }
        int n2 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = by;
        n2 += wName.appendBytes(byArray, n2);
        this._outputPtr = n2;
    }

    protected final void writeName(WName wName, byte by) throws IOException {
        this.flushBuffer();
        if (wName.serializedLength() >= this._outputBufferLen) {
            wName.writeBytes(this._out);
            this._out.write(by);
            return;
        }
        int n = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        n += wName.appendBytes(byArray, n);
        byArray[n++] = by;
        this._outputPtr = n;
    }

    private final void writeAttrNameEqQ(WName wName) throws IOException, XMLStreamException {
        int n;
        int n2;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n2 = this._outputPtr) + (n = wName.serializedLength()) + 3 >= this._outputBufferLen) {
            this.flushBuffer();
            n2 = this._outputPtr;
            if (n2 + n + 3 >= this._outputBufferLen) {
                this.writeName((byte)32, wName);
                this.writeRaw((byte)61);
                this.writeRaw((byte)34);
                return;
            }
        }
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 32;
        n2 += wName.appendBytes(byArray, n2);
        byArray[n2++] = 61;
        byArray[n2++] = 34;
        this._outputPtr = n2;
    }

    @Override
    public int writeCData(String string) throws IOException, XMLStreamException {
        int n;
        this.writeCDataStart();
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this.mCopyBuffer;
            n = cArray.length;
            if (n > i) {
                n = i;
            }
            string.getChars(n2, n2 + n, cArray, 0);
            int n3 = this.writeCDataContents(cArray, 0, n);
            if (n3 >= 0) {
                return n2 + n3;
            }
            n2 += n;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int n3 = this.writeCDataContents(cArray, n, n2);
        if (n3 < 0) {
            this.writeCDataEnd();
        }
        return n3;
    }

    protected int writeCDataContents(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block7: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            while ((c = cArray[n]) < '\u0800' && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                if (++n < n2) continue;
                break block7;
            }
            if ((c = cArray[n++]) < '\u0800') {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        ++this.mLocRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA", c);
                    }
                    case 5: {
                        this.output2ByteChar(c);
                        continue block7;
                    }
                    case 11: {
                        if (n >= n2 || cArray[n] != ']') break;
                        if (n + 1 >= n2 || cArray[n + 1] != '>') continue block7;
                        n += 2;
                        this.writeRaw((byte)93, (byte)93);
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeRaw((byte)62);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                continue;
            }
            n = this.outputMultiByteChar(c, cArray, n, n2);
        }
        return -1;
    }

    @Override
    public final void writeCharacters(String string) throws IOException, XMLStreamException {
        int n = string.length();
        if (n > this.mCopyBufferLen) {
            this.longWriteCharacters(string);
            return;
        }
        if (n > 0) {
            char[] cArray = this.mCopyBuffer;
            string.getChars(0, n, cArray, 0);
            this.writeCharacters(cArray, 0, n);
        }
    }

    private final void longWriteCharacters(String string) throws IOException, XMLStreamException {
        int n;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = this.mCopyBuffer;
        do {
            int n4;
            n = n3 < (n4 = cArray.length) ? n3 : n4;
            string.getChars(n2, n2 + n, cArray, 0);
            this.writeCharacters(cArray, 0, n);
            n2 += n;
        } while ((n3 -= n) > 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void writeCharacters(char[] var1_1, int var2_2, int var3_3) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.outputSurrogates(this.mSurrogate, var1_1[var2_2]);
            ++var2_2;
            --var3_3;
        }
        if ((var4_4 = this._outputPtr) + var3_3 > this._outputBufferLen) {
            this.writeSplitCharacters(var1_1, var2_2, var3_3);
            return;
        }
        var3_3 += var2_2;
        block8: while (var2_2 < var3_3) {
            block16: {
                block15: {
                    var5_5 = this.mCharTypes.TEXT_CHARS;
                    while ((var6_6 = var1_1[var2_2]) < '\u0800') {
                        if (var5_5[var6_6] != 0) {
                            if (var6_6 != '\n') break;
                            ++this.mLocRowNr;
                        }
                        this._outputBuffer[var4_4++] = (byte)var6_6;
                        if (++var2_2 < var3_3) continue;
                        break block8;
                    }
                    if ((var6_6 = var1_1[var2_2++]) >= '\u0800') break block15;
                    switch (var5_5[var6_6]) {
                        case 1: {
                            this.reportInvalidChar(var6_6);
                        }
                        case 2: {
                            if (!this._config.willEscapeCR()) {
                                this._outputBuffer[var4_4++] = (byte)var6_6;
                                ++this.mLocRowNr;
                                break;
                            }
                            break block16;
                        }
                        case 3: {
                            break block16;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this._outputPtr = var4_4;
                            this.writeAsEntity(var6_6);
                            break block16;
                        }
                        case 5: {
                            this._outputPtr = var4_4;
                            this.output2ByteChar(var6_6);
                            break block16;
                        }
                        case 11: {
                            if (var2_2 < var3_3 && var1_1[var2_2] != '>') ** GOTO lbl43
                            this._outputPtr = var4_4;
                            this.writeAsEntity(var6_6);
                            break block16;
                        }
lbl43:
                        // 2 sources

                        default: {
                            this._outputBuffer[var4_4++] = (byte)var6_6;
                            break;
                        }
                    }
                    continue;
                }
                this._outputPtr = var4_4;
                var2_2 = this.outputMultiByteChar(var6_6, var1_1, var2_2, var3_3);
            }
            if (var3_3 - var2_2 >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            var4_4 = this._outputPtr;
        }
        this._outputPtr = var4_4;
    }

    private final void writeSplitCharacters(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block8: while (n < n2) {
            char c;
            block16: {
                block15: {
                    int[] nArray = this.mCharTypes.TEXT_CHARS;
                    while ((c = cArray[n]) < '\u0800') {
                        if (nArray[c] != 0) {
                            if (c != '\n') break;
                            ++this.mLocRowNr;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = (byte)c;
                        if (++n < n2) continue;
                        break block8;
                    }
                    if ((c = cArray[n++]) >= '\u0800') break block15;
                    switch (nArray[c]) {
                        case 1: {
                            this.reportInvalidChar(c);
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(c);
                                continue block8;
                            }
                            ++this.mLocRowNr;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(c);
                            continue block8;
                        }
                        case 5: {
                            this.output2ByteChar(c);
                            break;
                        }
                        case 11: {
                            if (n >= n2 || cArray[n] == '>') {
                                this.writeAsEntity(c);
                                continue block8;
                            } else {
                                break;
                            }
                        }
                    }
                    break block16;
                }
                this.writeAsEntity(c);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (asciiValueEncoder.bufferNeedsFlush(n = this._outputBufferLen - this._outputPtr)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName wName, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        this.writeAttrNameEqQ(wName);
        int n = this._outputBufferLen - this._outputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 34;
    }

    @Override
    public int writeComment(String string) throws IOException, XMLStreamException {
        int n;
        this.writeCommentStart();
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this.mCopyBuffer;
            n = cArray.length;
            int n3 = i < n ? i : n;
            string.getChars(n2, n2 + n3, cArray, 0);
            int n4 = this.writeCommentContents(cArray, 0, n3);
            if (n4 >= 0) {
                return n2 + n4;
            }
            n2 += n;
        }
        this.writeCommentEnd();
        return -1;
    }

    protected int writeCommentContents(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block7: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            while ((c = cArray[n]) < '\u0800' && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                if (++n < n2) continue;
                break block7;
            }
            if ((c = cArray[n++]) < '\u0800') {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        ++this.mLocRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", c);
                    }
                    case 5: {
                        this.output2ByteChar(c);
                        continue block7;
                    }
                    case 13: {
                        if (n < n2 && cArray[n] != '-') break;
                        this.writeRaw((byte)45, (byte)32);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                continue;
            }
            n = this.outputMultiByteChar(c, cArray, n, n2);
        }
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException, XMLStreamException {
        this.writeRaw(string, 0, string.length());
    }

    @Override
    public void writeDTD(WName wName, String string, String string2, String string3) throws IOException, XMLStreamException {
    }

    protected int writePIData(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block7: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            while ((c = cArray[n]) < '\u0800' && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                if (++n < n2) continue;
                break block7;
            }
            if ((c = cArray[n++]) < '\u0800') {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        ++this.mLocRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", c);
                    }
                    case 5: {
                        this.output2ByteChar(c);
                        continue block7;
                    }
                    case 12: {
                        if (n >= n2 || cArray[n] != '>') break;
                        return n;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                continue;
            }
            n = this.outputMultiByteChar(c, cArray, n, n2);
        }
        return -1;
    }

    @Override
    public void writeEntityReference(WName wName) throws IOException, XMLStreamException {
        this.writeRaw((byte)38);
        this.writeName(wName);
        this.writeRaw((byte)59);
    }

    @Override
    public int writePI(WName wName, String string) throws IOException, XMLStreamException {
        this.writeRaw((byte)60, (byte)63);
        this.writeName(wName);
        if (string != null) {
            int n;
            this.writeRaw((byte)32);
            int n2 = 0;
            for (int i = string.length(); i > 0; i -= n) {
                char[] cArray = this.mCopyBuffer;
                n = cArray.length;
                if (n > i) {
                    n = i;
                }
                string.getChars(n2, n2 + n, cArray, 0);
                int n3 = this.writePIData(cArray, 0, n);
                if (n3 >= 0) {
                    return n2 + n3;
                }
                n2 += n;
            }
        }
        this.writeRaw((byte)63, (byte)62);
        return -1;
    }

    @Override
    public final void writeSpace(String string) throws IOException, XMLStreamException {
        int n;
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this.mCopyBuffer;
            int n3 = cArray.length;
            n = i < n3 ? i : n3;
            string.getChars(n2, n2 + n, cArray, 0);
            this.writeSpace(cArray, 0, n);
            n2 += n;
        }
    }

    @Override
    public void writeSpace(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this.mSurrogate != 0) {
            this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, this.mSurrogate, n - 1);
        }
        n2 += n;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) > ' ' && (!this._config.isXml11() || c != '\u0085' && c != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, c, n - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c;
        }
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException, XMLStreamException {
        this.writeRaw(BYTES_XMLDECL_START);
        this.writeRaw(string, 0, string.length());
        this.writeRaw((byte)39);
        if (string2 != null && string2.length() > 0) {
            this.writeRaw(BYTES_XMLDECL_ENCODING);
            this.writeRaw(string2, 0, string2.length());
            this.writeRaw((byte)39);
        }
        if (string3 != null) {
            this.writeRaw(BYTES_XMLDECL_STANDALONE);
            this.writeRaw(string3, 0, string3.length());
            this.writeRaw((byte)39);
        }
        this.writeRaw((byte)63, (byte)62);
    }

    protected final void writeCDataStart() throws IOException {
        this.writeRaw(BYTES_CDATA_START);
    }

    protected final void writeCDataEnd() throws IOException {
        this.writeRaw(BYTES_CDATA_END);
    }

    protected final void writeCommentStart() throws IOException {
        this.writeRaw(BYTES_COMMENT_START);
    }

    protected final void writeCommentEnd() throws IOException {
        this.writeRaw(BYTES_COMMENT_END);
    }

    protected final void writeRaw(byte by) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = by;
    }

    protected final void writeRaw(byte by, byte by2) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = by;
        this._outputBuffer[this._outputPtr++] = by2;
    }

    protected final void writeRaw(byte[] byArray) throws IOException {
        this.writeRaw(byArray, 0, byArray.length);
    }

    protected final void writeRaw(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n3 = this._outputPtr) + n2 <= this._outputBufferLen) {
            System.arraycopy(byArray, n, this._outputBuffer, n3, n2);
            this._outputPtr += n2;
            return;
        }
        if (n3 > 0) {
            this.flush();
            n3 = this._outputPtr;
        }
        if (n2 < 250) {
            System.arraycopy(byArray, n, this._outputBuffer, n3, n2);
            this._outputPtr += n2;
        } else {
            this._out.write(byArray, n, n2);
        }
    }

    protected final void throwUnpairedSurrogate() throws IOException {
        int n = this.mSurrogate;
        this.mSurrogate = 0;
        this.throwUnpairedSurrogate(n);
    }

    protected final void throwUnpairedSurrogate(int n) throws IOException {
        this.flush();
        throw new IOException("Unpaired surrogate character (0x" + Integer.toHexString(n) + ")");
    }

    protected final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int n = this._outputPtr;
            this.mLocPastChars += n;
            this.mLocRowStartOffset -= n;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, n);
        }
    }

    protected final void writeAsEntity(int n) throws IOException {
        int n2 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        if (n2 + 10 >= byArray.length) {
            this.flushBuffer();
            n2 = this._outputPtr;
        }
        byArray[n2++] = 38;
        if (n < 256) {
            if (n == 38) {
                byArray[n2++] = 97;
                byArray[n2++] = 109;
                byArray[n2++] = 112;
            } else if (n == 60) {
                byArray[n2++] = 108;
                byArray[n2++] = 116;
            } else if (n == 62) {
                byArray[n2++] = 103;
                byArray[n2++] = 116;
            } else if (n == 39) {
                byArray[n2++] = 97;
                byArray[n2++] = 112;
                byArray[n2++] = 111;
                byArray[n2++] = 115;
            } else if (n == 34) {
                byArray[n2++] = 113;
                byArray[n2++] = 117;
                byArray[n2++] = 111;
                byArray[n2++] = 116;
            } else {
                byArray[n2++] = 35;
                byArray[n2++] = 120;
                if (n >= 16) {
                    int n3 = n >> 4;
                    byArray[n2++] = (byte)(n3 < 10 ? 48 + n3 : 87 + n3);
                    n &= 0xF;
                }
                byArray[n2++] = (byte)(n < 10 ? 48 + n : 87 + n);
            }
        } else {
            byArray[n2++] = 35;
            byArray[n2++] = 120;
            int n4 = 20;
            int n5 = n2;
            do {
                int n6;
                if ((n6 = n >> n4 & 0xF) <= 0 && n2 == n5) continue;
                byArray[n2++] = (byte)(n6 < 10 ? 48 + n6 : 87 + n6);
            } while ((n4 -= 4) > 0);
            byArray[n2++] = (byte)((n &= 0xF) < 10 ? 48 + n : 87 + n);
        }
        byArray[n2++] = 59;
        this._outputPtr = n2;
    }

    protected final int calcSurrogate(int n, int n2, String string) throws XMLStreamException {
        int n3;
        if (n2 < 56320 || n2 > 57343) {
            String string2 = "Incomplete surrogate pair" + string + ": first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2);
            this.reportNwfContent(string2);
        }
        if ((n3 = 65536 + (n - 55296 << 10) + (n2 - 56320)) > 0x10FFFF) {
            this.reportInvalidChar(n3);
        }
        return n3;
    }

    protected static final byte[] getAscii(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        ByteXmlWriter.getAscii(string, byArray, 0);
        return byArray;
    }

    protected static final void getAscii(String string, byte[] byArray) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
    }

    protected static final void getAscii(String string, byte[] byArray, int n) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)string.charAt(i);
        }
    }
}

