/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.sax;

import com.fasterxml.aalto.sax.SAXFeature;
import com.fasterxml.aalto.sax.SAXProperty;
import java.util.HashMap;
import org.xml.sax.SAXNotRecognizedException;

public final class SAXUtil {
    static final HashMap<String, SAXFeature> sStdFeatures;
    static final HashMap<String, SAXProperty> sStdProperties;

    private SAXUtil() {
    }

    public static SAXFeature findStdFeature(String string) {
        if (string.startsWith("http://xml.org/sax/features/")) {
            String string2 = string.substring("http://xml.org/sax/features/".length());
            return sStdFeatures.get(string2);
        }
        return null;
    }

    public static SAXProperty findStdProperty(String string) {
        if (string.startsWith("http://xml.org/sax/properties/")) {
            String string2 = string.substring("http://xml.org/sax/properties/".length());
            return sStdProperties.get(string2);
        }
        return null;
    }

    public static Boolean getFixedStdFeatureValue(SAXFeature sAXFeature) {
        switch (sAXFeature) {
            case EXTERNAL_GENERAL_ENTITIES: {
                return Boolean.FALSE;
            }
            case EXTERNAL_PARAMETER_ENTITIES: {
                return Boolean.FALSE;
            }
            case IS_STANDALONE: {
                break;
            }
            case LEXICAL_HANDLER_PARAMETER_ENTITIES: {
                return Boolean.TRUE;
            }
            case NAMESPACES: {
                return Boolean.TRUE;
            }
            case NAMESPACE_PREFIXES: {
                return Boolean.FALSE;
            }
            case RESOLVE_DTD_URIS: {
                return Boolean.FALSE;
            }
            case STRING_INTERNING: {
                return Boolean.TRUE;
            }
            case UNICODE_NORMALIZATION_CHECKING: {
                return Boolean.FALSE;
            }
            case USE_ATTRIBUTES2: 
            case USE_LOCATOR2: 
            case USE_ENTITY_RESOLVER2: {
                return Boolean.TRUE;
            }
            case VALIDATION: {
                return Boolean.FALSE;
            }
            case XMLNS_URIS: {
                return Boolean.TRUE;
            }
            case XML_1_1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static void reportUnknownFeature(String string) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Feature '" + string + "' not recognized");
    }

    public static void reportUnknownProperty(String string) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Property '" + string + "' not recognized");
    }

    static {
        Enum[] enumArray = SAXFeature.values();
        sStdFeatures = new HashMap(enumArray.length);
        for (Enum enum_ : enumArray) {
            sStdFeatures.put(((SAXFeature)enum_).getSuffix(), (SAXFeature)enum_);
        }
        enumArray = SAXProperty.values();
        sStdProperties = new HashMap(enumArray.length);
        for (Enum enum_ : enumArray) {
            sStdProperties.put(((SAXProperty)enum_).getSuffix(), (SAXProperty)enum_);
        }
    }
}

