/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.UncheckedStreamException;
import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.TextAccumulator;
import com.fasterxml.aalto.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2Util;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class StreamReaderImpl
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo {
    static final int STATE_PROLOG = 0;
    static final int STATE_TREE = 1;
    static final int STATE_EPILOG = 2;
    static final int STATE_CLOSED = 3;
    protected final XmlScanner _scanner;
    protected final boolean _cfgCoalesceText;
    protected final boolean _cfgReportTextAsChars;
    protected int _currToken;
    protected int _parseState;
    protected PName _currName;
    protected int _attrCount;
    protected ValueDecoderFactory _decoderFactory;
    protected CharArrayBase64Decoder _base64Decoder = null;
    protected PName _dtdRootName;
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_TEXT_XXX = 4208;
    private static final int MASK_GET_TEXT_WITH_WRITER = 6776;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    private static final int MASK_TYPED_ACCESS_ARRAY = 4182;
    private static final int MASK_TYPED_ACCESS_BINARY = 4178;

    public StreamReaderImpl(XmlScanner xmlScanner) {
        this._scanner = xmlScanner;
        this._currToken = 7;
        ReaderConfig readerConfig = xmlScanner.getConfig();
        this._cfgCoalesceText = readerConfig.willCoalesceText();
        this._cfgReportTextAsChars = !readerConfig.willReportCData();
    }

    public static StreamReaderImpl construct(InputBootstrapper inputBootstrapper) throws XMLStreamException {
        return new StreamReaderImpl(inputBootstrapper.bootstrap());
    }

    public XmlScanner getScanner() {
        return this._scanner;
    }

    public final String getCharacterEncodingScheme() {
        return this._scanner.getConfig().getXmlDeclEncoding();
    }

    public final String getEncoding() {
        return this._scanner.getConfig().getActualEncoding();
    }

    public String getVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    public final boolean isStandalone() {
        return this._scanner.getConfig().getXmlDeclStandalone() == 1;
    }

    public final boolean standaloneSet() {
        return this._scanner.getConfig().getXmlDeclStandalone() != 0;
    }

    public Object getProperty(String string) {
        if (string.equals("javax.xml.stream.entities")) {
            return Collections.EMPTY_LIST;
        }
        if (string.equals("javax.xml.stream.notations")) {
            return Collections.EMPTY_LIST;
        }
        return this._scanner.getConfig().getProperty(string, false);
    }

    public final int getAttributeCount() {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._attrCount;
    }

    public final String getAttributeLocalName(int n) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return this._scanner.getAttrLocalName(n);
    }

    public final QName getAttributeName(int n) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return this._scanner.getAttrQName(n);
    }

    public final String getAttributeNamespace(int n) {
        String string;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return (string = this._scanner.getAttrNsURI(n)) == null ? "" : string;
    }

    public final String getAttributePrefix(int n) {
        String string;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return (string = this._scanner.getAttrPrefix(n)) == null ? "" : string;
    }

    public final String getAttributeType(int n) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return this._scanner.getAttrType(n);
    }

    public final String getAttributeValue(int n) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (n >= this._attrCount || n < 0) {
            this.reportInvalidAttrIndex(n);
        }
        return this._scanner.getAttrValue(n);
    }

    public final String getAttributeValue(String string, String string2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.getAttrValue(string, string2);
    }

    public final String getElementText() throws XMLStreamException {
        int n;
        int n2;
        if (this._currToken != 1) {
            this.throwWfe(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        do {
            if ((n2 = this.next()) != 2) continue;
            return "";
        } while (n2 == 5 || n2 == 3);
        if ((1 << n2 & 0x1250) == 0) {
            this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(n2) + ".");
        }
        String string = this._scanner.getText();
        TextAccumulator textAccumulator = null;
        while ((n = this.next()) != 2) {
            if ((1 << n & 0x1250) != 0) {
                if (textAccumulator == null) {
                    textAccumulator = new TextAccumulator();
                    textAccumulator.addText(string);
                }
                textAccumulator.addText(this.getText());
                continue;
            }
            if (n == 5 || n == 3) continue;
            this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(n) + ".");
        }
        return textAccumulator == null ? string : textAccumulator.getAndClear();
    }

    public final int getEventType() {
        if (this._currToken == 12 && (this._cfgCoalesceText || this._cfgReportTextAsChars)) {
            return 4;
        }
        return this._currToken;
    }

    public final String getLocalName() {
        if (this._currToken == 1 || this._currToken == 2 || this._currToken == 9) {
            return this._currName.getLocalName();
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    public final QName getName() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getQName();
    }

    public final NamespaceContext getNamespaceContext() {
        return this._scanner;
    }

    public final int getNamespaceCount() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNsCount();
    }

    public final String getNamespacePrefix(int n) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String string = this._scanner.getNamespacePrefix(n);
        return string == null ? "" : string;
    }

    public final String getNamespaceURI() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String string = this._scanner.getNamespaceURI();
        return string == null ? "" : string;
    }

    public final String getNamespaceURI(int n) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String string = this._scanner.getNamespaceURI(n);
        return string == null ? "" : string;
    }

    public final String getNamespaceURI(String string) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNamespaceURI(string);
    }

    public final String getPIData() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final String getPITarget() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this._currName.getLocalName();
    }

    public final String getPrefix() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String string = this._currName.getPrefix();
        return string == null ? "" : string;
    }

    public final String getText() {
        if ((1 << this._currToken & 0x1A70) == 0) {
            this.throwNotTextual(this._currToken);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final char[] getTextCharacters() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final int getTextCharacters(int n, char[] cArray, int n2, int n3) {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters(n, cArray, n2, n3);
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final int getTextLength() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextLength();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final int getTextStart() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        return 0;
    }

    public final boolean hasName() {
        return this._currToken == 1 || this._currToken == 2;
    }

    public final boolean hasNext() {
        return this._currToken != 8;
    }

    public final boolean hasText() {
        return (1 << this._currToken & 0x1A70) != 0;
    }

    public final boolean isAttributeSpecified(int n) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.isAttrSpecified(n);
    }

    public final boolean isCharacters() {
        return this.getEventType() == 4;
    }

    public final boolean isEndElement() {
        return this._currToken == 2;
    }

    public final boolean isStartElement() {
        return this._currToken == 1;
    }

    public final boolean isWhiteSpace() {
        if (this._currToken == 4 || this._currToken == 12) {
            try {
                return this._scanner.isTextWhitespace();
            }
            catch (XMLStreamException xMLStreamException) {
                throw UncheckedStreamException.createFrom(xMLStreamException);
            }
        }
        return this._currToken == 6;
    }

    public final void require(int n, String string, String string2) throws XMLStreamException {
        String string3;
        int n2 = this._currToken;
        if (n2 != n) {
            if (n2 == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    n2 = 4;
                }
            } else if (n2 == 6) {
                // empty if block
            }
        }
        if (n != n2) {
            this.throwWfe("Expected type " + ErrorConsts.tokenTypeDesc(n) + ", current type " + ErrorConsts.tokenTypeDesc(n2));
        }
        if (string2 != null) {
            if (n2 != 1 && n2 != 2 && n2 != 9) {
                this.throwWfe("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
            }
            if ((string3 = this.getLocalName()) != string2 && !string3.equals(string2)) {
                this.throwWfe("Expected local name '" + string2 + "'; current local name '" + string3 + "'.");
            }
        }
        if (string != null) {
            if (n2 != 1 && n2 != 2) {
                this.throwWfe("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(n2) + ")");
            }
            string3 = this.getNamespaceURI();
            if (string.length() == 0) {
                if (string3 != null && string3.length() > 0) {
                    this.throwWfe("Expected empty namespace, instead have '" + string3 + "'.");
                }
            } else if (string != string3 && !string.equals(string3)) {
                this.throwWfe("Expected namespace '" + string + "'; have '" + string3 + "'.");
            }
        }
    }

    public final int next() throws XMLStreamException {
        int n;
        if (this._parseState == 1) {
            int n2 = this._scanner.nextFromTree();
            if (n2 == -1) {
                this.handleTreeEoi();
            }
            this._currToken = n2;
            if (n2 == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    return 4;
                }
            } else {
                this._currName = this._scanner.getName();
                if (n2 == 2) {
                    if (this._scanner.hasEmptyStack()) {
                        this._parseState = 2;
                    }
                } else if (n2 == 1) {
                    this._attrCount = this._scanner.getAttrCount();
                }
            }
            return n2;
        }
        if (this._parseState == 0) {
            n = this._scanner.nextFromProlog(true);
            if (n == 1) {
                this._parseState = 1;
                this._attrCount = this._scanner.getAttrCount();
            } else if (n == 11) {
                if (this._dtdRootName != null) {
                    this.throwWfe("Duplicate DOCTYPE declaration");
                }
                this._dtdRootName = this._scanner.getName();
            }
        } else if (this._parseState == 2) {
            n = this._scanner.nextFromProlog(false);
        } else {
            throw new NoSuchElementException();
        }
        if (n < 0) {
            return this.handlePrologEoi(this._parseState == 0);
        }
        this._currName = this._scanner.getName();
        this._currToken = n;
        return this._currToken;
    }

    public final int nextTag() throws XMLStreamException {
        block5: while (true) {
            int n = this.next();
            switch (n) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwWfe("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return n;
                }
            }
            this.throwWfe("Received event " + ErrorConsts.tokenTypeDesc(n) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public final void close() throws XMLStreamException {
        this._closeScanner(false);
    }

    public final Location getLocation() {
        return this.getStartLocation();
    }

    public final boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder booleanDecoder = this._decoderFactory().getBooleanDecoder();
        this.getElementAs((TypedValueDecoder)booleanDecoder);
        return booleanDecoder.getValue();
    }

    public final int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder intDecoder = this._decoderFactory().getIntDecoder();
        this.getElementAs((TypedValueDecoder)intDecoder);
        return intDecoder.getValue();
    }

    public final long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder longDecoder = this._decoderFactory().getLongDecoder();
        this.getElementAs((TypedValueDecoder)longDecoder);
        return longDecoder.getValue();
    }

    public final float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder floatDecoder = this._decoderFactory().getFloatDecoder();
        this.getElementAs((TypedValueDecoder)floatDecoder);
        return floatDecoder.getValue();
    }

    public final double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder doubleDecoder = this._decoderFactory().getDoubleDecoder();
        this.getElementAs((TypedValueDecoder)doubleDecoder);
        return doubleDecoder.getValue();
    }

    public final BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder integerDecoder = this._decoderFactory().getIntegerDecoder();
        this.getElementAs((TypedValueDecoder)integerDecoder);
        return integerDecoder.getValue();
    }

    public final BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder decimalDecoder = this._decoderFactory().getDecimalDecoder();
        this.getElementAs((TypedValueDecoder)decimalDecoder);
        return decimalDecoder.getValue();
    }

    public final QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder qNameDecoder = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs((TypedValueDecoder)qNameDecoder);
        return this.verifyQName(qNameDecoder.getValue());
    }

    public final byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    public final void getElementAs(TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        String string = this.getElementText();
        if ((string = string.trim()).length() == 0) {
            this._handleEmptyValue(typedValueDecoder);
            return;
        }
        try {
            typedValueDecoder.decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructTypeException(illegalArgumentException, string);
        }
    }

    public final byte[] getElementAsBinary(Base64Variant base64Variant) throws XMLStreamException {
        Stax2Util.ByteAggregator byteAggregator = this._base64Decoder().getByteAggregator();
        byte[] byArray = byteAggregator.startAggregation();
        while (true) {
            int n;
            int n2 = 0;
            int n3 = byArray.length;
            do {
                if ((n = this.readElementAsBinary(byArray, n2, n3, base64Variant)) < 1) {
                    return byteAggregator.aggregateAll(byArray, n2);
                }
                n2 += n;
            } while ((n3 -= n) > 0);
            byArray = byteAggregator.addFullBlock(byArray);
        }
    }

    public final int readElementAsIntArray(int[] nArray, int n, int n2) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getIntArrayDecoder(nArray, n, n2));
    }

    public final int readElementAsLongArray(long[] lArray, int n, int n2) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getLongArrayDecoder(lArray, n, n2));
    }

    public final int readElementAsFloatArray(float[] fArray, int n, int n2) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getFloatArrayDecoder(fArray, n, n2));
    }

    public final int readElementAsDoubleArray(double[] dArray, int n, int n2) throws XMLStreamException {
        return this.readElementAsArray((TypedArrayDecoder)this._decoderFactory().getDoubleArrayDecoder(dArray, n, n2));
    }

    public final int readElementAsArray(TypedArrayDecoder typedArrayDecoder) throws XMLStreamException {
        boolean bl;
        int n = this._currToken;
        if ((1 << n & 0x1056) == 0) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
        }
        if (n == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((n = this.next()) != 2) continue;
                return -1;
            } while (n == 5 || n == 3);
            if (n != 4 && n != 12) {
                throw this._constructUnexpectedInTyped(n);
            }
            bl = true;
        } else {
            bl = false;
        }
        int n2 = 0;
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6) {
                n2 += this._scanner.decodeElements(typedArrayDecoder, bl);
                if (!typedArrayDecoder.hasRoom()) {
                    break;
                }
            } else if (n != 5 && n != 3) {
                throw this._constructUnexpectedInTyped(n);
            }
            bl = true;
            n = this.next();
        }
        return n2 > 0 ? n2 : -1;
    }

    public final int readElementAsBinary(byte[] byArray, int n, int n2) throws XMLStreamException {
        return this.readElementAsBinary(byArray, n, n2, Base64Variants.getDefaultVariant());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readElementAsBinary(byte[] byArray, int n, int n2, Base64Variant base64Variant) throws XMLStreamException {
        if (byArray == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal offset (" + n + "), must be [0, " + byArray.length + "[");
        }
        if (n2 < 1 || n + n2 > byArray.length) {
            if (n2 != 0) throw new IllegalArgumentException("Illegal maxLength (" + n2 + "), has to be positive number, and offset+maxLength can not exceed" + byArray.length);
            return 0;
        }
        CharArrayBase64Decoder charArrayBase64Decoder = this._base64Decoder();
        int n3 = this._currToken;
        if ((1 << n3 & 0x1052) == 0) {
            if (n3 != 2) throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
            if (!charArrayBase64Decoder.hasData()) {
                return -1;
            }
        } else if (n3 == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((n3 = this.next()) != 2) continue;
                return -1;
            } while (n3 == 5 || n3 == 3);
            if (n3 != 4) {
                if (n3 != 12) throw this._constructUnexpectedInTyped(n3);
            }
            this._scanner.resetForDecoding(base64Variant, charArrayBase64Decoder, true);
        }
        int n4 = 0;
        while (true) {
            int n5;
            try {
                n5 = charArrayBase64Decoder.decode(byArray, n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructTypeException(illegalArgumentException.getMessage(), "");
            }
            n += n5;
            n4 += n5;
            if ((n2 -= n5) < 1 || this._currToken == 2) break;
            while ((n3 = this.next()) == 5 || n3 == 3 || n3 == 6) {
            }
            if (n3 == 2) {
                int n6 = charArrayBase64Decoder.endOfContent();
                if (n6 < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (n6 <= 0) break;
                continue;
            }
            this._scanner.resetForDecoding(base64Variant, charArrayBase64Decoder, false);
        }
        if (n4 <= 0) return -1;
        int n7 = n4;
        return n7;
    }

    public final int getAttributeIndex(String string, String string2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this.findAttributeIndex(string, string2);
    }

    public final boolean getAttributeAsBoolean(int n) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder booleanDecoder = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)booleanDecoder);
        return booleanDecoder.getValue();
    }

    public final int getAttributeAsInt(int n) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder intDecoder = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)intDecoder);
        return intDecoder.getValue();
    }

    public final long getAttributeAsLong(int n) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder longDecoder = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)longDecoder);
        return longDecoder.getValue();
    }

    public final float getAttributeAsFloat(int n) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder floatDecoder = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)floatDecoder);
        return floatDecoder.getValue();
    }

    public final double getAttributeAsDouble(int n) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder doubleDecoder = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)doubleDecoder);
        return doubleDecoder.getValue();
    }

    public final BigInteger getAttributeAsInteger(int n) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder integerDecoder = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)integerDecoder);
        return integerDecoder.getValue();
    }

    public final BigDecimal getAttributeAsDecimal(int n) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder decimalDecoder = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(n, (TypedValueDecoder)decimalDecoder);
        return decimalDecoder.getValue();
    }

    public final QName getAttributeAsQName(int n) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder qNameDecoder = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(n, (TypedValueDecoder)qNameDecoder);
        return this.verifyQName(qNameDecoder.getValue());
    }

    public final void getAttributeAs(int n, TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        try {
            this._scanner.decodeAttrValue(n, typedValueDecoder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructTypeException(illegalArgumentException, this.getAttributeValue(n));
        }
    }

    public final int[] getAttributeAsIntArray(int n) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder intArrayDecoder = this._decoderFactory().getIntArrayDecoder();
        this.getAttributeAsArray(n, (TypedArrayDecoder)intArrayDecoder);
        return intArrayDecoder.getValues();
    }

    public final long[] getAttributeAsLongArray(int n) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder longArrayDecoder = this._decoderFactory().getLongArrayDecoder();
        this.getAttributeAsArray(n, (TypedArrayDecoder)longArrayDecoder);
        return longArrayDecoder.getValues();
    }

    public final float[] getAttributeAsFloatArray(int n) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder floatArrayDecoder = this._decoderFactory().getFloatArrayDecoder();
        this.getAttributeAsArray(n, (TypedArrayDecoder)floatArrayDecoder);
        return floatArrayDecoder.getValues();
    }

    public final double[] getAttributeAsDoubleArray(int n) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder doubleArrayDecoder = this._decoderFactory().getDoubleArrayDecoder();
        this.getAttributeAsArray(n, (TypedArrayDecoder)doubleArrayDecoder);
        return doubleArrayDecoder.getValues();
    }

    public final int getAttributeAsArray(int n, TypedArrayDecoder typedArrayDecoder) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrValues(n, typedArrayDecoder);
    }

    public final byte[] getAttributeAsBinary(int n) throws XMLStreamException {
        return this.getAttributeAsBinary(n, Base64Variants.getDefaultVariant());
    }

    public final byte[] getAttributeAsBinary(int n, Base64Variant base64Variant) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrBinaryValue(n, base64Variant, this._base64Decoder());
    }

    protected QName verifyQName(QName qName) throws TypedXMLStreamException {
        String string = qName.getLocalPart();
        int n = XmlNames.findIllegalNameChar(string, false);
        if (n >= 0) {
            String string2 = qName.getPrefix();
            String string3 = string2 != null && string2.length() > 0 ? string2 + ":" + string : string;
            throw this._constructTypeException("Invalid local name \"" + string + "\" (character at #" + n + " is invalid)", string3);
        }
        return qName;
    }

    public final Object getFeature(String string) {
        return null;
    }

    public final void setFeature(String string, Object object) {
    }

    public final boolean isPropertySupported(String string) {
        return this._scanner.getConfig().isPropertySupported(string);
    }

    public final boolean setProperty(String string, Object object) {
        return this._scanner.getConfig().setProperty(string, object);
    }

    public final void skipElement() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int n = 1;
        while (true) {
            int n2;
            if ((n2 = this.next()) == 1) {
                ++n;
                continue;
            }
            if (n2 == 2 && --n == 0) break;
        }
    }

    public final AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this;
    }

    public final DTDInfo getDTDInfo() throws XMLStreamException {
        if (this._currToken != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public final int getText(Writer writer, boolean bl) throws XMLStreamException {
        if ((1 << this._currToken & 0x1A78) == 0) {
            this.throwNotTextual(this._currToken);
        }
        return this._scanner.getText(writer, bl);
    }

    public final int getDepth() {
        int n = this._scanner.getDepth();
        if (this._currToken == 2) {
            ++n;
        }
        return n;
    }

    public final boolean isEmptyElement() throws XMLStreamException {
        return this._currToken == 1 ? this._scanner.isEmptyTag() : false;
    }

    public final NamespaceContext getNonTransientNamespaceContext() {
        return this._scanner.getNonTransientNamespaceContext();
    }

    public final String getPrefixedName() {
        switch (this._currToken) {
            case 1: 
            case 2: {
                return this._currName.getPrefixedName();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public final void closeCompletely() throws XMLStreamException {
        this._closeScanner(true);
    }

    public final Object getProcessedDTD() {
        return null;
    }

    public final String getDTDRootName() {
        if (this._currToken != 11) {
            return null;
        }
        return this._currName == null ? null : this._currName.getPrefixedName();
    }

    public final String getDTDPublicId() {
        return this._scanner.getDTDPublicId();
    }

    public final String getDTDSystemId() {
        return this._scanner.getDTDSystemId();
    }

    public final String getDTDInternalSubset() {
        if (this._currToken != 11) {
            return null;
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw UncheckedStreamException.createFrom(xMLStreamException);
        }
    }

    public final DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public final long getStartingByteOffset() {
        return -1L;
    }

    public final long getStartingCharOffset() {
        return -1L;
    }

    public final long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public final long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public final XMLStreamLocation2 getStartLocation() {
        return this._scanner.getStartLocation();
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return this._scanner.getEndLocation();
    }

    public final XMLStreamLocation2 getCurrentLocation() {
        return this._scanner.getStartLocation();
    }

    public final int findAttributeIndex(String string, String string2) {
        return this._scanner.findAttrIndex(string, string2);
    }

    public final int getIdAttributeIndex() {
        return -1;
    }

    public final int getNotationAttributeIndex() {
        return -1;
    }

    public final XMLValidator validateAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        return null;
    }

    public final XMLValidator stopValidatingAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        return null;
    }

    public final XMLValidator stopValidatingAgainst(XMLValidator xMLValidator) throws XMLStreamException {
        return null;
    }

    public final ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler validationProblemHandler) {
        return null;
    }

    protected Location getLastCharLocation() {
        return this._scanner.getCurrentLocation();
    }

    protected int handlePrologEoi(boolean bl) throws XMLStreamException {
        this.close();
        if (bl) {
            this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_PROLOG);
        }
        return 8;
    }

    protected void handleTreeEoi() throws XMLStreamException {
        this._currToken = 8;
        this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_TREE);
    }

    protected void throwWfe(String string) throws XMLStreamException {
        throw new WFCException(string, this.getLastCharLocation());
    }

    private void throwNotTextual(int n) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    private void throwNotTextXxx(int n) {
        throw new IllegalStateException("getTextXxx() methods can not be called on " + ErrorConsts.tokenTypeDesc(this._currToken));
    }

    protected void throwFromIOE(IOException iOException) throws XMLStreamException {
        throw new IoStreamException(iOException);
    }

    protected void throwUnexpectedEOI(String string) throws XMLStreamException {
        this.throwWfe("Unexpected End-of-input" + string);
    }

    protected XMLStreamException _constructUnexpectedInTyped(int n) {
        if (n == 1) {
            return this._constructTypeException("Element content can not contain child START_ELEMENT when using Typed Access methods", null);
        }
        return this._constructTypeException("Expected a text token, got " + ErrorConsts.tokenTypeDesc(n), null);
    }

    private TypedXMLStreamException _constructTypeException(IllegalArgumentException illegalArgumentException, String string) {
        return new TypedXMLStreamException(string, illegalArgumentException.getMessage(), (Location)this.getStartLocation(), illegalArgumentException);
    }

    private TypedXMLStreamException _constructTypeException(String string, String string2) {
        return new TypedXMLStreamException(string2, string, (Location)this.getStartLocation());
    }

    protected void reportInvalidAttrIndex(int n) {
        throw new IllegalArgumentException("Illegal attribute index, " + n + ", current START_ELEMENT has " + this._attrCount + " attributes");
    }

    protected void _closeScanner(boolean bl) throws XMLStreamException {
        if (this._parseState != 3) {
            this._parseState = 3;
            if (this._currToken != 8) {
                this._currToken = 8;
            }
        }
        this._scanner.close(bl);
    }

    protected final ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected CharArrayBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new CharArrayBase64Decoder();
        }
        return this._base64Decoder;
    }

    private void _handleEmptyValue(TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        try {
            typedValueDecoder.handleEmptyValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructTypeException(illegalArgumentException, "");
        }
    }

    public final String toString() {
        return "[Aalto stream reader, scanner: " + this._scanner + "]";
    }
}

