/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class TestScannerPerf {
    static final int INT_AMP = 38;
    static final int INT_LT = 60;
    static final int INT_RBRACKET = 93;
    static final int INT_SPACE = 32;
    static final int INT_TAB = 9;
    static final int INT_CR = 13;
    static final int INT_LF = 10;
    static final byte BYTE_LF = 10;
    static final byte BYTE_NULL = 0;
    final int mRepCount;
    int mTmpChar = 0;
    final byte[] mData;
    final byte[] mInputBuffer = new byte[4000];
    final char[] mOutputBuffer = new char[2000];
    static final int MB_CODE_BASE = 5;
    static final int[] CHAR_TYPES;
    InputStream mIn;
    int mLineNr;
    int mByteCount;
    int mTagCount;
    int mEntityCount;
    int mBracketCount;
    int mInputPtr;
    int mInputLen;
    int mTmpType = 0;

    public TestScannerPerf(byte[] byArray, int n) {
        this.mData = byArray;
        this.mRepCount = n;
    }

    public void test() throws IOException {
        int n = 0;
        this.mIn = new ByteArrayInputStream(this.mData);
        while (true) {
            long l = System.currentTimeMillis();
            String string = "[null]";
            int n2 = 0;
            if (n % 3 == 0) {
                System.out.println();
            }
            block10: for (int i = 0; i < this.mRepCount; ++i) {
                this.mIn.reset();
                this.mLineNr = 0;
                this.mTagCount = 0;
                this.mByteCount = 0;
                switch (n % 3) {
                    case 0: {
                        string = "[Scanner-code]";
                        n2 += this.testScannerCode();
                        continue block10;
                    }
                    case 1: {
                        string = "[Scanner-int-arr]";
                        n2 += this.testScannerInts();
                        continue block10;
                    }
                    case 2: {
                        string = "[Scanner-int-arr2]";
                        n2 += this.testScannerInts2();
                        continue block10;
                    }
                    default: {
                        throw new Error("Unexpected round, #" + i);
                    }
                }
            }
            l = System.currentTimeMillis() - l;
            System.out.println(string + " -> " + l + " msecs (total " + n2 + ", byte count 0x" + Integer.toHexString(this.mByteCount) + ")");
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private int testScannerCode() throws IOException {
        char[] cArray = this.mOutputBuffer;
        int n = 0;
        int n2 = 0;
        this.mInputLen = 0;
        this.mInputPtr = 0;
        block0: while (true) {
            int n3 = this.mInputPtr;
            while (true) {
                if (n3 >= this.mInputLen) {
                    if (!this.loadMoreBytes()) break block0;
                    n3 = this.mInputPtr;
                }
                if ((n2 = this.mInputBuffer[n3++]) <= 93) {
                    if (n2 < 0) break;
                    if (n2 < 32) {
                        if (n2 == 13) {
                            ++this.mLineNr;
                        } else if (n2 == 10) {
                            ++this.mLineNr;
                        } else if (n2 != 9) {
                            throw new Error();
                        }
                    } else if (n2 == 60) {
                        ++this.mTagCount;
                    } else if (n2 == 38) {
                        ++this.mEntityCount;
                    } else if (n2 == 93) {
                        ++this.mBracketCount;
                    }
                }
                if (n >= cArray.length) {
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            if ((n2 = this.decodeMultiByteChar(n2, n3)) < 0) {
                if (n >= cArray.length) {
                    n = 0;
                }
                n2 = -n2;
                cArray[n++] = (char)(0xD800 | n2 >> 10);
                n2 = 0xDC00 | n2 & 0x3FF;
            }
            if (n >= cArray.length) {
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        return this.mByteCount;
    }

    private int testScannerInts() throws IOException {
        int n = 0;
        int n2 = 0;
        int[] nArray = CHAR_TYPES;
        byte[] byArray = this.mInputBuffer;
        char[] cArray = this.mOutputBuffer;
        this.mInputLen = 0;
        this.mInputPtr = 0;
        block8: while (true) {
            int n3 = this.mInputPtr;
            block9: while (true) {
                int n4;
                if (n3 >= this.mInputLen) {
                    if (!this.loadMoreBytes()) break block8;
                    n3 = this.mInputPtr;
                }
                if ((n4 = nArray[n2 = byArray[n3++] & 0xFF]) != 0) {
                    switch (n4) {
                        case 1: {
                            throw new Error("Invalid white space");
                        }
                        case 2: {
                            if (n2 == 13) {
                                ++this.mLineNr;
                                break;
                            }
                            if (n2 != 10) break;
                            ++this.mLineNr;
                            break;
                        }
                        case 3: {
                            ++this.mTagCount;
                            break;
                        }
                        case 4: {
                            ++this.mEntityCount;
                            break;
                        }
                        case 5: {
                            ++this.mBracketCount;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            break block9;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
                if (n >= cArray.length) {
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            n2 = this.decodeMultiByteChar(n2, n3);
            if (n2 < 0) {
                if (n >= cArray.length) {
                    n = 0;
                }
                n2 = -n2;
                cArray[n++] = (char)(0xD800 | n2 >> 10);
                n2 = 0xDC00 | n2 & 0x3FF;
            }
            if (n >= cArray.length) {
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        return this.mByteCount;
    }

    private int testScannerInts2() throws IOException {
        int n = 0;
        int n2 = 0;
        int[] nArray = CHAR_TYPES;
        byte[] byArray = this.mInputBuffer;
        char[] cArray = this.mOutputBuffer;
        this.mInputLen = 0;
        this.mInputPtr = 0;
        while (true) {
            int n3;
            block19: {
                int n4;
                int n5;
                if ((n3 = this.mInputPtr) >= this.mInputLen) {
                    if (!this.loadMoreBytes()) break;
                    n3 = this.mInputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this.mOutputBuffer;
                    n = 0;
                }
                if ((n5 = n3 + (cArray.length - n)) < (n4 = this.mInputLen)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block19;
                }
                this.mInputPtr = n3;
                continue;
            }
            this.mInputPtr = n3;
            switch (nArray[n2]) {
                case 1: {
                    throw new Error("Invalid white space");
                }
                case 2: {
                    if (n2 == 13) {
                        ++this.mLineNr;
                        break;
                    }
                    if (n2 != 10) break;
                    ++this.mLineNr;
                    break;
                }
                case 3: {
                    ++this.mTagCount;
                    break;
                }
                case 4: {
                    ++this.mEntityCount;
                    break;
                }
                case 5: {
                    ++this.mBracketCount;
                    break;
                }
                case 6: {
                    n2 = this.decodeMultiByteChar(n2, this.mInputPtr);
                    break;
                }
                case 7: {
                    n2 = this.decodeMultiByteChar(n2, this.mInputPtr);
                    break;
                }
                case 8: {
                    n2 = this.decodeMultiByteChar(n2, this.mInputPtr);
                    if (n >= cArray.length) {
                        cArray = this.mOutputBuffer;
                        n = 0;
                    }
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (n >= cArray.length) {
                cArray = this.mOutputBuffer;
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        return this.mByteCount;
    }

    private final boolean loadMoreBytes() throws IOException {
        this.mByteCount += this.mInputLen;
        this.mInputPtr = 0;
        int n = this.mIn.read(this.mInputBuffer);
        if (n < 0) {
            this.mInputLen = 0;
            return false;
        }
        this.mInputLen = n;
        return true;
    }

    private final void loadMoreBytesGuaranteed() throws IOException {
        if (!this.loadMoreBytes()) {
            throw new Error();
        }
    }

    private final int decodeMultiByteChar(int n, int n2) throws IOException {
        byte by;
        int n3;
        if ((n & 0xE0) == 192) {
            n &= 0x1F;
            n3 = 1;
        } else if ((n & 0xF0) == 224) {
            n &= 0xF;
            n3 = 2;
        } else if ((n & 0xF8) == 240) {
            n &= 7;
            n3 = 3;
        } else {
            throw new Error("Unexpected multi-byte first byte 0x" + Integer.toHexString(n));
        }
        if (n2 >= this.mInputLen) {
            this.loadMoreBytesGuaranteed();
            n2 = this.mInputPtr;
        }
        if (((by = this.mInputBuffer[n2++]) & 0xC0) != 128) {
            throw new Error();
        }
        n = n << 6 | by & 0x3F;
        if (n3 > 1) {
            if (n2 >= this.mInputLen) {
                this.loadMoreBytesGuaranteed();
                n2 = this.mInputPtr;
            }
            if (((by = this.mInputBuffer[n2++]) & 0xC0) != 128) {
                throw new Error();
            }
            n = n << 6 | by & 0x3F;
            if (n3 > 2) {
                if (n2 >= this.mInputLen) {
                    this.loadMoreBytesGuaranteed();
                    n2 = this.mInputPtr;
                }
                if (((by = this.mInputBuffer[n2++]) & 0xC0) != 128) {
                    throw new Error();
                }
                n = n << 6 | by & 0x3F;
                return -n;
            }
        }
        this.mInputPtr = n2;
        return n;
    }

    private static byte[] readData(File file) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        FileInputStream fileInputStream = new FileInputStream(file);
        for (n2 = (int)file.length(); n2 > 0; n2 -= n) {
            n = fileInputStream.read(byArray, n3, n2 - n3);
            n3 += n;
        }
        fileInputStream.close();
        return byArray;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... [input file]");
            System.exit(1);
        }
        byte[] byArray = TestScannerPerf.readData(new File(stringArray[0]));
        int n = byArray.length;
        int n2 = 1;
        int n3 = 10000000;
        if (n < n3) {
            n2 = n3 / n;
        }
        System.out.println("Ok, read in test data, " + n + " bytes; using " + n2 + " repetitions");
        new TestScannerPerf(byArray, n2).test();
    }

    static {
        int n;
        CHAR_TYPES = new int[256];
        for (n = 128; n < 256; ++n) {
            int n2 = n;
            int n3 = (n2 & 0xE0) == 192 ? 6 : ((n2 & 0xF0) == 224 ? 7 : ((n2 & 0xF8) == 240 ? 8 : 1));
            TestScannerPerf.CHAR_TYPES[n2] = n3;
        }
        for (n = 0; n < 32; ++n) {
            TestScannerPerf.CHAR_TYPES[n] = 1;
        }
        TestScannerPerf.CHAR_TYPES[13] = 2;
        TestScannerPerf.CHAR_TYPES[10] = 2;
        TestScannerPerf.CHAR_TYPES[9] = 0;
        TestScannerPerf.CHAR_TYPES[60] = 3;
        TestScannerPerf.CHAR_TYPES[38] = 4;
        TestScannerPerf.CHAR_TYPES[93] = 5;
    }
}

