/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.manager.BeanManagerImpl;

public class FastEvent<T> {
    private static final Type EVENT_METADATA_INSTANCE_TYPE = new TypeLiteral<Instance<EventMetadata>>(){}.getType();
    private final Set<ObserverMethod<? super T>> resolvedObserverMethods;

    private static boolean isMetadataRequired(Set<? extends ObserverMethod<?>> resolvedObserverMethods) {
        for (ObserverMethod<?> observer : resolvedObserverMethods) {
            if (observer instanceof ObserverMethodImpl) {
                ObserverMethodImpl observerImpl = (ObserverMethodImpl)observer;
                for (WeldInjectionPointAttributes<?, ?> ip : observerImpl.getInjectionPoints()) {
                    Type type = ip.getType();
                    if (!EventMetadata.class.equals((Object)type) && !EVENT_METADATA_INSTANCE_TYPE.equals(type)) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public static <T> FastEvent<T> of(Class<T> type, BeanManagerImpl manager, Annotation ... qualifiers) {
        return FastEvent.of(type, manager, manager.getAccessibleLenientObserverNotifier(), qualifiers);
    }

    public static <T> FastEvent<T> of(Class<T> type, BeanManagerImpl manager, ObserverNotifier notifier, Annotation ... qualifiers) {
        Set<ObserverMethod<? super T>> resolvedObserverMethods = notifier.resolveObserverMethods(notifier.buildEventResolvable(type, qualifiers));
        if (FastEvent.isMetadataRequired(resolvedObserverMethods)) {
            EventMetadataImpl metadata = new EventMetadataImpl((Type)type, qualifiers);
            CurrentEventMetadata metadataService = (CurrentEventMetadata)manager.getServices().get(CurrentEventMetadata.class);
            return new FastEventWithMetadataPropagation(resolvedObserverMethods, metadata, metadataService);
        }
        return new FastEvent<T>(resolvedObserverMethods);
    }

    private FastEvent(Set<ObserverMethod<? super T>> resolvedObserverMethods) {
        this.resolvedObserverMethods = resolvedObserverMethods;
    }

    public void fire(T event) {
        for (ObserverMethod<? super T> observerMethod : this.resolvedObserverMethods) {
            observerMethod.notify(event);
        }
    }

    private static class EventMetadataImpl
    implements EventMetadata {
        private final Set<Annotation> qualifiers;
        private final Type type;

        private EventMetadataImpl(Type type, Annotation ... qualifiers) {
            this.type = type;
            this.qualifiers = ImmutableSet.copyOf((Object[])qualifiers);
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public InjectionPoint getInjectionPoint() {
            return null;
        }

        public Type getType() {
            return this.type;
        }
    }

    private static class FastEventWithMetadataPropagation<T>
    extends FastEvent<T> {
        private final EventMetadata metadata;
        private final CurrentEventMetadata metadataService;

        private FastEventWithMetadataPropagation(Set<ObserverMethod<? super T>> resolvedObserverMethods, EventMetadata metadata, CurrentEventMetadata metadataService) {
            super(resolvedObserverMethods);
            this.metadata = metadata;
            this.metadataService = metadataService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(T event) {
            if (this.metadata != null) {
                this.metadataService.push(this.metadata);
            }
            try {
                super.fire(event);
            }
            finally {
                if (this.metadata != null) {
                    this.metadataService.pop();
                }
            }
        }
    }
}

