/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.batch.operations.JobStartException;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobMerger;
import org.jberet.job.model.JobParser;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ArchiveXmlLoader {
    public static final String ARCHIVE_JOB_XML_DIR = "META-INF/batch-jobs/";
    public static final String ARCHIVE_BATCH_XML = "META-INF/batch.xml";

    public static BatchArtifacts loadBatchXml(ClassLoader classLoader) throws JobStartException {
        BatchArtifacts batchArtifacts = null;
        InputStream is = classLoader.getResourceAsStream(ARCHIVE_BATCH_XML);
        if (is == null) {
            return null;
        }
        try {
            batchArtifacts = JobParser.parseBatchArtifacts(is);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseBatchXml(e, ARCHIVE_BATCH_XML);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return batchArtifacts;
    }

    public static Job loadJobXml(String jobName, ClassLoader classLoader, List<Job> loadedJobs) throws JobStartException {
        InputStream is;
        for (Job j : loadedJobs) {
            if (!jobName.equals(j.getId())) continue;
            return j;
        }
        Job job = null;
        try {
            is = ArchiveXmlLoader.getJobXml(jobName, classLoader);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failToGetJobXml(e, jobName);
        }
        try {
            job = JobParser.parseJob(is, classLoader);
            loadedJobs.add(job);
            if (!job.getInheritingJobElements().isEmpty()) {
                JobMerger.resolveInheritance(job, classLoader, loadedJobs);
            }
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseJobXml(e, jobName);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return job;
    }

    private static InputStream getJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        String path;
        InputStream is;
        if (!jobXml.endsWith(".xml")) {
            jobXml = jobXml + ".xml";
        }
        if ((is = classLoader.getResourceAsStream(path = ARCHIVE_JOB_XML_DIR + jobXml)) != null) {
            return is;
        }
        File jobFile = null;
        String jobpath = WildFlySecurityManager.getPropertyPrivileged((String)"javax.jobpath", null);
        if (jobpath != null && !jobpath.isEmpty()) {
            String p;
            String[] jobPathElements;
            String[] stringArray = jobPathElements = jobpath.split(":");
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (jobFile = new File(p = stringArray[i], jobXml)).exists() && jobFile.isFile()); ++i) {
            }
        }
        if (!(jobFile != null || (jobFile = new File(WildFlySecurityManager.getPropertyPrivileged((String)"user.dir", (String)"."), jobXml)).exists() && jobFile.isFile())) {
            jobFile = new File(jobXml);
        }
        is = new BufferedInputStream(new FileInputStream(jobFile));
        return is;
    }
}

