/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.repository.AbstractRepository;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.TableColumns;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class JdbcRepository
extends AbstractRepository {
    public static final String DDL_FILE_NAME_KEY = "ddl-file";
    public static final String SQL_FILE_NAME_KEY = "sql-file";
    public static final String DATASOURCE_JNDI_KEY = "datasource-jndi";
    public static final String DB_URL_KEY = "db-url";
    public static final String DB_USER_KEY = "db-user";
    public static final String DB_PASSWORD_KEY = "db-password";
    public static final String DB_PROPERTIES_KEY = "db-properties";
    public static final String DB_PROPERTY_DELIM = ":";
    private static final String DEFAULT_DB_URL = "jdbc:h2:~/jberet-repo";
    private static final String DEFAULT_SQL_FILE = "sql/jberet-sql.properties";
    private static final String DEFAULT_DDL_FILE = "sql/jberet.ddl";
    private static final String SELECT_ALL_JOB_INSTANCES = "select-all-job-instances";
    private static final String COUNT_JOB_INSTANCES_BY_JOB_NAME = "count-job-instances-by-job-name";
    private static final String SELECT_JOB_INSTANCES_BY_JOB_NAME = "select-job-instances-by-job-name";
    private static final String SELECT_JOB_INSTANCE = "select-job-instance";
    private static final String INSERT_JOB_INSTANCE = "insert-job-instance";
    private static final String SELECT_ALL_JOB_EXECUTIONS = "select-all-job-executions";
    private static final String SELECT_JOB_EXECUTIONS_BY_JOB_INSTANCE_ID = "select-job-executions-by-job-instance-id";
    private static final String SELECT_JOB_EXECUTION = "select-job-execution";
    private static final String INSERT_JOB_EXECUTION = "insert-job-execution";
    private static final String UPDATE_JOB_EXECUTION = "update-job-execution";
    private static final String UPDATE_JOB_EXECUTION_PARTIAL = "update-job-execution-partial";
    private static final String SELECT_ALL_STEP_EXECUTIONS = "select-all-step-executions";
    private static final String SELECT_STEP_EXECUTIONS_BY_JOB_EXECUTION_ID = "select-step-executions-by-job-execution-id";
    private static final String SELECT_STEP_EXECUTION = "select-step-execution";
    private static final String INSERT_STEP_EXECUTION = "insert-step-execution";
    private static final String UPDATE_STEP_EXECUTION = "update-step-execution";
    private static final String FIND_ORIGINAL_STEP_EXECUTION = "find-original-step-execution";
    private static final String COUNT_STEP_EXECUTIONS_BY_JOB_INSTANCE_ID = "count-step-executions-by-job-instance-id";
    private static final String COUNT_PARTITION_EXECUTIONS = "count-partition-executions";
    private static final String SELECT_PARTITION_EXECUTIONS_BY_STEP_EXECUTION_ID = "select-partition-executions-by-step-execution-id";
    private static final String INSERT_PARTITION_EXECUTION = "insert-partition-execution";
    private static final String UPDATE_PARTITION_EXECUTION = "update-partition-execution";
    private final Properties configProperties;
    private String dataSourceName;
    private DataSource dataSource;
    private String dbUrl;
    private final Properties dbProperties;
    private final Properties sqls = new Properties();
    private boolean isOracle;
    private int[] idIndexInOracle;

    public static JdbcRepository create(Properties configProperties) {
        return new JdbcRepository(configProperties);
    }

    public JdbcRepository(Properties configProperties) {
        this.configProperties = configProperties;
        this.dataSourceName = configProperties.getProperty(DATASOURCE_JNDI_KEY);
        this.dbUrl = configProperties.getProperty(DB_URL_KEY);
        this.dbProperties = new Properties();
        if (this.dataSourceName != null) {
            this.dataSourceName = this.dataSourceName.trim();
        }
        if (this.dataSourceName != null && !this.dataSourceName.isEmpty()) {
            try {
                this.dataSource = (DataSource)InitialContext.doLookup(this.dataSourceName);
            }
            catch (NamingException e) {
                throw BatchMessages.MESSAGES.failToLookupDataSource(e, this.dataSourceName);
            }
        } else {
            String s;
            String dbPassword;
            String dbUser;
            if (this.dbUrl != null) {
                this.dbUrl = this.dbUrl.trim();
            }
            if (this.dbUrl == null || this.dbUrl.isEmpty()) {
                this.dbUrl = DEFAULT_DB_URL;
            }
            if ((dbUser = configProperties.getProperty(DB_USER_KEY)) != null) {
                this.dbProperties.setProperty("user", dbUser.trim());
            }
            if ((dbPassword = configProperties.getProperty(DB_PASSWORD_KEY)) != null) {
                this.dbProperties.setProperty("password", dbPassword.trim());
            }
            if ((s = configProperties.getProperty(DB_PROPERTIES_KEY)) != null) {
                String[] ss;
                for (String kv : ss = s.trim().split(DB_PROPERTY_DELIM)) {
                    int equalSign = kv.indexOf(61);
                    if (equalSign <= 0) continue;
                    this.dbProperties.setProperty(kv.substring(0, equalSign), kv.substring(equalSign + 1));
                }
            }
        }
        String sqlFile = configProperties.getProperty(SQL_FILE_NAME_KEY);
        if (sqlFile != null) {
            sqlFile = sqlFile.trim();
        }
        if (sqlFile == null || sqlFile.isEmpty()) {
            sqlFile = DEFAULT_SQL_FILE;
        }
        InputStream sqlResource = JdbcRepository.getClassLoader().getResourceAsStream(sqlFile);
        try {
            if (sqlResource == null) {
                throw BatchMessages.MESSAGES.failToLoadSqlProperties(null, sqlFile);
            }
            this.sqls.load(sqlResource);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failToLoadSqlProperties(e, sqlFile);
        }
        finally {
            if (sqlResource != null) {
                try {
                    sqlResource.close();
                }
                catch (IOException e) {
                    BatchLogger.LOGGER.failToClose(e, InputStream.class, sqlResource);
                }
            }
        }
        this.createTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables() {
        String countPartitionExecutions = this.sqls.getProperty(COUNT_PARTITION_EXECUTIONS);
        Connection connection1 = this.getConnection();
        ResultSet rs = null;
        PreparedStatement countPartitionExecutionStatement = null;
        InputStream ddlResource = null;
        String databaseProductName = "";
        try {
            databaseProductName = connection1.getMetaData().getDatabaseProductName().trim();
        }
        catch (SQLException e) {
            BatchLogger.LOGGER.failToGetDatabaseProductName(e, connection1);
            this.close(connection1, null, null, null);
            connection1 = this.getConnection();
        }
        catch (Exception e) {
            BatchLogger.LOGGER.failToGetDatabaseProductName(e, connection1);
        }
        if (databaseProductName.startsWith("Oracle")) {
            this.isOracle = true;
            this.idIndexInOracle = new int[]{1};
        }
        try {
            countPartitionExecutionStatement = connection1.prepareStatement(countPartitionExecutions);
            rs = countPartitionExecutionStatement.executeQuery();
        }
        catch (SQLException e) {
            String ddlFile = this.getDDLLocation(databaseProductName);
            ddlResource = JdbcRepository.getClassLoader().getResourceAsStream(ddlFile);
            if (ddlResource == null) {
                throw BatchMessages.MESSAGES.failToLoadDDL(ddlFile);
            }
            Scanner scanner = new Scanner(ddlResource).useDelimiter("!!");
            Connection connection2 = null;
            Statement batchDDLStatement = null;
            try {
                connection2 = this.getConnection();
                batchDDLStatement = connection2.createStatement();
                while (scanner.hasNext()) {
                    String ddlEntry = scanner.next().trim();
                    if (ddlEntry.isEmpty()) continue;
                    batchDDLStatement.addBatch(ddlEntry);
                    BatchLogger.LOGGER.addDDLEntry(ddlEntry);
                }
                scanner.close();
                batchDDLStatement.executeBatch();
            }
            catch (Exception e1) {
                throw BatchMessages.MESSAGES.failToCreateTables(e1, databaseProductName, ddlFile);
            }
            finally {
                this.close(connection2, batchDDLStatement, null, null);
            }
            BatchLogger.LOGGER.tableCreated(ddlFile);
        }
        finally {
            this.close(connection1, countPartitionExecutionStatement, null, rs);
            try {
                if (ddlResource != null) {
                    ddlResource.close();
                }
            }
            catch (Exception e) {
                BatchLogger.LOGGER.failToClose(e, InputStream.class, ddlResource);
            }
        }
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId) {
        List<StepExecution> stepExecutions = super.getStepExecutions(jobExecutionId);
        if (stepExecutions.isEmpty()) {
            stepExecutions = this.selectStepExecutions(jobExecutionId);
        }
        return stepExecutions;
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        String insert = this.sqls.getProperty(INSERT_JOB_INSTANCE);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setString(1, jobInstance.getJobName());
            preparedStatement.setString(2, jobInstance.getApplicationName());
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            jobInstance.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(jobInstance, jobInstance.getInstanceId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        String select = jobName == null ? this.sqls.getProperty(SELECT_ALL_JOB_INSTANCES) : this.sqls.getProperty(SELECT_JOB_INSTANCES_BY_JOB_NAME);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        try {
            preparedStatement = connection.prepareStatement(select);
            if (jobName != null) {
                preparedStatement.setString(1, jobName);
            }
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                long i = rs.getLong("JOBINSTANCEID");
                JobInstanceImpl jobInstance1 = (JobInstanceImpl)this.jobInstances.get(i);
                if (jobInstance1 == null) {
                    String appName = rs.getString("APPLICATIONNAME");
                    if (jobName == null) {
                        String goodJobName = rs.getString("JOBNAME");
                        jobInstance1 = new JobInstanceImpl(this.getJob(goodJobName), new ApplicationAndJobName(appName, goodJobName));
                    } else {
                        jobInstance1 = new JobInstanceImpl(this.getJob(jobName), new ApplicationAndJobName(appName, jobName));
                    }
                    jobInstance1.setId(i);
                    this.jobInstances.put(i, jobInstance1);
                }
                result.add(jobInstance1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        JobInstance result = super.getJobInstance(jobInstanceId);
        if (result != null) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_JOB_INSTANCE);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobInstanceId);
            rs = preparedStatement.executeQuery();
            if (rs.next() && (result = (JobInstance)this.jobInstances.get(jobInstanceId)) == null) {
                String appName = rs.getString("APPLICATIONNAME");
                String goodJobName = rs.getString("JOBNAME");
                result = new JobInstanceImpl(this.getJob(goodJobName), new ApplicationAndJobName(appName, goodJobName));
                ((JobInstanceImpl)result).setId(jobInstanceId);
                this.jobInstances.put(jobInstanceId, result);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        String select = this.sqls.getProperty(COUNT_JOB_INSTANCES_BY_JOB_NAME);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setString(1, jobName);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        String insert = this.sqls.getProperty(INSERT_JOB_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setLong(1, jobExecution.getJobInstance().getInstanceId());
            preparedStatement.setTimestamp(2, new Timestamp(jobExecution.getCreateTime().getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(jobExecution.getStartTime().getTime()));
            preparedStatement.setString(4, jobExecution.getBatchStatus().name());
            preparedStatement.setString(5, BatchUtil.propertiesToString(jobExecution.getJobParameters()));
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            jobExecution.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(jobExecution, jobExecution.getExecutionId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate) {
        super.updateJobExecution(jobExecution, fullUpdate);
        String update = fullUpdate ? this.sqls.getProperty(UPDATE_JOB_EXECUTION) : this.sqls.getProperty(UPDATE_JOB_EXECUTION_PARTIAL);
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(update);
            if (fullUpdate) {
                preparedStatement.setTimestamp(1, new Timestamp(jobExecution.getEndTime().getTime()));
                preparedStatement.setTimestamp(2, new Timestamp(jobExecution.getLastUpdatedTime().getTime()));
                preparedStatement.setString(3, jobExecution.getBatchStatus().name());
                preparedStatement.setString(4, jobExecution.getExitStatus());
                preparedStatement.setString(5, jobExecution.getRestartPosition());
                preparedStatement.setLong(6, jobExecution.getExecutionId());
            } else {
                preparedStatement.setTimestamp(1, new Timestamp(jobExecution.getLastUpdatedTime().getTime()));
                preparedStatement.setString(2, jobExecution.getBatchStatus().name());
                preparedStatement.setLong(3, jobExecution.getExecutionId());
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, update);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        JobExecutionImpl result = (JobExecutionImpl)super.getJobExecution(jobExecutionId);
        if (result != null) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_JOB_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobExecutionId);
            rs = preparedStatement.executeQuery();
            if (rs.next() && (result = (JobExecutionImpl)this.jobExecutions.get(jobExecutionId)) == null) {
                long jobInstanceId = rs.getLong("JOBINSTANCEID");
                result = new JobExecutionImpl((JobInstanceImpl)this.getJobInstance(jobInstanceId), jobExecutionId, BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS")), rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                this.jobExecutions.put(jobExecutionId, result);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        String select;
        long jobInstanceId = 0L;
        if (jobInstance == null) {
            select = this.sqls.getProperty(SELECT_ALL_JOB_EXECUTIONS);
        } else {
            select = this.sqls.getProperty(SELECT_JOB_EXECUTIONS_BY_JOB_INSTANCE_ID);
            jobInstanceId = jobInstance.getInstanceId();
        }
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        try {
            preparedStatement = connection.prepareStatement(select);
            if (jobInstance != null) {
                preparedStatement.setLong(1, jobInstanceId);
            }
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                long i = rs.getLong("JOBEXECUTIONID");
                JobExecution jobExecution1 = (JobExecution)this.jobExecutions.get(i);
                if (jobExecution1 == null) {
                    if (jobInstanceId == 0L) {
                        jobInstanceId = rs.getLong("JOBINSTANCEID");
                    }
                    Properties jobParameters1 = BatchUtil.stringToProperties(rs.getString("JOBPARAMETERS"));
                    jobExecution1 = new JobExecutionImpl((JobInstanceImpl)this.getJobInstance(jobInstanceId), i, jobParameters1, rs.getTimestamp("CREATETIME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getTimestamp("LASTUPDATEDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), rs.getString("RESTARTPOSITION"));
                    this.jobExecutions.put(i, jobExecution1);
                }
                result.add(jobExecution1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        String insert = this.sqls.getProperty(INSERT_STEP_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.isOracle ? connection.prepareStatement(insert, this.idIndexInOracle) : connection.prepareStatement(insert, 1);
            preparedStatement.setLong(1, jobExecution.getExecutionId());
            preparedStatement.setString(2, stepExecution.getStepName());
            preparedStatement.setTimestamp(3, new Timestamp(stepExecution.getStartTime().getTime()));
            preparedStatement.setString(4, stepExecution.getBatchStatus().name());
            preparedStatement.executeUpdate();
            rs = preparedStatement.getGeneratedKeys();
            rs.next();
            stepExecution.setId(rs.getLong(1));
            BatchLogger.LOGGER.persisted(stepExecution, stepExecution.getStepExecutionId());
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        String update = this.sqls.getProperty(UPDATE_STEP_EXECUTION);
        Connection connection = this.getConnection();
        StepExecutionImpl stepExecutionImpl = (StepExecutionImpl)stepExecution;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(update);
            preparedStatement.setTimestamp(1, new Timestamp(stepExecution.getEndTime().getTime()));
            preparedStatement.setString(2, stepExecution.getBatchStatus().name());
            preparedStatement.setString(3, stepExecution.getExitStatus());
            preparedStatement.setString(4, TableColumns.formatException(stepExecutionImpl.getException()));
            preparedStatement.setBytes(5, BatchUtil.objectToBytes(stepExecution.getPersistentUserData()));
            preparedStatement.setLong(6, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_COUNT));
            preparedStatement.setLong(7, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_COUNT));
            preparedStatement.setLong(8, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.COMMIT_COUNT));
            preparedStatement.setLong(9, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.ROLLBACK_COUNT));
            preparedStatement.setLong(10, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_SKIP_COUNT));
            preparedStatement.setLong(11, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.PROCESS_SKIP_COUNT));
            preparedStatement.setLong(12, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.FILTER_COUNT));
            preparedStatement.setLong(13, stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_SKIP_COUNT));
            preparedStatement.setBytes(14, BatchUtil.objectToBytes(stepExecutionImpl.getReaderCheckpointInfo()));
            preparedStatement.setBytes(15, BatchUtil.objectToBytes(stepExecutionImpl.getWriterCheckpointInfo()));
            preparedStatement.setLong(16, stepExecution.getStepExecutionId());
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, update);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        super.savePersistentData(jobExecution, stepOrPartitionExecution);
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            this.updateStepExecution(stepOrPartitionExecution);
        } else {
            PartitionExecutionImpl partitionExecution = (PartitionExecutionImpl)stepOrPartitionExecution;
            String update = this.sqls.getProperty(UPDATE_PARTITION_EXECUTION);
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(update);
                preparedStatement.setString(1, partitionExecution.getBatchStatus().name());
                preparedStatement.setString(2, partitionExecution.getExitStatus());
                preparedStatement.setString(3, TableColumns.formatException(partitionExecution.getException()));
                preparedStatement.setBytes(4, BatchUtil.objectToBytes(partitionExecution.getPersistentUserData()));
                preparedStatement.setBytes(5, BatchUtil.objectToBytes(partitionExecution.getReaderCheckpointInfo()));
                preparedStatement.setBytes(6, BatchUtil.objectToBytes(partitionExecution.getWriterCheckpointInfo()));
                preparedStatement.setInt(7, partitionExecution.getPartitionId());
                preparedStatement.setLong(8, partitionExecution.getStepExecutionId());
                preparedStatement.executeUpdate();
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.failToRunQuery(e, update);
            }
            finally {
                this.close(connection, preparedStatement, null, null);
            }
        }
    }

    StepExecution selectStepExecution(long stepExecutionId) {
        String select = this.sqls.getProperty(SELECT_STEP_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<StepExecution> result = new ArrayList<StepExecution>();
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, stepExecutionId);
            rs = preparedStatement.executeQuery();
            this.createStepExecutionsFromResultSet(rs, result, false);
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return (StepExecution)result.get(0);
    }

    List<StepExecution> selectStepExecutions(Long jobExecutionId) {
        String select = jobExecutionId == null ? this.sqls.getProperty(SELECT_ALL_STEP_EXECUTIONS) : this.sqls.getProperty(SELECT_STEP_EXECUTIONS_BY_JOB_EXECUTION_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        ArrayList<StepExecution> result = new ArrayList<StepExecution>();
        try {
            preparedStatement = connection.prepareStatement(select);
            if (jobExecutionId != null) {
                preparedStatement.setLong(1, jobExecutionId);
            }
            rs = preparedStatement.executeQuery();
            this.createStepExecutionsFromResultSet(rs, result, false);
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        super.addPartitionExecution(enclosingStepExecution, partitionExecution);
        String insert = this.sqls.getProperty(INSERT_PARTITION_EXECUTION);
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(insert);
            preparedStatement.setInt(1, partitionExecution.getPartitionId());
            preparedStatement.setLong(2, partitionExecution.getStepExecutionId());
            preparedStatement.setString(3, partitionExecution.getBatchStatus().name());
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, insert);
        }
        finally {
            this.close(connection, preparedStatement, null, null);
        }
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart) {
        StepExecutionImpl result = super.findOriginalStepExecutionForRestart(stepName, jobExecutionToRestart);
        if (result != null) {
            return result;
        }
        String select = this.sqls.getProperty(FIND_ORIGINAL_STEP_EXECUTION);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        ArrayList<StepExecution> results = new ArrayList<StepExecution>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, jobExecutionToRestart.getJobInstance().getInstanceId());
            preparedStatement.setString(2, stepName);
            rs = preparedStatement.executeQuery();
            this.createStepExecutionsFromResultSet(rs, results, true);
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return results.size() > 0 ? (StepExecutionImpl)results.get(0) : null;
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly) {
        List<PartitionExecutionImpl> result = super.getPartitionExecutions(stepExecutionId, stepExecution, notCompletedOnly);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        String select = this.sqls.getProperty(SELECT_PARTITION_EXECUTIONS_BY_STEP_EXECUTION_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        result = new ArrayList<PartitionExecutionImpl>();
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setLong(1, stepExecutionId);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String batchStatusValue = rs.getString("BATCHSTATUS");
                if (notCompletedOnly && BatchStatus.COMPLETED.name().equals(batchStatusValue)) continue;
                result.add(new PartitionExecutionImpl(rs.getInt("PARTITIONEXECUTIONID"), rs.getLong("STEPEXECUTIONID"), stepExecution.getStepName(), BatchStatus.valueOf((String)batchStatusValue), rs.getString("EXITSTATUS"), BatchUtil.bytesToSerializableObject(rs.getBytes("PERSISTENTUSERDATA")), BatchUtil.bytesToSerializableObject(rs.getBytes("READERCHECKPOINTINFO")), BatchUtil.bytesToSerializableObject(rs.getBytes("WRITERCHECKPOINTINFO"))));
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return result;
    }

    private void createStepExecutionsFromResultSet(ResultSet rs, List<StepExecution> result, boolean top1) throws SQLException, ClassNotFoundException, IOException {
        while (rs.next()) {
            StepExecutionImpl e = new StepExecutionImpl(rs.getLong("STEPEXECUTIONID"), rs.getString("STEPNAME"), rs.getTimestamp("STARTTIME"), rs.getTimestamp("ENDTIME"), rs.getString("BATCHSTATUS"), rs.getString("EXITSTATUS"), BatchUtil.bytesToSerializableObject(rs.getBytes("PERSISTENTUSERDATA")), rs.getInt("READCOUNT"), rs.getInt("WRITECOUNT"), rs.getInt("COMMITCOUNT"), rs.getInt("ROLLBACKCOUNT"), rs.getInt("READSKIPCOUNT"), rs.getInt("PROCESSSKIPCOUNT"), rs.getInt("FILTERCOUNT"), rs.getInt("WRITESKIPCOUNT"), BatchUtil.bytesToSerializableObject(rs.getBytes("READERCHECKPOINTINFO")), BatchUtil.bytesToSerializableObject(rs.getBytes("WRITERCHECKPOINTINFO")));
            result.add(e);
            if (!top1) continue;
            return;
        }
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        String select = this.sqls.getProperty(COUNT_STEP_EXECUTIONS_BY_JOB_INSTANCE_ID);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        PreparedStatement preparedStatement = null;
        int count = 0;
        try {
            preparedStatement = connection.prepareStatement(select);
            preparedStatement.setString(1, stepName);
            preparedStatement.setLong(2, jobInstanceId);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.close(connection, preparedStatement, null, rs);
        }
        catch (Exception e) {
            try {
                throw BatchMessages.MESSAGES.failToRunQuery(e, select);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, null, rs);
                throw throwable;
            }
        }
        return count;
    }

    private Connection getConnection() {
        if (this.dataSource != null) {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw BatchMessages.MESSAGES.failToObtainConnection(e, this.dataSource, this.dataSourceName);
            }
        }
        try {
            return DriverManager.getConnection(this.dbUrl, this.dbProperties);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToObtainConnection(e, this.dbUrl, this.dbProperties);
        }
    }

    private void close(Connection conn, Statement stmt1, Statement stmt2, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, ResultSet.class, rs);
            }
        }
        if (stmt1 != null) {
            try {
                stmt1.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, PreparedStatement.class, stmt1);
            }
        }
        if (stmt2 != null) {
            try {
                stmt2.close();
            }
            catch (SQLException e) {
                BatchLogger.LOGGER.failToClose(e, PreparedStatement.class, stmt2);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            BatchLogger.LOGGER.failToClose(e, Connection.class, conn);
        }
    }

    private String getDDLLocation(String databaseProductName) {
        String ddlFile = this.configProperties.getProperty(DDL_FILE_NAME_KEY);
        if (ddlFile != null && !(ddlFile = ddlFile.trim()).isEmpty()) {
            BatchLogger.LOGGER.ddlFileAndDatabaseProductName(ddlFile, databaseProductName);
            return ddlFile;
        }
        ddlFile = databaseProductName.contains("MySQL") ? "sql/jberet-mysql.ddl" : (databaseProductName.startsWith("Oracle") ? "sql/jberet-oracle.ddl" : (databaseProductName.contains("PostgreSQL") ? "sql/jberet-postgresql.ddl" : (databaseProductName.startsWith("Microsoft SQL Server") ? "sql/jberet-mssqlserver.ddl" : (databaseProductName.contains("DB2") ? "sql/jberet-db2.ddl" : (databaseProductName.contains("Adaptive Server Enterprise") || databaseProductName.contains("Sybase") ? "sql/jberet-sybase.ddl" : (databaseProductName.contains("Derby") ? "sql/jberet-derby.ddl" : (databaseProductName.startsWith("Firebird") ? "sql/jberet-firebird.ddl" : DEFAULT_DDL_FILE)))))));
        BatchLogger.LOGGER.ddlFileAndDatabaseProductName(ddlFile, databaseProductName);
        return ddlFile;
    }

    private static ClassLoader getClassLoader() {
        if (WildFlySecurityManager.isChecking()) {
            return (ClassLoader)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return JdbcRepository.class.getClassLoader();
                }
            });
        }
        return JdbcRepository.class.getClassLoader();
    }
}

