/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;

public final class JobExecutionRunner
extends CompositeExecutionRunner<JobContextImpl>
implements Runnable {
    private final Job job;

    public JobExecutionRunner(JobContextImpl jobContext) {
        super(jobContext, null);
        this.job = jobContext.getJob();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.job.getJobElements();
    }

    @Override
    public void run() {
        if (((JobContextImpl)this.batchContext).getBatchStatus() != BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
            ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(((JobContextImpl)this.batchContext).getJobExecution(), false);
        }
        Object[] jobListeners = ((JobContextImpl)this.batchContext).getJobListeners();
        try {
            int i;
            boolean beforeJobFailed = false;
            try {
                for (i = 0; i < jobListeners.length; ++i) {
                    jobListeners[i].beforeJob();
                }
            }
            catch (Throwable e) {
                beforeJobFailed = true;
                BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", jobListeners[i]);
                ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
            }
            if (!beforeJobFailed) {
                this.runFromHeadOrRestartPoint(((JobContextImpl)this.batchContext).getJobExecution().getRestartPosition());
            }
            try {
                for (i = 0; i < jobListeners.length; ++i) {
                    jobListeners[i].afterJob();
                }
            }
            catch (Throwable e) {
                BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", jobListeners[i]);
                ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
            }
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", this.job);
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
        }
        ((JobContextImpl)this.batchContext).destroyArtifact(jobListeners);
        if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
        } else if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
        }
        ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(((JobContextImpl)this.batchContext).getJobExecution(), true);
        ((JobContextImpl)this.batchContext).getJobExecution().cleanUp();
    }
}

