/*
 * Decompiled with CFR 0.152.
 */
package org.beanio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import org.beanio.BeanIOConfigurationException;
import org.beanio.BeanIOException;
import org.beanio.BeanReader;
import org.beanio.BeanReaderException;
import org.beanio.BeanReaderIOException;
import org.beanio.BeanWriter;
import org.beanio.BeanWriterIOException;
import org.beanio.Marshaller;
import org.beanio.Unmarshaller;
import org.beanio.builder.StreamBuilder;
import org.beanio.internal.util.IOUtil;
import org.beanio.internal.util.Settings;

public abstract class StreamFactory {
    private ClassLoader classLoader;

    public BeanReader createReader(String name, String filename) throws IllegalArgumentException, BeanReaderIOException {
        return this.createReader(name, new File(filename));
    }

    public BeanReader createReader(String name, File file) throws IllegalArgumentException, BeanReaderIOException {
        if (!this.isMapped(name)) {
            throw new IllegalArgumentException("No stream mapping configured for name '" + name + "'");
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            return this.createReader(name, in);
        }
        catch (IOException ex) {
            IOUtil.closeQuietly(in);
            throw new BeanReaderException("Failed to open file '" + file + "' for reading", ex);
        }
        catch (RuntimeException ex) {
            IOUtil.closeQuietly(in);
            throw ex;
        }
    }

    public BeanReader createReader(String name, Reader in) throws IllegalArgumentException {
        return this.createReader(name, in, Locale.getDefault());
    }

    public abstract BeanReader createReader(String var1, Reader var2, Locale var3) throws IllegalArgumentException;

    public Unmarshaller createUnmarshaller(String name) throws IllegalArgumentException {
        return this.createUnmarshaller(name, null);
    }

    public abstract Unmarshaller createUnmarshaller(String var1, Locale var2);

    public BeanWriter createWriter(String name, File file) throws IllegalArgumentException, BeanWriterIOException {
        if (!this.isMapped(name)) {
            throw new IllegalArgumentException("No stream mapping configured for name '" + name + "'");
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file));
            return this.createWriter(name, out);
        }
        catch (IOException ex) {
            IOUtil.closeQuietly(out);
            throw new BeanWriterIOException("Failed to open file '" + file + "' for writing", ex);
        }
        catch (RuntimeException ex) {
            IOUtil.closeQuietly(out);
            throw ex;
        }
    }

    public abstract BeanWriter createWriter(String var1, Writer var2) throws IllegalArgumentException;

    public abstract Marshaller createMarshaller(String var1) throws IllegalArgumentException;

    public abstract void define(StreamBuilder var1) throws BeanIOConfigurationException;

    public void loadResource(String resource) throws BeanIOException, BeanIOConfigurationException {
        this.loadResource(resource, null);
    }

    public void loadResource(String resource, Properties properties) throws BeanIOException, BeanIOConfigurationException {
        InputStream in = null;
        try {
            in = this.getClassLoader().getResourceAsStream(resource);
            if (in == null) {
                throw new BeanIOConfigurationException("BeanIO mapping file '" + resource + "' not found on classpath");
            }
            this.load(in, properties);
        }
        catch (IOException ex) {
            try {
                throw new BeanIOException("Failed to load resource '" + resource + "' from classpath", ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(in);
    }

    public void load(String filename) throws BeanIOException, BeanIOConfigurationException {
        this.load(filename, null);
    }

    public void load(String filename, Properties properties) throws BeanIOException, BeanIOConfigurationException {
        this.load(new File(filename), properties);
    }

    public void load(File file) throws BeanIOException, BeanIOConfigurationException {
        this.load(file, null);
    }

    public void load(File file, Properties properties) throws BeanIOException, BeanIOConfigurationException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.load(in, properties);
        }
        catch (IOException ex) {
            try {
                throw new BeanIOException("Failed to load '" + file + "' from the file system", ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(in);
    }

    public void load(InputStream in) throws IOException, BeanIOConfigurationException {
        this.load(in, null);
    }

    public abstract void load(InputStream var1, Properties var2) throws IOException, BeanIOConfigurationException;

    public static StreamFactory newInstance() throws BeanIOException {
        return StreamFactory.newInstance(null);
    }

    public static StreamFactory newInstance(ClassLoader classLoader) throws BeanIOException {
        String className;
        if (classLoader == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (classLoader == null) {
                classLoader = StreamFactory.class.getClassLoader();
            }
        }
        if ((className = Settings.getInstance(classLoader).getProperty("org.beanio.streamFactory")) == null) {
            throw new BeanIOException("Property 'org.beanio.streamFactory' not set");
        }
        try {
            StreamFactory factory = className.startsWith("org.beanio.") ? (StreamFactory)StreamFactory.class.getClassLoader().loadClass(className).newInstance() : (StreamFactory)classLoader.loadClass(className).newInstance();
            factory.setClassLoader(classLoader);
            factory.init();
            return factory;
        }
        catch (Exception ex) {
            throw new BeanIOException("Failed to load stream factory implementation class '" + className + "'", ex);
        }
    }

    public abstract boolean isMapped(String var1);

    protected void init() {
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }
}

