/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.builder;

import org.beanio.BeanIOConfigurationException;
import org.beanio.builder.GroupBuilderSupport;
import org.beanio.builder.ParserBuilder;
import org.beanio.internal.config.BeanConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.config.TypeHandlerConfig;
import org.beanio.stream.RecordParserFactory;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamBuilder
extends GroupBuilderSupport<StreamBuilder> {
    protected StreamConfig config = new StreamConfig();

    public StreamBuilder(String name) {
        this.config.setName(name);
    }

    public StreamBuilder(String name, String format) {
        this.config.setName(name);
        this.config.setFormat(format);
    }

    @Override
    protected StreamBuilder me() {
        return this;
    }

    @Override
    protected GroupConfig getConfig() {
        return this.config;
    }

    public StreamBuilder format(String format) {
        this.config.setFormat(format);
        return this;
    }

    public StreamBuilder parser(RecordParserFactory parser) {
        BeanConfig<RecordParserFactory> bc = new BeanConfig<RecordParserFactory>();
        bc.setInstance(parser);
        this.config.setParserFactory(bc);
        return this;
    }

    public StreamBuilder parser(ParserBuilder parser) {
        this.config.setParserFactory(parser.build());
        return this;
    }

    public StreamBuilder addTypeHandler(String name, Class<?> type, TypeHandler handler) {
        TypeHandlerConfig thc = new TypeHandlerConfig();
        thc.setName(name);
        if (type != null) {
            thc.setType(type.getName());
        }
        thc.setInstance(handler);
        this.config.addHandler(thc);
        return this;
    }

    public StreamBuilder addTypeHandler(String name, TypeHandler handler) {
        return this.addTypeHandler(name, null, handler);
    }

    public StreamBuilder addTypeHandler(Class<?> type, TypeHandler handler) {
        return this.addTypeHandler(null, type, handler);
    }

    @Override
    public StreamBuilder type(Class<?> type) {
        throw new BeanIOConfigurationException("type not supported by StreamBuilder");
    }

    @Override
    public StreamBuilder collection(Class<?> type) {
        throw new BeanIOConfigurationException("collection not supported by StreamBuilder");
    }

    public StreamBuilder readOnly() {
        this.config.setMode("read");
        return this;
    }

    public StreamBuilder writeOnly() {
        this.config.setMode("write");
        return this;
    }

    public StreamBuilder resourceBundle(String name) {
        this.config.setResourceBundle(name);
        return this;
    }

    public StreamBuilder strict() {
        this.config.setStrict(true);
        return this;
    }

    public StreamBuilder ignoreUnidentifiedRecords() {
        this.config.setIgnoreUnidentifiedRecords(true);
        return this;
    }

    public StreamConfig build() {
        return this.config;
    }
}

