/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.accessor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.beanio.BeanIOException;
import org.beanio.internal.asm.ClassWriter;
import org.beanio.internal.asm.MethodVisitor;
import org.beanio.internal.asm.Opcodes;
import org.beanio.internal.asm.Type;
import org.beanio.internal.compiler.PropertyAccessorFactory;
import org.beanio.internal.parser.PropertyAccessor;
import org.beanio.internal.parser.accessor.PropertyAccessorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmAccessorFactory
implements Opcodes,
PropertyAccessorFactory {
    private static final String CG_PACKAGE = "org/beanio/internal/cg/";
    private static final Type supportType = Type.getType(PropertyAccessorSupport.class);
    private AsmClassLoader classLoader = new AsmClassLoader(this.getClass().getClassLoader());

    public AsmAccessorFactory(ClassLoader classLoader) {
    }

    @Override
    public PropertyAccessor getPropertyAccessor(Class<?> parent, PropertyDescriptor descriptor, int carg) {
        return this.getPropertyAccessor(parent, descriptor.getPropertyType(), descriptor.getName(), descriptor.getReadMethod(), descriptor.getWriteMethod(), null, carg);
    }

    @Override
    public PropertyAccessor getPropertyAccessor(Class<?> parent, Field field, int carg) {
        return this.getPropertyAccessor(parent, field.getType(), field.getName(), null, null, field, carg);
    }

    private PropertyAccessor getPropertyAccessor(Class<?> parent, Class<?> propertyClass, String propertyName, Method readMethod, Method writeMethod, Field field, int carg) {
        Type parentType = Type.getType(parent);
        Type accessorType = Type.getObjectType(CG_PACKAGE + parentType.getInternalName() + "_" + propertyName + "_PropertyAccessorImpl");
        PropertyAccessorSupport support = this.createAccessor(accessorType.getClassName());
        if (support != null) {
            support.setConstructorArgumentIndex(carg);
            return support;
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, accessorType.getInternalName(), null, "org/beanio/internal/parser/accessor/PropertyAccessorSupport", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, supportType.getInternalName(), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (readMethod != null) {
            this.invokeGetter(mv, readMethod.getName(), parentType, parent, propertyClass);
        } else if (field != null) {
            this.invokeGetField(mv, propertyName, parentType, propertyClass);
        } else {
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        }
        mv.visitEnd();
        mv = cw.visitMethod(1, "setValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        if (writeMethod != null) {
            this.invokeSetter(mv, writeMethod.getName(), parentType, propertyClass);
        } else if (field != null) {
            this.invokeSetField(mv, propertyName, parentType, propertyClass);
        } else {
            mv.visitInsn(177);
            mv.visitMaxs(0, 3);
        }
        mv.visitEnd();
        cw.visitEnd();
        support = this.createAccessor(this.classLoader.defineClass(accessorType.getClassName(), cw.toByteArray()));
        support.setConstructorArgumentIndex(carg);
        return support;
    }

    private void invokeGetter(MethodVisitor mv, String method, Type parent, Class<?> parentClass, Class<?> property) {
        int opcode;
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, parent.getInternalName());
        int n = opcode = parentClass.isInterface() ? 185 : 182;
        if (!property.isPrimitive()) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()" + Type.getType(property).getReturnType());
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Integer.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()I");
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Long.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()J");
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
        } else if (property == Boolean.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()Z");
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Character.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()C");
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Double.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()D");
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
        } else if (property == Float.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()F");
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Short.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()S");
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Byte.TYPE) {
            mv.visitMethodInsn(opcode, parent.getInternalName(), method, "()B");
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        }
    }

    private void invokeGetField(MethodVisitor mv, String field, Type parent, Class<?> property) {
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, parent.getInternalName());
        if (!property.isPrimitive()) {
            Type type = Type.getType(property);
            mv.visitFieldInsn(180, parent.getInternalName(), field, type.getReturnType().toString());
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Integer.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "I");
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Long.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "J");
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
        } else if (property == Boolean.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "Z");
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Character.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "C");
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Double.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "D");
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
        } else if (property == Float.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "F");
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Short.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "S");
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else if (property == Byte.TYPE) {
            mv.visitFieldInsn(180, parent.getInternalName(), field, "B");
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        }
    }

    private void invokeSetter(MethodVisitor mv, String method, Type parent, Class<?> property) {
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, parent.getInternalName());
        mv.visitVarInsn(25, 2);
        if (!property.isPrimitive()) {
            Type type = Type.getType(property);
            mv.visitTypeInsn(192, type.getInternalName());
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(" + type.getReturnType() + ")V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Boolean.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(Z)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Integer.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(I)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Long.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(J)V");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
        } else if (property == Character.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(C)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Double.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(D)V");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
        } else if (property == Float.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(F)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Short.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(S)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Byte.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
            mv.visitMethodInsn(182, parent.getInternalName(), method, "(B)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        }
    }

    private void invokeSetField(MethodVisitor mv, String field, Type parent, Class<?> property) {
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, parent.getInternalName());
        mv.visitVarInsn(25, 2);
        if (!property.isPrimitive()) {
            Type type = Type.getType(property);
            mv.visitTypeInsn(192, type.getInternalName());
            mv.visitFieldInsn(181, parent.getInternalName(), field, type.getReturnType().toString());
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Boolean.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "Z");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Integer.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "I");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Long.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "J");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
        } else if (property == Character.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "C");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Double.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "D");
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
        } else if (property == Float.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "F");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Short.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "S");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        } else if (property == Byte.TYPE) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
            mv.visitFieldInsn(181, parent.getInternalName(), field, "B");
            mv.visitInsn(177);
            mv.visitMaxs(2, 3);
        }
    }

    protected PropertyAccessorSupport createAccessor(String name) {
        try {
            return this.createAccessor(this.classLoader.loadClass(name));
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    protected PropertyAccessorSupport createAccessor(Class<?> supportClass) {
        try {
            return (PropertyAccessorSupport)supportClass.newInstance();
        }
        catch (Exception e) {
            throw new BeanIOException("ASM accessor factory failed to instantiate class '" + supportClass.getName() + "'", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AsmClassLoader
    extends ClassLoader {
        public AsmClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] b) throws ClassFormatError {
            return super.defineClass(name, b, 0, b.length);
        }
    }
}

