/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.xml;

import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.ParserFactorySupport;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.compiler.xml.XmlPreprocessor;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.Record;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.Segment;
import org.beanio.internal.parser.Stream;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.xml.XmlAttributeField;
import org.beanio.internal.parser.format.xml.XmlElementField;
import org.beanio.internal.parser.format.xml.XmlFieldFormat;
import org.beanio.internal.parser.format.xml.XmlSelectorWrapper;
import org.beanio.internal.parser.format.xml.XmlStreamFormat;
import org.beanio.internal.parser.format.xml.XmlTextField;
import org.beanio.internal.parser.format.xml.XmlWrapper;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.xml.XmlRecordParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParserFactory
extends ParserFactorySupport {
    private int groupDepth = 0;
    private int maxGroupDepth = 0;

    @Override
    protected Preprocessor createPreprocessor(StreamConfig config) {
        return new XmlPreprocessor(config);
    }

    @Override
    public Stream createStream(StreamConfig config) throws BeanIOConfigurationException {
        Stream stream = super.createStream(config);
        ((XmlStreamFormat)stream.getFormat()).setLayout(stream.getLayout());
        ((XmlStreamFormat)stream.getFormat()).setGroupDepth(this.maxGroupDepth);
        return stream;
    }

    @Override
    protected void initializeGroupMain(GroupConfig config, Property bean) {
        if (!"none".equals(config.getXmlType())) {
            XmlSelectorWrapper wrapper = new XmlSelectorWrapper();
            wrapper.setName(config.getName());
            wrapper.setLocalName(config.getXmlName());
            wrapper.setNamespace(config.getXmlNamespace());
            wrapper.setNamespaceAware(config.isXmlNamespaceAware());
            wrapper.setPrefix(config.getXmlPrefix());
            wrapper.setGroup(true);
            wrapper.setDepth(this.groupDepth++);
            this.pushParser(wrapper);
            this.maxGroupDepth = Math.max(this.groupDepth, this.maxGroupDepth);
        }
        super.initializeGroupMain(config, bean);
    }

    @Override
    protected Property finalizeGroupMain(GroupConfig config) throws BeanIOConfigurationException {
        Property property = super.finalizeGroupMain(config);
        if (!"none".equals(config.getXmlType())) {
            this.popParser();
            --this.groupDepth;
        }
        return property;
    }

    @Override
    protected void initializeRecordMain(RecordConfig config, Property bean) {
        XmlSelectorWrapper wrapper = new XmlSelectorWrapper();
        wrapper.setName(config.getName());
        wrapper.setLocalName(config.getXmlName());
        wrapper.setNamespace(config.getXmlNamespace());
        wrapper.setNamespaceAware(config.isXmlNamespaceAware());
        wrapper.setPrefix(config.getXmlPrefix());
        wrapper.setGroup(false);
        wrapper.setDepth(this.groupDepth);
        this.pushParser(wrapper);
        super.initializeRecordMain(config, bean);
    }

    @Override
    protected Property finalizeRecordMain(RecordConfig config) throws BeanIOConfigurationException {
        Property property = super.finalizeRecordMain(config);
        this.popParser();
        return property;
    }

    @Override
    protected void finalizeRecord(RecordConfig config, Record record) {
        super.finalizeRecord(config, record);
        record.setExistencePredetermined(true);
    }

    @Override
    protected boolean isSegmentRequired(SegmentConfig config) {
        if (config.isConstant()) {
            return false;
        }
        if (config.getType() != null) {
            return true;
        }
        if (!"element".equals(config.getXmlType())) {
            return false;
        }
        return config.getChildren().size() > 1;
    }

    @Override
    protected void initializeSegmentMain(SegmentConfig config, Property property) {
        if (this.isWrappingRequired(config)) {
            XmlWrapper wrapper = new XmlWrapper();
            wrapper.setName(config.getName());
            wrapper.setLocalName(config.getXmlName());
            wrapper.setNamespace(config.getXmlNamespace());
            wrapper.setNamespaceAware(config.isXmlNamespaceAware());
            wrapper.setPrefix(config.getXmlPrefix());
            wrapper.setNillable(config.isNillable());
            wrapper.setRepeating(config.isRepeating());
            wrapper.setLazy(config.getMinOccurs().equals(0));
            this.pushParser(wrapper);
        }
        super.initializeSegmentMain(config, property);
    }

    @Override
    protected Property finalizeSegmentMain(SegmentConfig config) throws BeanIOConfigurationException {
        Property property = super.finalizeSegmentMain(config);
        if (this.isWrappingRequired(config)) {
            this.popParser();
        }
        return property;
    }

    private boolean isWrappingRequired(SegmentConfig config) {
        return "element".equals(config.getXmlType()) && !config.isConstant();
    }

    @Override
    protected void finalizeSegment(SegmentConfig config, Segment segment) {
        super.finalizeSegment(config, segment);
        if ("element".equals(config.getXmlType())) {
            segment.setOptional(false);
        }
        segment.setExistencePredetermined(true);
    }

    @Override
    public StreamFormat createStreamFormat(StreamConfig config) {
        XmlStreamFormat format = new XmlStreamFormat();
        format.setName(config.getName());
        format.setRecordParserFactory(this.createRecordParserFactory(config));
        return format;
    }

    @Override
    public RecordFormat createRecordFormat(RecordConfig config) {
        return null;
    }

    @Override
    public FieldFormat createFieldFormat(FieldConfig config, Class<?> type) {
        XmlFieldFormat format;
        if ("element".equals(config.getXmlType())) {
            XmlElementField element = new XmlElementField();
            element.setLocalName(config.getXmlName());
            element.setNillable(config.isNillable());
            element.setNamespace(config.getXmlNamespace());
            element.setNamespaceAware(config.isXmlNamespaceAware());
            element.setPrefix(config.getXmlPrefix());
            element.setRepeating(config.isRepeating());
            format = element;
        } else if ("attribute".equals(config.getXmlType())) {
            XmlAttributeField attribute = new XmlAttributeField();
            attribute.setLocalName(config.getXmlName());
            attribute.setNamespace(config.getXmlNamespace());
            attribute.setNamespaceAware(config.isXmlNamespaceAware());
            attribute.setPrefix(config.getXmlPrefix());
            format = attribute;
        } else if ("text".equals(config.getXmlType())) {
            XmlTextField text = new XmlTextField();
            format = text;
        } else {
            throw new IllegalStateException("Invalid xml type: " + config.getXmlType());
        }
        format.setName(config.getName());
        format.setLazy(config.getMinOccurs().equals(0));
        if (config.getLength() != null) {
            FieldPadding padding = new FieldPadding();
            padding.setLength(config.getLength());
            padding.setFiller(config.getPadding().charValue());
            padding.setJustify("right".equals(config.getJustify()) ? (char)'R' : 'L');
            padding.setOptional(!config.isRequired());
            padding.setPropertyType(type);
            padding.init();
            format.setPadding(padding);
        }
        return format;
    }

    @Override
    protected RecordParserFactory getDefaultRecordParserFactory() {
        return new XmlRecordParserFactory();
    }
}

