/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.json;

import java.util.List;
import org.beanio.BeanWriterException;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.json.JsonMarshallingContext;
import org.beanio.internal.parser.format.json.JsonNode;
import org.beanio.internal.parser.format.json.JsonNodeUtil;
import org.beanio.internal.parser.format.json.JsonUnmarshallingContext;
import org.beanio.internal.util.JsonUtil;

public class JsonFieldFormat
implements FieldFormat,
JsonNode {
    private String name;
    private String jsonName;
    private char jsonType;
    private boolean jsonArray;
    private int jsonArrayIndex = -1;
    private boolean lazy;
    private boolean nillable;
    private FieldPadding padding;
    private boolean bypassTypeHandler;

    public String extract(UnmarshallingContext context, boolean reportErrors) {
        JsonUnmarshallingContext ctx = (JsonUnmarshallingContext)context;
        Object value = ctx.getValue(this);
        if (value == null || value == Value.NIL) {
            ctx.setFieldText(this.getName(), null);
            return (String)value;
        }
        if (this.isJsonArray()) {
            int index = -1;
            if (index < 0) {
                index = ctx.getRelativeFieldIndex();
            }
            try {
                List list = (List)value;
                if (index >= list.size()) {
                    return null;
                }
                value = list.get(index);
            }
            catch (ClassCastException ex) {
                if (index > 0 && this.jsonArrayIndex < 0) {
                    return null;
                }
                String fieldText = value.toString();
                ctx.setFieldText(this.getName(), fieldText);
                if (reportErrors) {
                    context.addFieldError(this.getName(), fieldText, "jsontype", JsonNodeUtil.getTypeDescription(this.jsonType, this.jsonArray));
                }
                return Value.INVALID;
            }
        }
        String fieldText = value.toString();
        ctx.setFieldText(this.getName(), fieldText);
        if (this.padding != null) {
            int length = fieldText.length();
            if (length == 0) {
                return "";
            }
            if (length != this.padding.getLength()) {
                if (reportErrors) {
                    context.addFieldError(this.getName(), fieldText, "length", this.padding.getLength());
                }
                fieldText = Value.INVALID;
            } else {
                fieldText = this.padding.unpad(fieldText);
            }
        }
        return fieldText;
    }

    public boolean insertValue(MarshallingContext context, Object value) {
        if (!this.bypassTypeHandler) {
            return false;
        }
        JsonMarshallingContext ctx = (JsonMarshallingContext)context;
        if (value == Value.NIL) {
            ctx.put(this, null);
        } else if (value != null || !this.isLazy()) {
            ctx.put(this, value);
        }
        return true;
    }

    public void insertField(MarshallingContext context, String text) {
        JsonMarshallingContext ctx = (JsonMarshallingContext)context;
        if (text == Value.NIL) {
            ctx.put(this, null);
            return;
        }
        if (text == null && this.isLazy()) {
            return;
        }
        Object value = null;
        switch (this.jsonType) {
            case 'B': {
                try {
                    value = JsonUtil.toBoolean(text);
                    break;
                }
                catch (IllegalArgumentException ex) {
                    throw new BeanWriterException("Cannot parse '" + text + "' into a JSON number", ex);
                }
            }
            case 'N': {
                try {
                    value = JsonUtil.toNumber(text);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new BeanWriterException("Cannot parse '" + text + "' into a JSON number", ex);
                }
            }
            case 'S': {
                value = text;
                break;
            }
            default: {
                throw new BeanWriterException("Invalid jsonType");
            }
        }
        ctx.put(this, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public int getSize() {
        return 1;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setJsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public void setJsonType(char jsonType) {
        this.jsonType = jsonType;
    }

    public char getJsonType() {
        return this.jsonType;
    }

    public void setJsonArray(boolean repeating) {
        this.jsonArray = repeating;
    }

    public boolean isJsonArray() {
        return this.jsonArray;
    }

    public int getJsonArrayIndex() {
        return this.jsonArrayIndex;
    }

    public void setJsonArrayIndex(int jsonArrayIndex) {
        this.jsonArrayIndex = jsonArrayIndex;
    }

    public FieldPadding getPadding() {
        return this.padding;
    }

    public void setPadding(FieldPadding padding) {
        this.padding = padding;
    }

    public boolean isBypassTypeHandler() {
        return this.bypassTypeHandler;
    }

    public void setBypassTypeHandler(boolean bypassTypeHandler) {
        this.bypassTypeHandler = bypassTypeHandler;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", jsonName=" + this.jsonName + ", jsonType=" + this.jsonType + (this.isJsonArray() ? "[]" : "") + ", jsonArrayIndex=" + this.jsonArrayIndex + ", bypass=" + this.bypassTypeHandler + "]";
    }
}

