/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumTypeHandler
implements TypeHandler {
    private Class<Enum> type;

    public EnumTypeHandler(Class<Enum> type) {
        this.type = type;
    }

    @Override
    public Object parse(String text) throws TypeConversionException {
        if (text == null || "".equals(text)) {
            return null;
        }
        try {
            return Enum.valueOf(this.type, text);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeConversionException("Invalid " + this.getType().getSimpleName() + " enum value '" + text + "'", ex);
        }
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).name();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

