/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beanio.internal.util.Replicateable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode<T extends TreeNode>
implements Replicateable,
Iterable<T> {
    private String name;
    private List<T> children = null;

    public TreeNode() {
        this(-1);
    }

    public TreeNode(int size) {
        this.children = size == 0 ? null : (size < 0 || size > 10 ? new ArrayList<T>() : new ArrayList<T>(size));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T find(String name) {
        if (name.equals(this.name)) {
            return (T)this;
        }
        if (this.children != null) {
            for (TreeNode node : this.children) {
                T match = node.find(name);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public boolean isDescendant(T node) {
        if (node == this) {
            return true;
        }
        if (this.children != null) {
            for (TreeNode n : this.children) {
                if (!n.isDescendant(node)) continue;
                return true;
            }
        }
        return false;
    }

    public List<T> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getChildren().iterator();
    }

    public T getFirst() {
        return (T)((TreeNode)this.children.get(0));
    }

    public void add(T child) throws IllegalArgumentException {
        if (this.children == null) {
            this.children = new ArrayList<T>();
        }
        if (!this.isSupportedChild(child)) {
            throw new IllegalArgumentException("Child type not supported: " + child.getClass());
        }
        this.children.add(child);
    }

    public int size() {
        return this.children == null ? 0 : this.children.size();
    }

    protected boolean isSupportedChild(T child) {
        return true;
    }

    public void sort(Comparator<? super T> comparator) {
        if (this.children == null) {
            return;
        }
        for (TreeNode child : this.children) {
            child.sort(comparator);
        }
        Collections.sort(this.children, comparator);
    }

    public T clone() {
        try {
            return (T)((TreeNode)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void updateReferences(Map<Object, Object> map) {
        if (this.children == null) {
            return;
        }
        if (this.children.isEmpty()) {
            this.children = null;
            return;
        }
        ArrayList<T> list = new ArrayList<T>(this.children.size());
        for (TreeNode node : this.children) {
            list.add((TreeNode)map.get(node));
        }
        this.children = list;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        this.print(out, "");
    }

    void print(PrintStream out, String indent) {
        out.println(indent + this);
        indent = indent + "  ";
        for (TreeNode node : this.getChildren()) {
            node.print(out, indent);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName()).append("[");
        s.append("name=").append(this.name);
        this.toParamString(s);
        s.append("]");
        return s.toString();
    }

    protected void toParamString(StringBuilder s) {
    }
}

