/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.delimited;

import java.util.ArrayList;
import java.util.List;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordUnmarshaller;
import org.beanio.stream.delimited.DelimitedParserConfiguration;

public class DelimitedRecordParser
implements RecordUnmarshaller,
RecordMarshaller {
    private char delim;
    private char escape;
    private boolean escapeEnabled;
    private List<String> fieldList = new ArrayList<String>();

    public DelimitedRecordParser() {
        this(new DelimitedParserConfiguration());
    }

    public DelimitedRecordParser(DelimitedParserConfiguration config) {
        this.delim = config.getDelimiter();
        if (config.getEscape() == null) {
            this.escapeEnabled = false;
        } else {
            this.escapeEnabled = true;
            this.escape = config.getEscape().charValue();
            if (this.delim == this.escape) {
                throw new IllegalArgumentException("The field delimiter canot match the escape character");
            }
        }
    }

    public String[] unmarshal(String text) {
        this.fieldList.clear();
        boolean escaped = false;
        StringBuilder field = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (escaped) {
                escaped = false;
                if (c == this.escape || c == this.delim) {
                    field.append(c);
                    continue;
                }
                field.append(this.escape);
            }
            if (c == this.escape && this.escapeEnabled) {
                escaped = true;
                continue;
            }
            if (c == this.delim) {
                this.fieldList.add(field.toString());
                field = new StringBuilder();
                continue;
            }
            field.append(c);
        }
        if (escaped) {
            field.append(this.escape);
        }
        this.fieldList.add(field.toString());
        String[] record = new String[this.fieldList.size()];
        this.fieldList.toArray(record);
        return record;
    }

    public String marshal(Object record) {
        return this.marshal((String[])record);
    }

    public String marshal(String[] record) {
        StringBuilder text = new StringBuilder();
        if (this.escapeEnabled) {
            int pos = 0;
            for (String field : record) {
                if (pos++ > 0) {
                    text.append(this.delim);
                }
                char[] cs = field.toCharArray();
                int j = cs.length;
                for (int i = 0; i < j; ++i) {
                    if (cs[i] == this.delim || cs[i] == this.escape) {
                        text.append(this.escape);
                    }
                    text.append(cs[i]);
                }
            }
        } else {
            int pos = 0;
            for (String field : record) {
                if (pos++ > 0) {
                    text.append(this.delim);
                }
                text.append(field);
            }
        }
        return text.toString();
    }
}

