/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.delimited;

import java.io.Reader;
import java.io.Writer;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.RecordReader;
import org.beanio.stream.RecordUnmarshaller;
import org.beanio.stream.RecordWriter;
import org.beanio.stream.delimited.DelimitedParserConfiguration;
import org.beanio.stream.delimited.DelimitedReader;
import org.beanio.stream.delimited.DelimitedRecordParser;
import org.beanio.stream.delimited.DelimitedWriter;

public class DelimitedRecordParserFactory
extends DelimitedParserConfiguration
implements RecordParserFactory {
    public void init() throws IllegalArgumentException {
        if (this.getEscape() != null && this.getEscape().charValue() == this.getDelimiter()) {
            throw new IllegalArgumentException("The field delimiter canot match the escape character");
        }
        if (this.getLineContinuationCharacter() != null && this.getLineContinuationCharacter().charValue() == this.getDelimiter()) {
            throw new IllegalArgumentException("The field delimiter cannot match the line continuation character");
        }
    }

    public RecordReader createReader(Reader in) throws IllegalArgumentException {
        return new DelimitedReader(in, this);
    }

    public RecordWriter createWriter(Writer out) throws IllegalArgumentException {
        return new DelimitedWriter(out, this);
    }

    public RecordMarshaller createMarshaller() throws IllegalArgumentException {
        return new DelimitedRecordParser(this);
    }

    public RecordUnmarshaller createUnmarshaller() throws IllegalArgumentException {
        return new DelimitedRecordParser(this);
    }
}

