/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.beanio.internal.util.RecordFilterReader;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.beanio.stream.json.JsonReaderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonReader
extends JsonReaderSupport
implements RecordReader {
    private RecordFilterReader filter;
    private String recordText;
    private int recordLineNumber;

    public JsonReader(Reader in) {
        this.filter = new RecordFilterReader(in);
        this.setReader(this.filter);
    }

    @Override
    public Map<String, Object> read() throws IOException, RecordIOException {
        if (this.eof) {
            return null;
        }
        try {
            int n;
            while ((n = this.in.read()) != -1) {
                char c = (char)n;
                if (c == '{') {
                    this.recordLineNumber = this.filter.getLineNumber();
                    this.filter.recordStarted("{");
                    Map<String, Object> value = this.readObject();
                    this.recordText = this.filter.recordCompleted();
                    return value;
                }
                if (this.isWhitespace(c)) continue;
                throw new RecordIOException("Unexpected character");
            }
        }
        catch (RecordIOException ex) {
            throw new RecordIOException(ex.getMessage() + " at line " + this.filter.getLineNumber() + ", near position " + this.filter.getPosition(), ex);
        }
        this.eof = true;
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public int getRecordLineNumber() {
        return this.recordLineNumber;
    }

    @Override
    public String getRecordText() {
        return this.recordText;
    }

    public static void main(String[] args) throws Exception {
        String text = "{ \"firstName\\u004B\" : \"kevin\", \"lastName\" : \"seim\", \"value\":10,\"age\":true, \"object\" : { \"field\" : [ 20, 10, 30 ] } }\r\n\r { \"firstName\": 10 }";
        JsonReader in = new JsonReader(new StringReader(text));
        Object value = null;
        while ((value = in.read()) != null) {
            System.out.println(value);
            System.out.println(in.getRecordLineNumber());
            System.out.println(in.getRecordText());
        }
    }
}

