/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.ExcelUserModelItemReader;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class ExcelEventItemReader
extends ExcelUserModelItemReader
implements ItemReader {
    protected static final int MAX_WORKSHEET_ROWS = 65536;
    @Inject
    @BatchProperty
    protected int queueCapacity;
    private BlockingQueue<Object> queue;
    private DocumentInputStream documentInputStream;
    private FormatTrackingHSSFListener formatListener;

    @Override
    public Object readItem() throws Exception {
        Object result = this.queue.take();
        if (result instanceof Exception) {
            if (result instanceof ReadCompletedException) {
                return null;
            }
            throw (Exception)result;
        }
        return result;
    }

    @Override
    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.currentRowNum);
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.documentInputStream != null) {
            try {
                this.documentInputStream.close();
            }
            catch (Exception e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close DocumentInputStream for %s%n", this.resource);
            }
        }
    }

    @Override
    protected void initWorkbookAndSheet(int startRowNumber) throws Exception {
        this.queue = new ArrayBlockingQueue<Object>(this.queueCapacity == 0 ? 65536 : this.queueCapacity);
        POIFSFileSystem poifs = new POIFSFileSystem(this.inputStream);
        this.documentInputStream = poifs.createDocumentInputStream("Workbook");
        final HSSFRequest req = new HSSFRequest();
        MissingRecordAwareHSSFListener missingRecordAwareHSSFListener = new MissingRecordAwareHSSFListener((HSSFListener)new HSSFListenerImpl(this));
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)missingRecordAwareHSSFListener);
        req.addListenerForAllRecords((HSSFListener)this.formatListener);
        final HSSFEventFactory factory = new HSSFEventFactory();
        if (this.objectMapper == null) {
            this.initJsonFactoryAndObjectMapper();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    factory.processEvents(req, (InputStream)ExcelEventItemReader.this.documentInputStream);
                }
                catch (ReadCompletedException e) {
                    SupportLogger.LOGGER.tracef("Completed reading %s%n", ExcelEventItemReader.this.resource);
                }
            }
        }).start();
    }

    private static final class ReadCompletedException
    extends RuntimeException {
        private static final long serialVersionUID = -8693208957107027254L;

        private ReadCompletedException() {
        }
    }

    private static final class HSSFListenerImpl
    implements HSSFListener {
        private final ExcelEventItemReader itemReader;
        Map<String, String> resultMap = new HashMap<String, String>();
        private SSTRecord sstrec;
        private String currentSheetName;
        private int currentSheetIndex = -1;
        private final ArrayList<BoundSheetRecord> boundSheetRecords = new ArrayList();
        private BoundSheetRecord[] orderedBSRs;
        private final Map<Integer, String> headerIndexToLabelMapping = new HashMap<Integer, String>();
        private boolean readingHeaderRow;
        private boolean readingDataRow;
        private boolean readingTargetSheet;

        private HSSFListenerImpl(ExcelEventItemReader itemReader) {
            this.itemReader = itemReader;
            if (itemReader.header != null) {
                for (int i = 0; i < itemReader.header.length; ++i) {
                    this.headerIndexToLabelMapping.put(i, itemReader.header[i]);
                }
            }
        }

        public void processRecord(Record record) {
            block29: {
                String keyForNextStringRecord = null;
                try {
                    String val;
                    if (this.currentSheetName == null || this.itemReader.sheetName.equals(this.currentSheetName)) {
                        switch (record.getSid()) {
                            case 133: {
                                BoundSheetRecord sheetRec = (BoundSheetRecord)record;
                                this.boundSheetRecords.add(sheetRec);
                                break;
                            }
                            case 2057: {
                                BOFRecord bofRecord = (BOFRecord)record;
                                if (bofRecord.getType() != 5) {
                                    ++this.currentSheetIndex;
                                }
                                if (bofRecord.getType() != 16) break;
                                this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                                this.currentSheetName = this.orderedBSRs[this.currentSheetIndex].getSheetname();
                                if (this.itemReader.sheetName != null) {
                                    this.readingTargetSheet = this.currentSheetName.equals(this.itemReader.sheetName);
                                    break;
                                }
                                if (this.currentSheetIndex == this.itemReader.sheetIndex) {
                                    this.itemReader.sheetName = this.currentSheetName;
                                    this.readingTargetSheet = true;
                                    break;
                                }
                                this.readingTargetSheet = false;
                                break;
                            }
                            case 252: {
                                this.sstrec = (SSTRecord)record;
                                break;
                            }
                            case 513: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (BlankRecord)record;
                                this.readCellValues(rec.getRow(), rec.getColumn(), null);
                                break;
                            }
                            case 517: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (BoolErrRecord)record;
                                String string = rec.isError() ? String.valueOf(rec.getErrorValue()) : String.valueOf(rec.getBooleanValue());
                                this.readCellValues(rec.getRow(), rec.getColumn(), string);
                                break;
                            }
                            case 6: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (FormulaRecord)record;
                                int n = rec.getRow();
                                short column = rec.getColumn();
                                if (Double.isNaN(rec.getValue())) {
                                    keyForNextStringRecord = this.headerIndexToLabelMapping.get(column);
                                    break;
                                }
                                val = this.itemReader.formatListener.formatNumberDateCell((CellValueRecordInterface)rec);
                                this.readCellValues(n, column, val);
                                break;
                            }
                            case 519: {
                                if (!this.readingTargetSheet || keyForNextStringRecord == null) break;
                                Object rec = (StringRecord)record;
                                String string = rec.getString();
                                this.resultMap.put(keyForNextStringRecord, string);
                                keyForNextStringRecord = null;
                                break;
                            }
                            case 516: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (LabelRecord)record;
                                this.readCellValues(rec.getRow(), rec.getColumn(), rec.getValue());
                                break;
                            }
                            case 253: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (LabelSSTRecord)record;
                                String string = this.sstrec.getString(rec.getSSTIndex()).toString();
                                this.readCellValues(rec.getRow(), rec.getColumn(), string);
                                break;
                            }
                            case 515: {
                                if (!this.readingTargetSheet) break;
                                Object rec = (NumberRecord)record;
                                double d = rec.getValue();
                                this.readCellValues(rec.getRow(), rec.getColumn(), String.valueOf(d));
                                break;
                            }
                            case 10: {
                                if (!this.readingTargetSheet || !this.readingDataRow) break;
                                this.queueRowData(null, true);
                                break;
                            }
                        }
                    }
                    if (this.readingTargetSheet && record instanceof LastCellOfRowDummyRecord) {
                        LastCellOfRowDummyRecord lastCellOfRowDummyRecord = (LastCellOfRowDummyRecord)record;
                        int row = lastCellOfRowDummyRecord.getRow();
                        if (this.readingHeaderRow) {
                            this.itemReader.headerMapping = new HashMap();
                            for (Map.Entry entry : this.headerIndexToLabelMapping.entrySet()) {
                                this.itemReader.headerMapping.put(String.valueOf(entry.getKey()), entry.getValue());
                            }
                            if (this.itemReader.header == null) {
                                ArrayList<String> headerList = new ArrayList<String>();
                                int n = this.headerIndexToLabelMapping.size();
                                int i = 0;
                                while (headerList.size() < n) {
                                    val = this.headerIndexToLabelMapping.get(i);
                                    if (val != null) {
                                        headerList.add(val);
                                    }
                                    ++i;
                                }
                                this.itemReader.header = headerList.toArray(new String[n]);
                            }
                            this.readingHeaderRow = false;
                        } else if (this.readingDataRow) {
                            this.queueRowData(null, false);
                        }
                        if (row >= this.itemReader.end) {
                            this.queueRowData(null, true);
                        }
                        this.itemReader.currentRowNum = row;
                    }
                }
                catch (Exception e) {
                    if (!this.readingTargetSheet) break block29;
                    this.queueRowData(e, false);
                }
            }
        }

        private void readCellValues(int row, int column, String val) {
            if (this.itemReader.header == null && row == this.itemReader.headerRow) {
                this.readingHeaderRow = true;
                this.readingDataRow = false;
                this.headerIndexToLabelMapping.put(column, val);
            } else if (row >= this.itemReader.start) {
                this.readingDataRow = true;
                this.readingHeaderRow = false;
                this.resultMap.put(this.headerIndexToLabelMapping.get(column), val);
            }
        }

        private void queueRowData(Exception exception, boolean eof) throws ReadCompletedException {
            try {
                if (eof) {
                    ReadCompletedException readCompletedException = new ReadCompletedException();
                    this.itemReader.queue.put(readCompletedException);
                    throw readCompletedException;
                }
                if (exception != null) {
                    this.itemReader.queue.put(exception);
                    this.resultMap = new HashMap<String, String>();
                } else {
                    Object obj;
                    if (this.itemReader.beanType == List.class) {
                        ArrayList<String> resultList = new ArrayList<String>();
                        for (int i = 0; i < this.itemReader.header.length; ++i) {
                            resultList.add(this.resultMap.get(this.itemReader.header[i]));
                        }
                        obj = resultList;
                    } else if (this.itemReader.beanType == Map.class) {
                        obj = this.resultMap;
                    } else {
                        obj = this.itemReader.objectMapper.convertValue(this.resultMap, this.itemReader.beanType);
                        if (!this.itemReader.skipBeanValidation) {
                            ItemReaderWriterBase.validate(obj);
                        }
                    }
                    this.itemReader.queue.put(obj);
                    this.resultMap = new HashMap<String, String>();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

