/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JmsItemReaderWriterBase;

@Named
@Dependent
public class JmsItemWriter
extends JmsItemReaderWriterBase
implements ItemWriter {
    protected MessageProducer producer;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        this.producer = this.session.createProducer(this.destination);
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            Object msg;
            if (item instanceof Map) {
                Map itemAsMap = (Map)item;
                MapMessage mapMessage = this.session.createMapMessage();
                for (Map.Entry e : itemAsMap.entrySet()) {
                    mapMessage.setObject(e.getKey().toString(), e.getValue());
                }
                msg = mapMessage;
            } else {
                msg = item instanceof String ? this.session.createTextMessage((String)item) : (item instanceof Message ? (Message)item : this.session.createObjectMessage((Serializable)item));
            }
            this.producer.send((Message)msg);
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    @Override
    public void close() {
        super.close();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close JMS consumer %s%n", this.producer);
            }
            this.producer = null;
        }
    }
}

