/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.OutputDecorator;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.JsonItemReaderWriterBase;

@Named
@Dependent
public class JsonItemWriter
extends JsonItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonGeneratorFeatures;
    @Inject
    @BatchProperty
    protected Class prettyPrinter;
    @Inject
    @BatchProperty
    protected Class outputDecorator;
    protected JsonGenerator jsonGenerator;

    public void open(Serializable checkpoint) throws Exception {
        SupportLogger.LOGGER.tracef("Open JsonItemWriter with checkpoint %s, which is ignored for JsonItemWriter.%n", checkpoint);
        this.initJsonFactoryAndObjectMapper();
        if (this.outputDecorator != null) {
            this.jsonFactory.setOutputDecorator((OutputDecorator)this.outputDecorator.newInstance());
        }
        this.jsonGenerator = this.jsonFactory.createGenerator(this.getOutputStream(this.writeMode));
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.jsonGeneratorFeatures != null) {
            for (Map.Entry<String, String> e : this.jsonGeneratorFeatures.entrySet()) {
                JsonGenerator.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = JsonGenerator.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.jsonGenerator.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.jsonGenerator.configure(feature, false);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
            }
        }
        if (this.prettyPrinter == null) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        } else {
            this.jsonGenerator.setPrettyPrinter((PrettyPrinter)this.prettyPrinter.newInstance());
        }
        this.jsonGenerator.writeStartArray();
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            this.jsonGenerator.writeObject(o);
        }
        this.jsonGenerator.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
        if (this.jsonGenerator != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.jsonGenerator.close();
            this.jsonGenerator = null;
        }
    }
}

