/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import org.mongojack.internal.MongoAnnotationIntrospector;
import org.mongojack.internal.MongoJackDeserializers;
import org.mongojack.internal.MongoJackSerializers;
import org.mongojack.internal.stream.ServerErrorProblemHandler;

public class MongoJackModule
extends Module {
    public static final Module INSTANCE = new MongoJackModule();

    public static ObjectMapper configure(ObjectMapper objectMapper) {
        objectMapper.registerModule(INSTANCE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    public String getModuleName() {
        return "Object ID Module";
    }

    public Version version() {
        return new Version(1, 0, 0, null);
    }

    public void setupModule(Module.SetupContext context) {
        MongoAnnotationIntrospector annotationIntrospector = new MongoAnnotationIntrospector(context.getTypeFactory());
        context.insertAnnotationIntrospector((AnnotationIntrospector)annotationIntrospector);
        context.addDeserializationProblemHandler((DeserializationProblemHandler)new ServerErrorProblemHandler());
        context.addSerializers((Serializers)new MongoJackSerializers());
        context.addDeserializers((Deserializers)new MongoJackDeserializers());
    }
}

