/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.bson.types.ObjectId;
import org.mongojack.DBRef;

public class ObjectIdSerializer
extends JsonSerializer {
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value instanceof Iterable) {
            jgen.writeStartArray();
            for (Object item : (Iterable)value) {
                jgen.writeObject(this.serialiseObject(item));
            }
            jgen.writeEndArray();
        } else {
            jgen.writeObject(this.serialiseObject(value));
        }
    }

    private Object serialiseObject(Object value) throws JsonMappingException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new ObjectId((String)value);
        }
        if (value instanceof byte[]) {
            return new ObjectId((byte[])value);
        }
        if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            Object id = this.serialiseObject(dbRef.getId());
            if (id == null) {
                return null;
            }
            return new com.mongodb.DBRef(null, dbRef.getCollectionName(), id);
        }
        if (value instanceof ObjectId) {
            return value;
        }
        throw new JsonMappingException("Cannot deserialise object of type " + value.getClass() + " to ObjectId");
    }
}

