/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBEncoder;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.stream.JacksonDBEncoder;

public class JacksonEncoderFactory
implements DBEncoderFactory {
    private final ObjectMapper objectMapper;
    private final JacksonDBCollection<?, ?> collection;

    public JacksonEncoderFactory(ObjectMapper objectMapper, JacksonDBCollection<?, ?> collection) {
        this.objectMapper = objectMapper;
        this.collection = collection;
    }

    public DBEncoder create() {
        if (this.collection.isEnabled(JacksonDBCollection.Feature.USE_STREAM_SERIALIZATION)) {
            return new JacksonDBEncoder(this.objectMapper, DefaultDBEncoder.FACTORY.create());
        }
        return DefaultDBEncoder.FACTORY.create();
    }
}

