/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.mongodb.DBRef;
import de.undercouch.bson4jackson.BsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.bson.types.ObjectId;
import org.mongojack.internal.stream.ObjectIdConvertor;

public class DBEncoderBsonGenerator
extends BsonGenerator {
    public DBEncoderBsonGenerator(int jsonFeatures, OutputStream out) {
        super(jsonFeatures, 0, out);
    }

    protected void _writeSimpleObject(Object value) throws IOException, JsonGenerationException {
        if (value instanceof Date) {
            this.writeDateTime((Date)value);
        } else if (value instanceof Calendar) {
            this.writeDateTime(((Calendar)value).getTime());
        } else if (value instanceof ObjectId) {
            this.writeObjectId(ObjectIdConvertor.convert((ObjectId)value));
        } else if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            this.writeStartObject();
            this.writeFieldName("$ref");
            this.writeString(dbRef.getRef());
            this.writeFieldName("$id");
            this.writeObject(dbRef.getId());
            if (dbRef.getDB() != null) {
                this.writeFieldName("$db");
                this.writeString(dbRef.getDB().getName());
            }
            this.writeEndObject();
        } else {
            super._writeSimpleObject(value);
        }
    }
}

