/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoException;
import java.io.IOException;
import org.mongojack.internal.object.BsonObjectGenerator;
import org.mongojack.internal.object.BsonObjectTraversingParser;

public interface IdHandler<K, D> {
    public K fromDbId(D var1);

    public D toDbId(K var1);

    public static class JacksonIdHandler<K, D>
    implements IdHandler<K, D> {
        private final JsonSerializer<K> jsonSerializer;
        private final JsonDeserializer<K> jsonDeserializer;
        private final ObjectMapper objectMapper;

        public JacksonIdHandler(JsonSerializer<K> jsonSerializer, JsonDeserializer<K> jsonDeserializer, ObjectMapper objectMapper) {
            this.jsonSerializer = jsonSerializer;
            this.jsonDeserializer = jsonDeserializer;
            this.objectMapper = objectMapper;
        }

        @Override
        public K fromDbId(D dbId) {
            try {
                return (K)this.jsonDeserializer.deserialize((JsonParser)new BsonObjectTraversingParser(null, dbId, (ObjectCodec)this.objectMapper), null);
            }
            catch (IOException e) {
                throw new MongoException("Error deserializing ID", (Throwable)e);
            }
        }

        @Override
        public D toDbId(K id) {
            BsonObjectGenerator generator = new BsonObjectGenerator();
            try {
                this.jsonSerializer.serialize(id, (JsonGenerator)generator, null);
            }
            catch (IOException e) {
                throw new MongoException("Error serializing ID", (Throwable)e);
            }
            return (D)generator.getValue();
        }
    }

    public static class NoopIdHandler<K>
    implements IdHandler<K, K> {
        @Override
        public K fromDbId(K dbId) {
            return dbId;
        }

        @Override
        public K toDbId(K id) {
            return id;
        }
    }
}

