/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ContextLogger
extends WeldLogger {
    public static final ContextLogger LOG = (ContextLogger)Logger.getMessageLogger(ContextLogger.class, (String)Category.CONTEXT.getName());

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=200, value="Looked for {0} and got {1} in {2}", format=Message.Format.MESSAGE_FORMAT)
    public void contextualInstanceFound(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=201, value="Context {0} cleared", format=Message.Format.MESSAGE_FORMAT)
    public void contextCleared(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=202, value="Added {0} with key {1} to {2}", format=Message.Format.MESSAGE_FORMAT)
    public void contextualInstanceAdded(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=203, value="Removed {0} from {1}", format=Message.Format.MESSAGE_FORMAT)
    public void contextualInstanceRemoved(Object var1, Object var2);

    @Deprecated
    @Message(id=204, value="Restoring session {0}", format=Message.Format.MESSAGE_FORMAT)
    public String sessionRestored(Object var1);

    @Deprecated
    @Message(id=205, value="Ending session {0}", format=Message.Format.MESSAGE_FORMAT)
    public String sessionEnded(Object var1);

    @Deprecated
    @Message(id=206, value="Starting request {0}", format=Message.Format.MESSAGE_FORMAT)
    public String requestStarted(Object var1);

    @Deprecated
    @Message(id=207, value="Ending request {0}", format=Message.Format.MESSAGE_FORMAT)
    public String requestEnded(Object var1);

    @Deprecated
    @Message(id=208, value="Starting application {0}", format=Message.Format.MESSAGE_FORMAT)
    public String applicationStarted(Object var1);

    @Deprecated
    @Message(id=209, value="Ending application {0}", format=Message.Format.MESSAGE_FORMAT)
    public String applicationEnded(Object var1);

    @Deprecated
    @Message(id=210, value="Attached dependent instance {0} to {1}", format=Message.Format.MESSAGE_FORMAT)
    public String dependentInstanceAttached(Object var1, Object var2);

    @Message(id=211, value="The delimiter \"{0}\" should not be in the prefix \"{1}\"", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException delimiterInPrefix(Object var1, Object var2);

    @Message(id=212, value="No contextual specified to retrieve (null)")
    public IllegalArgumentException contextualIsNull();

    @Message(id=213, value="No bean store available for {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException noBeanStoreAvailable(Object var1);

    @Deprecated
    @Message(id=214, value="Restoring conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public String conversationRestored(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=215, value="Bean store {0} is detached", format=Message.Format.MESSAGE_FORMAT)
    public void beanStoreDetached(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=216, value="Updating underlying store with contextual {0} under ID {1}", format=Message.Format.MESSAGE_FORMAT)
    public void updatingStoreWithContextualUnderId(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=217, value="Adding detached contextual {0} under ID {1}", format=Message.Format.MESSAGE_FORMAT)
    public void addingDetachedContextualUnderId(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=218, value="Removed {0} from session {1}", format=Message.Format.MESSAGE_FORMAT)
    public void removedKeyFromSession(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=219, value="Unable to remove {0} from non-existent session", format=Message.Format.MESSAGE_FORMAT)
    public void unableToRemoveKeyFromSession(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=220, value="Added {0} to session {1}", format=Message.Format.MESSAGE_FORMAT)
    public void addedKeyToSession(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=221, value="Unable to add {0} to session as no session could be obtained", format=Message.Format.MESSAGE_FORMAT)
    public void unableToAddKeyToSession(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=222, value="Loading bean store {0} map from session {1}", format=Message.Format.MESSAGE_FORMAT)
    public void loadingBeanStoreMapFromSession(Object var1, Object var2);

    @Message(id=223, value="Context.getScope() returned null for {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException contextHasNullScope(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=224, value="Unable to clear bean store {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void unableToClearBeanStore(Object var1);
}

