/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.json;

import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.ParserFactorySupport;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.compiler.json.JsonPreprocessor;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.Stream;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.format.json.JsonFieldFormat;
import org.beanio.internal.parser.format.json.JsonStreamFormat;
import org.beanio.internal.parser.format.json.JsonWrapper;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.json.JsonRecordParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParserFactory
extends ParserFactorySupport {
    private int maxDepth = 1;

    @Override
    protected Preprocessor createPreprocessor(StreamConfig config) {
        return new JsonPreprocessor(config);
    }

    @Override
    public Stream createStream(StreamConfig config) throws BeanIOConfigurationException {
        Stream stream = super.createStream(config);
        ((JsonStreamFormat)stream.getFormat()).setMaxDepth(this.maxDepth);
        return stream;
    }

    @Override
    protected void initializeSegmentIteration(SegmentConfig config, Property property) {
        JsonWrapper wrapper = new JsonWrapper();
        wrapper.setName(config.getName());
        wrapper.setJsonName(config.getJsonName());
        wrapper.setJsonType('A');
        wrapper.setJsonArrayIndex(config.getJsonArrayIndex());
        wrapper.setNillable(true);
        wrapper.setOptional(config.getMinOccurs().equals(0));
        this.pushParser(wrapper);
        ++this.maxDepth;
        super.initializeSegmentIteration(config, property);
    }

    @Override
    protected void finalizeSegmentIteration(SegmentConfig config, Property property) {
        super.finalizeSegmentIteration(config, property);
        this.popParser();
    }

    @Override
    protected void initializeSegmentMain(SegmentConfig config, Property property) {
        if (this.isWrappingRequired(config)) {
            JsonWrapper wrapper = new JsonWrapper();
            wrapper.setName(config.getName());
            wrapper.setJsonName(config.getJsonName());
            wrapper.setJsonType(this.convertJsonType(config.getJsonType()));
            wrapper.setJsonArrayIndex(config.getJsonArrayIndex());
            wrapper.setNillable(true);
            wrapper.setOptional(config.getMinOccurs().equals(0));
            this.pushParser(wrapper);
            ++this.maxDepth;
        }
        super.initializeSegmentMain(config, property);
    }

    @Override
    protected Property finalizeSegmentMain(SegmentConfig config) throws BeanIOConfigurationException {
        Property property = super.finalizeSegmentMain(config);
        if (this.isWrappingRequired(config)) {
            this.popParser();
        }
        return property;
    }

    private boolean isWrappingRequired(SegmentConfig config) {
        return !"none".equals(config.getJsonType());
    }

    @Override
    protected boolean isSegmentRequired(SegmentConfig config) {
        if (config.isConstant()) {
            return false;
        }
        if (config.getType() != null) {
            return true;
        }
        return config.getChildren().size() > 1;
    }

    private char convertJsonType(String type) {
        if ("array".equals(type)) {
            return 'A';
        }
        if ("object".equals(type)) {
            return 'O';
        }
        throw new BeanIOConfigurationException("Invalid jsonType '" + type + "'");
    }

    @Override
    protected StreamFormat createStreamFormat(StreamConfig config) {
        JsonStreamFormat format = new JsonStreamFormat();
        format.setName(config.getName());
        format.setRecordParserFactory(this.createRecordParserFactory(config));
        return format;
    }

    @Override
    protected RecordFormat createRecordFormat(RecordConfig config) {
        return null;
    }

    @Override
    protected FieldFormat createFieldFormat(FieldConfig config, Class<?> type) {
        JsonFieldFormat format = new JsonFieldFormat();
        format.setName(config.getName());
        format.setJsonName(config.getJsonName());
        format.setJsonArray(config.isJsonArray());
        format.setJsonArrayIndex(config.getJsonArrayIndex());
        format.setLazy(config.getMinOccurs() != null && new Integer(0).equals(config.getMinOccurs()));
        format.setNillable(true);
        if (config.getJsonType() == null) {
            if (Number.class.isAssignableFrom(type)) {
                format.setBypassTypeHandler(true);
                format.setJsonType('N');
            } else if (Boolean.class.isAssignableFrom(type)) {
                format.setBypassTypeHandler(true);
                format.setJsonType('B');
            } else {
                format.setBypassTypeHandler(false);
                format.setJsonType('S');
            }
        } else {
            String jsonType = config.getJsonType();
            if ("boolean".equals(jsonType)) {
                format.setJsonType('B');
                format.setBypassTypeHandler(Boolean.class.isAssignableFrom(type));
            } else if ("number".equals(jsonType)) {
                format.setJsonType('N');
                format.setBypassTypeHandler(Number.class.isAssignableFrom(type));
            } else {
                format.setJsonType('S');
                format.setBypassTypeHandler(false);
            }
        }
        return format;
    }

    @Override
    protected RecordParserFactory getDefaultRecordParserFactory() {
        return new JsonRecordParserFactory();
    }
}

