/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.Segment;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.util.DebugUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record
extends Segment
implements Selector {
    private int minOccurs = 0;
    private int maxOccurs = Integer.MAX_VALUE;
    private int order = 1;
    private RecordFormat format;
    private ParserLocal<Integer> count = new ParserLocal<Integer>(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        try {
            boolean marshalled = super.marshal(context);
            if (marshalled) {
                context.writeRecord();
            }
            boolean bl = marshalled;
            return bl;
        }
        finally {
            context.clear();
        }
    }

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        try {
            context.recordStarted(this.getName());
            if (this.format != null) {
                this.format.validate(context);
                if (context.hasRecordErrors()) {
                    boolean bl = true;
                    return bl;
                }
            }
            super.unmarshal(context);
            boolean bl = true;
            return bl;
        }
        finally {
            context.recordCompleted();
        }
    }

    @Override
    public void skip(UnmarshallingContext context) {
        context.recordSkipped();
    }

    @Override
    public Selector matchNext(MarshallingContext context) {
        String componentName;
        Property property = this.getProperty();
        if (property != null) {
            String componentName2 = context.getComponentName();
            if (componentName2 != null && !this.getName().equals(componentName2)) {
                return null;
            }
            Object value = context.getBean();
            if (property.defines(value)) {
                this.setCount(context, this.getCount(context) + 1);
                property.setValue(context, value);
                return this;
            }
        } else if (context.getBean() == null && (componentName = context.getComponentName()) != null && this.getName().equals(componentName)) {
            this.setCount(context, this.getCount(context) + 1);
            return this;
        }
        return null;
    }

    @Override
    public Selector matchNext(UnmarshallingContext context) {
        if (this.matches(context)) {
            this.setCount(context, this.getCount(context) + 1);
            return this;
        }
        return null;
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        if (this.format != null && !this.format.matches(context)) {
            return false;
        }
        return super.matches(context);
    }

    @Override
    public Selector matchAny(UnmarshallingContext context) {
        return this.matches(context) ? this : null;
    }

    @Override
    public Selector close(ParsingContext context) {
        return this.getCount(context) < this.getMinOccurs() ? this : null;
    }

    @Override
    public void reset(ParsingContext context) {
    }

    @Override
    public void updateState(ParsingContext context, String namespace, Map<String, Object> state) {
        state.put(this.getKey(namespace, "count"), this.count.get(context));
    }

    @Override
    public void restoreState(ParsingContext context, String namespace, Map<String, Object> state) {
        String key = this.getKey(namespace, "count");
        Integer n = (Integer)state.get(key);
        if (n == null) {
            throw new IllegalStateException("Missing state information for key '" + key + "'");
        }
        this.count.set(context, n);
    }

    protected String getKey(String namespace, String name) {
        return namespace + "." + this.getName() + "." + name;
    }

    @Override
    public boolean isRecordGroup() {
        return false;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getCount(ParsingContext context) {
        return this.count.get(context);
    }

    @Override
    public void setCount(ParsingContext context, int count) {
        this.count.set(context, count);
    }

    public RecordFormat getFormat() {
        return this.format;
    }

    public void setFormat(RecordFormat format) {
        this.format = format;
    }

    @Override
    public void registerLocals(Set<ParserLocal<?>> locals) {
        if (locals.add(this.count)) {
            super.registerLocals(locals);
        }
    }

    @Override
    public boolean isMaxOccursReached(ParsingContext context) {
        return this.getCount(context) >= this.getMaxOccurs();
    }

    @Override
    protected void toParamString(StringBuilder s) {
        s.append(", order=").append(this.order);
        s.append(", occurs=").append(DebugUtil.formatRange(this.minOccurs, this.maxOccurs));
        super.toParamString(s);
        s.append(", format=").append(this.format);
    }
}

