/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import java.util.LinkedList;
import org.beanio.internal.parser.Iteration;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNode;
import org.beanio.internal.parser.format.xml.XmlNodeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUnmarshallingContext
extends UnmarshallingContext {
    private Document document;
    private Element position;
    private LinkedList<Element> elementStack = new LinkedList();
    private XmlNode[] groupStack;

    public XmlUnmarshallingContext(int groupDepth) {
        this.groupStack = new XmlNode[groupDepth];
    }

    public void setRecordValue(Object value) {
        Node node = (Node)value;
        if (node.getNodeType() == 9) {
            this.document = (Document)value;
            this.position = null;
        } else if (node.getNodeType() == 1) {
            this.document = node.getOwnerDocument();
            this.position = (Element)node;
        } else {
            this.document = node.getOwnerDocument();
            this.position = null;
        }
    }

    public void pushIteration(Iteration b) {
        super.pushIteration(b);
        this.elementStack.addFirst(null);
    }

    public Iteration popIteration() {
        this.elementStack.removeFirst();
        return super.popIteration();
    }

    public Element getPreviousElement() {
        return this.elementStack.getFirst();
    }

    public void setPreviousElement(Element e) {
        this.elementStack.set(0, e);
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getPosition() {
        return this.position;
    }

    public Element pushPosition(XmlNode node, int depth, boolean isGroup) {
        if (isGroup) {
            this.groupStack[depth] = node;
        }
        if (this.position == null && depth > 0) {
            for (int i = 0; i < depth; ++i) {
                this.position = this.findElement(this.groupStack[i]);
                if (this.position != null) continue;
                return null;
            }
            Element element = this.pushPosition(node);
            if (element == null) {
                this.position = null;
            }
            return element;
        }
        return this.pushPosition(node);
    }

    public Element pushPosition(XmlNode node) {
        Element element = this.findElement(node);
        if (element == null) {
            return null;
        }
        this.position = element;
        return this.position;
    }

    public void popPosition() {
        if (this.position != null) {
            Node n = this.position.getParentNode();
            this.position = n == null || n.getNodeType() == 9 ? null : (Element)n;
        }
    }

    public Element findElement(XmlNode node) {
        Element element;
        Element parent = this.position;
        if (node.isRepeating()) {
            int index = this.getRelativeFieldIndex();
            element = index > 0 ? XmlNodeUtil.findSibling(this.getPreviousElement(), node) : XmlNodeUtil.findChild(parent, node, index);
            if (element != null) {
                this.setPreviousElement(element);
            }
        } else {
            element = parent == null ? XmlNodeUtil.findChild(this.document, node, 0) : XmlNodeUtil.findChild(parent, node, 0);
        }
        return element;
    }

    public Object toRecordValue(Node node) {
        return node;
    }
}

