/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.beanio.BeanIOException;
import org.beanio.internal.util.IOUtil;

public class Settings {
    public static final String STREAM_FACTORY_CLASS = "org.beanio.streamFactory";
    public static final String DEFAULT_LOCALE = "org.beanio.defaultTypeHandlerLocale";
    public static final String DEFAULT_DATE_FORMAT = "org.beanio.defaultDateFormat";
    public static final String DEFAULT_DATETIME_FORMAT = "org.beanio.defaultDateTimeFormat";
    public static final String DEFAULT_TIME_FORMAT = "org.beanio.defaultTimeFormat";
    public static final String PROPERTY_ESCAPING_ENABLED = "org.beanio.propertyEscapingEnabled";
    public static final String NULL_ESCAPING_ENABLED = "org.beanio.propertyEscapingEnabled";
    public static final String PROPERTY_SUBSTITUTION_ENABLED = "org.beanio.propertySubstitutionEnabled";
    public static final String DEFAULT_XML_TYPE = "org.beanio.xml.defaultXmlType";
    public static final String DEFAULT_XSI_NAMESPACE_PREFIX = "org.beanio.xml.xsiNamespacePrefix";
    public static final String XML_WRITER_UPDATE_STATE_USING_DELTA = "org.beanio.stream.xml.XmlWriter.deltaEnabled";
    public static final String DEFAULT_MARSHALLING_ENABLED = "org.beanio.marshalDefaultEnabled";
    public static final String DEFAULT_GROUP_MIN_OCCURS = "org.beanio.group.minOccurs";
    public static final String DEFAULT_RECORD_MIN_OCCURS = "org.beanio.record.minOccurs";
    public static final String DEFAULT_FIELD_MIN_OCCURS = "org.beanio.field.minOccurs";
    public static final String PROPERTY_ACCESSOR_METHOD = "org.beanio.propertyAccessorFactory";
    public static final String CREATE_MISSING_BEANS = "org.beanio.createMissingBeans";
    public static final String LAZY_IF_EMPTY = "org.beanio.lazyIfEmpty";
    public static final String ERROR_IF_NULL_PRIMITIVE = "org.beanio.errorIfNullPrimitive";
    public static final String USE_DEFAULT_IF_MISSING = "org.beanio.useDefaultIfMissing";
    public static final String SORT_XML_COMPONENTS_BY_POSITION = "org.beanio.xml.sorted";
    public static final String ALLOW_PROTECTED_PROPERTY_ACCESS = "org.beanio.allowProtectedAccess";
    private static final String DEFAULT_CONFIGURATION_PATH = "org/beanio/internal/config/beanio.properties";
    private static final String DEFAULT_CONFIGURATION_FILENAME = "beanio.properties";
    private static final String CONFIGURATION_PROPERTY = "org.beanio.configuration";
    private Properties properties;
    private static Settings settings;

    private Settings(Properties props) {
        this.properties = props;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBoolean(String key) {
        return "true".equalsIgnoreCase(this.getProperty(key));
    }

    public int getInt(String key, int defaultValue) {
        try {
            String value = this.properties.getProperty(key);
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static synchronized Settings getInstance() {
        return Settings.getInstance(null);
    }

    public static synchronized Settings getInstance(ClassLoader classLoader) {
        if (settings != null) {
            return settings;
        }
        if (classLoader == null) {
            classLoader = Settings.class.getClassLoader();
        }
        Properties props = new Properties();
        Settings.loadProperties(Settings.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_PATH), props);
        boolean required = false;
        String location = System.getProperty(CONFIGURATION_PROPERTY);
        URL configurationUrl = null;
        if (location != null) {
            configurationUrl = Settings.getFileURL(location);
            if (configurationUrl == null) {
                if (location.startsWith("/")) {
                    location = location.substring(1);
                }
                configurationUrl = classLoader.getResource(location);
            }
            required = true;
        } else {
            configurationUrl = Settings.getFileURL(DEFAULT_CONFIGURATION_FILENAME);
            if (configurationUrl == null) {
                configurationUrl = classLoader.getResource(DEFAULT_CONFIGURATION_FILENAME);
            }
        }
        if (configurationUrl != null) {
            Settings.loadProperties(configurationUrl, props);
        } else if (required) {
            throw new BeanIOException("BeanIO configuration settings not found at '" + location + "'");
        }
        for (Object key : props.keySet()) {
            String value = System.getProperty((String)key);
            if (value == null) continue;
            props.put(key, value);
        }
        settings = new Settings(props);
        return settings;
    }

    private static URL getFileURL(String location) {
        File file = new File(location);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new BeanIOException("Invalid configuration location: " + location, ex);
            }
        }
        return null;
    }

    private static void loadProperties(URL url, Properties props) {
        InputStream in = null;
        try {
            in = url.openStream();
            props.load(in);
        }
        catch (IOException ex) {
            throw new BeanIOException("IOException caught reading configuration file: " + url, ex);
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }
}

