/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.spring;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.BeanReaderException;
import org.beanio.BeanReaderIOException;
import org.beanio.RecordContext;
import org.beanio.StreamFactory;
import org.beanio.internal.util.IOUtil;
import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIOFlatFileItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private StreamFactory streamFactory;
    private Resource streamMapping;
    private String streamName;
    private Locale locale;
    private boolean strict = true;
    private boolean useSpringExceptions = false;
    private Resource resource;
    private String encoding = DEFAULT_CHARSET;
    private BeanReader reader;
    private BeanReaderErrorHandler errorHandler;

    public BeanIOFlatFileItemReader() {
        this.setName(ClassUtils.getShortName(BeanIOFlatFileItemReader.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.streamName, (String)"Stream name must be set");
        this.initializeStreamFactory();
    }

    protected T doRead() throws Exception {
        if (this.reader == null) {
            return null;
        }
        try {
            return (T)this.reader.read();
        }
        catch (BeanReaderIOException ex) {
            throw ex.getCause();
        }
        catch (BeanReaderException ex) {
            if (this.useSpringExceptions) {
                RecordContext ctx = ex.getRecordContext();
                if (ctx != null) {
                    throw new FlatFileParseException(ex.getMessage(), (Throwable)ex, ctx.getRecordText(), ctx.getLineNumber());
                }
                throw new FlatFileParseException(ex.getMessage(), (Throwable)ex, null, 0);
            }
            throw ex;
        }
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist: " + this.resource);
            }
            return;
        }
        InputStream bin = this.resource.getInputStream();
        InputStreamReader in = this.encoding == null ? new InputStreamReader(bin) : new InputStreamReader(bin, this.encoding);
        this.reader = this.streamFactory.createReader(this.streamName, in, this.locale);
        if (this.errorHandler != null) {
            this.reader.setErrorHandler(this.errorHandler);
        }
    }

    protected void doClose() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected void jumpToItem(int itemIndex) throws Exception {
        if (itemIndex <= 0) {
            return;
        }
        int skipped = 0;
        if (this.reader != null) {
            skipped = this.reader.skip(itemIndex);
        }
        if (skipped < itemIndex) {
            throw new IllegalStateException("Failed to skip " + itemIndex + " items, end of stream reached after " + skipped + " items");
        }
    }

    protected void initializeStreamFactory() throws Exception {
        if (this.streamFactory == null) {
            this.streamFactory = StreamFactory.newInstance();
        }
        if (!this.streamFactory.isMapped(this.streamName) && this.streamMapping != null) {
            InputStream in = this.streamMapping.getInputStream();
            try {
                this.streamFactory.load(in);
            }
            finally {
                IOUtil.closeQuietly(in);
            }
        }
        if (!this.streamFactory.isMapped(this.streamName)) {
            throw new IllegalStateException("No mapping configuration for stream '" + this.streamName + "'");
        }
    }

    public String getRecordName() {
        return this.reader != null ? this.reader.getRecordName() : null;
    }

    public int getLineNumber() {
        return this.reader != null ? this.reader.getLineNumber() : -1;
    }

    public int getRecordCount() {
        return this.reader != null ? this.reader.getRecordCount() : -1;
    }

    public RecordContext getRecordContext(int index) throws IndexOutOfBoundsException {
        return this.reader != null ? this.reader.getRecordContext(index) : null;
    }

    protected BeanReader getBeanReader() {
        return this.reader;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public void setStreamMapping(Resource streamMapping) {
        this.streamMapping = streamMapping;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setUseSpringExceptions(boolean useSpringExceptions) {
        this.useSpringExceptions = useSpringExceptions;
    }

    public void setErrorHandler(BeanReaderErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setLocale(String locale) {
        if (locale == null) {
            this.locale = null;
            return;
        }
        String[] s = locale.split("_");
        this.locale = s.length >= 3 ? new Locale(s[0], s[1], s[2]) : (s.length == 2 ? new Locale(s[0], s[1]) : new Locale(locale));
    }
}

