/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.beanio.BeanIOConfigurationException;
import org.beanio.StreamFactory;
import org.beanio.internal.util.IOUtil;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIOStreamFactory
implements FactoryBean {
    private StreamFactory streamFactory;
    private List<Resource> streamMappings;

    public StreamFactory getObject() throws Exception {
        if (this.streamFactory == null) {
            this.streamFactory = this.createStreamFactory();
        }
        return this.streamFactory;
    }

    protected StreamFactory createStreamFactory() throws IOException, BeanIOConfigurationException {
        StreamFactory factory = StreamFactory.newInstance();
        if (this.streamMappings != null) {
            for (Resource res : this.streamMappings) {
                if (!res.exists()) {
                    throw new BeanIOConfigurationException("Mapping file not found: " + res);
                }
                InputStream in = res.getInputStream();
                try {
                    factory.load(in);
                }
                catch (BeanIOConfigurationException ex) {
                    throw new BeanIOConfigurationException("Error in mapping file '" + res + "': " + ex.getMessage(), ex);
                }
                finally {
                    IOUtil.closeQuietly(in);
                }
            }
        }
        return factory;
    }

    public Class<?> getObjectType() {
        return StreamFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setStreamMappings(List<Resource> streamMappings) {
        this.streamMappings = streamMappings;
    }
}

