/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.csv;

import java.io.Reader;
import java.io.Writer;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.RecordReader;
import org.beanio.stream.RecordUnmarshaller;
import org.beanio.stream.RecordWriter;
import org.beanio.stream.csv.CsvParserConfiguration;
import org.beanio.stream.csv.CsvReader;
import org.beanio.stream.csv.CsvRecordParser;
import org.beanio.stream.csv.CsvWriter;

public class CsvRecordParserFactory
extends CsvParserConfiguration
implements RecordParserFactory {
    public void init() throws IllegalArgumentException {
        if (this.getQuote() == this.getDelimiter()) {
            throw new IllegalArgumentException("The CSV field delimiter cannot match the character used for the quotation mark.");
        }
        if (this.getEscape() != null && this.getEscape().charValue() == this.getDelimiter()) {
            throw new IllegalArgumentException("The CSV field delimiter cannot match the escape character.");
        }
    }

    public RecordReader createReader(Reader in) throws IllegalArgumentException {
        return new CsvReader(in, this);
    }

    public RecordWriter createWriter(Writer out) throws IllegalArgumentException {
        return new CsvWriter(out, this);
    }

    public RecordMarshaller createMarshaller() throws IllegalArgumentException {
        return new CsvRecordParser(this);
    }

    public RecordUnmarshaller createUnmarshaller() throws IllegalArgumentException {
        return new CsvRecordParser(this);
    }
}

