/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParserConfiguration
implements Cloneable {
    private int indentation = -1;
    private String lineSeparator = null;
    private boolean suppressHeader = false;
    private String version = "1.0";
    private String encoding = "utf-8";
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public boolean isIndentationEnabled() {
        return this.indentation >= 0;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isSuppressHeader() {
        return this.suppressHeader;
    }

    public void setSuppressHeader(boolean suppressHeader) {
        this.suppressHeader = suppressHeader;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("null version");
        }
        this.version = version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException("null prefix");
        }
        if (uri == null) {
            throw new IllegalArgumentException("null uri");
        }
        this.namespaceMap.put(uri, prefix);
    }

    public void setNamespaces(String list) {
        this.namespaceMap.clear();
        if (list == null) {
            return;
        }
        String[] s = list.trim().split("\\s+");
        if (s.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid namespaces setting.  Must follow 'prefix uri prefix uri' pattern.");
        }
        for (int i = 0; i < s.length; i += 2) {
            this.addNamespace(s[i + 1], s[i]);
        }
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    protected XmlParserConfiguration clone() {
        try {
            return (XmlParserConfiguration)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }
}

