/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

public final class BijectiveNsMap {
    static final int DEFAULT_ARRAY_SIZE = 32;
    final int _scopeStart;
    String[] _nsStrings;
    int _scopeEnd;

    private BijectiveNsMap(int n, String[] stringArray) {
        this._scopeStart = this._scopeEnd = n;
        this._nsStrings = stringArray;
    }

    public static BijectiveNsMap createEmpty() {
        String[] stringArray = new String[32];
        stringArray[0] = "xml";
        stringArray[1] = "http://www.w3.org/XML/1998/namespace";
        stringArray[2] = "xmlns";
        stringArray[3] = "http://www.w3.org/2000/xmlns/";
        return new BijectiveNsMap(4, stringArray);
    }

    public BijectiveNsMap createChild() {
        return new BijectiveNsMap(this._scopeEnd, this._nsStrings);
    }

    public String findUriByPrefix(String string) {
        String[] stringArray = this._nsStrings;
        int n = string.hashCode();
        for (int i = this._scopeEnd - 2; i >= 0; i -= 2) {
            String string2 = stringArray[i];
            if (string2 != string && (string2.hashCode() != n || !string2.equals(string))) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public String findPrefixByUri(String string) {
        String[] stringArray = this._nsStrings;
        int n = string.hashCode();
        block0: for (int i = this._scopeEnd - 1; i > 0; i -= 2) {
            String string2 = stringArray[i];
            if (string2 != string && (string2.hashCode() != n || !string2.equals(string))) continue;
            String string3 = stringArray[i - 1];
            if (i < this._scopeStart) {
                int n2 = string3.hashCode();
                int n3 = this._scopeEnd;
                for (int j = i - 1; j < n3; j += 2) {
                    String string4 = stringArray[i];
                    if (string4 == string3 || string4.hashCode() == n2 && string4.equals(string3)) continue block0;
                }
            }
            return string3;
        }
        return null;
    }

    public List<String> getPrefixesBoundToUri(String string, List<String> list) {
        String[] stringArray = this._nsStrings;
        int n = string.hashCode();
        block0: for (int i = this._scopeEnd - 1; i > 0; i -= 2) {
            String string2 = stringArray[i];
            if (string2 != string && (string2.hashCode() != n || !string2.equals(string))) continue;
            String string3 = stringArray[i - 1];
            if (i < this._scopeStart) {
                int n2 = string3.hashCode();
                int n3 = this._scopeEnd;
                for (int j = i - 1; j < n3; j += 2) {
                    String string4 = stringArray[i];
                    if (string4 == string3 || string4.hashCode() == n2 && string4.equals(string3)) continue block0;
                }
            }
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string3);
        }
        return list;
    }

    public int size() {
        return this._scopeEnd >> 1;
    }

    public int localSize() {
        return this._scopeEnd - this._scopeStart >> 1;
    }

    public String addMapping(String string, String string2) {
        String[] stringArray = this._nsStrings;
        int n = string.hashCode();
        int n2 = this._scopeEnd;
        for (int i = this._scopeStart; i < n2; i += 2) {
            String string3 = stringArray[i];
            if (string3 != string && (string3.hashCode() != n || !string3.equals(string))) continue;
            String string4 = stringArray[i + 1];
            stringArray[i + 1] = string2;
            return string4;
        }
        if (this._scopeEnd >= stringArray.length) {
            this._nsStrings = stringArray = Arrays.copyOf(stringArray, stringArray.length << 1);
        }
        stringArray[this._scopeEnd++] = string;
        stringArray[this._scopeEnd++] = string2;
        return null;
    }

    public String addGeneratedMapping(String string, NamespaceContext namespaceContext, String string2, int[] nArray) {
        String string3;
        String[] stringArray = this._nsStrings;
        int n = nArray[0];
        block0: while (true) {
            string3 = (string + n).intern();
            ++n;
            int n2 = string3.hashCode();
            for (int i = this._scopeEnd - 2; i >= 0; i -= 2) {
                String string4 = stringArray[i];
                if (string4 == string3 || string4.hashCode() == n2 && string4.equals(string3)) continue block0;
            }
            if (namespaceContext == null || namespaceContext.getNamespaceURI(string3) == null) break;
        }
        nArray[0] = n;
        if (this._scopeEnd >= stringArray.length) {
            this._nsStrings = stringArray = Arrays.copyOf(stringArray, stringArray.length << 1);
        }
        stringArray[this._scopeEnd++] = string3;
        stringArray[this._scopeEnd++] = string2;
        return string3;
    }
}

