/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.StreamScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public final class Utf8Scanner
extends StreamScanner {
    public Utf8Scanner(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n, int n2) {
        super(readerConfig, inputStream, byArray, n, n2);
    }

    @Override
    protected int handleStartElement(byte by) throws XMLStreamException {
        int n;
        boolean bl;
        this._currToken = 1;
        this._currNsCount = 0;
        PName pName = this.parsePName(by);
        String string = pName.getPrefix();
        if (string == null) {
            bl = true;
        } else {
            pName = this.bindName(pName, string);
            bl = pName.isBound();
        }
        this._tokenName = pName;
        this._currElem = new ElementScope(pName, this._currElem);
        int n2 = 0;
        while (true) {
            boolean bl2;
            PName pName2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = (by = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                do {
                    if (n == 10) {
                        this.markLF();
                    } else if (n == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (n != 32 && n != 9) {
                        this.throwInvalidSpace(n);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((n = (by = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
            } else if (n != 47 && n != 62) {
                n = this.decodeCharForError(by);
                this.throwUnexpectedChar(n, " expected space, or '>' or \"/>\"");
            }
            if (n == 47) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by = this._inputBuffer[this._inputPtr++]) != 62) {
                    n = this.decodeCharForError(by);
                    this.throwUnexpectedChar(n, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (n == 62) {
                this._isEmptyTag = false;
                break;
            }
            if (n == 60) {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((string = (pName2 = this.parsePName(by)).getPrefix()) == null) {
                bl2 = pName2.getLocalName() == "xmlns";
            } else if (string == "xmlns") {
                bl2 = true;
            } else {
                pName2 = this.bindName(pName2, string);
                if (bl) {
                    bl = pName2.isBound();
                }
                bl2 = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n = (by = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (n == 10) {
                    this.markLF();
                    continue;
                }
                if (n == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (n == 32 || n == 9) continue;
                this.throwInvalidSpace(n);
            }
            if (n != 61) {
                n = this.decodeCharForError(by);
                this.throwUnexpectedChar(n, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n = (by = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (n == 10) {
                    this.markLF();
                    continue;
                }
                if (n == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (n == 32 || n == 9) continue;
                this.throwInvalidSpace(n);
            }
            if (n != 34 && n != 39) {
                n = this.decodeCharForError(by);
                this.throwUnexpectedChar(n, " Expected a quote");
            }
            if (bl2) {
                this.handleNsDeclaration(pName2, by);
                ++this._currNsCount;
                continue;
            }
            n2 = this.collectValue(n2, by, pName2);
        }
        n = this._attrCollector.finishLastValue(n2);
        if (n < 0) {
            n = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = n;
        ++this._depth;
        if (!bl) {
            if (!pName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int n3 = this._attrCount;
            for (n = 0; n < n3; ++n) {
                PName pName3 = this._attrCollector.getName(n);
                if (pName3.isBound()) continue;
                this.reportUnboundPrefix(pName3, true);
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private final int collectValue(int var1_1, byte var2_2, PName var3_3) throws XMLStreamException {
        var4_4 = this._attrCollector.startNewValue(var3_3, var1_1);
        var5_5 = this._charTypes.ATTR_CHARS;
        var6_6 = var2_2;
        block13: while (true) {
            block25: {
                if ((var8_8 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var8_8 = this._inputPtr;
                }
                if (var1_1 >= var4_4.length) {
                    var4_4 = this._attrCollector.valueBufferFull();
                }
                if ((var10_10 = var8_8 + (var4_4.length - var1_1)) < (var9_9 = this._inputEnd)) {
                    var9_9 = var10_10;
                }
                while (var8_8 < var9_9) {
                    if (var5_5[var7_7 = this._inputBuffer[var8_8++] & 255] == 0) {
                        var4_4[var1_1++] = (char)var7_7;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = var8_8;
                continue;
            }
            this._inputPtr = var8_8;
            switch (var5_5[var7_7]) {
                case 1: {
                    var7_7 = this.handleInvalidXmlChar(var7_7);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    var7_7 = 32;
                    ** GOTO lbl63
                }
                case 5: {
                    var7_7 = this.decodeUtf8_2(var7_7);
                    ** GOTO lbl63
                }
                case 6: {
                    var7_7 = this.decodeUtf8_3(var7_7);
                    ** GOTO lbl63
                }
                case 7: {
                    var7_7 = this.decodeUtf8_4(var7_7);
                    var4_4[var1_1++] = (char)(55296 | var7_7 >> 10);
                    var7_7 = 56320 | var7_7 & 1023;
                    if (var1_1 >= var4_4.length) {
                        var4_4 = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(var7_7);
                }
                case 9: {
                    this.throwUnexpectedChar(var7_7, "'<' not allowed in attribute value");
                }
                case 10: {
                    var7_7 = this.handleEntityInText(false);
                    if (var7_7 == 0) {
                        this.reportUnexpandedEntityInAttr(var3_3, false);
                    }
                    if (var7_7 >> 16 != 0) {
                        var4_4[var1_1++] = (char)(55296 | (var7_7 -= 65536) >> 10);
                        var7_7 = 56320 | var7_7 & 1023;
                        if (var1_1 >= var4_4.length) {
                            var4_4 = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl63
                }
                case 14: {
                    if (var7_7 == var6_6) break block13;
                }
lbl63:
                // 7 sources

                default: {
                    var4_4[var1_1++] = (char)var7_7;
                    continue block13;
                }
            }
            break;
        }
        return var1_1;
    }

    private void handleNsDeclaration(PName pName, byte by) throws XMLStreamException {
        int n = 0;
        char[] cArray = this._nameBuffer;
        while (true) {
            int n2;
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++]) == by) break;
            if (n3 == 38) {
                n2 = this.handleEntityInText(false);
                if (n2 == 0) {
                    this.reportUnexpandedEntityInAttr(pName, true);
                }
                if (n2 >> 16 != 0) {
                    if (n >= cArray.length) {
                        this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                    }
                    cArray[n++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                    n2 = 0xDC00 | n2 & 0x3FF;
                }
            } else if (n3 == 60) {
                n2 = n3;
                this.throwUnexpectedChar(n2, "'<' not allowed in attribute value");
            } else {
                n2 = n3 & 0xFF;
                if (n2 < 32) {
                    if (n2 == 10) {
                        this.markLF();
                    } else if (n2 == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (n2 < 0) {
                        if ((n2 = this.decodeMultiByteChar(n2, this._inputPtr)) < 0) {
                            n2 = -n2;
                            if (n >= cArray.length) {
                                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                            }
                            cArray[n++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                            n2 = 0xDC00 | n2 & 0x3FF;
                        }
                    } else if (n2 != 9) {
                        this.throwInvalidSpace(n2);
                    }
                }
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n++] = (char)n2;
        }
        if (n == 0) {
            this.bindNs(pName, "");
        } else {
            String string = this._config.canonicalizeURI(cArray, n);
            this.bindNs(pName, string);
        }
    }

    @Override
    protected final int handleEntityInText(boolean bl) throws XMLStreamException {
        int n;
        String string;
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 35) {
            return this.handleCharEntity();
        }
        if (by == 97) {
            byte by2 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (by == 109) {
                byte by3 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by == 112) {
                    byte by4 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (by == 59) {
                        return 38;
                    }
                    string = "amp";
                } else {
                    string = "am";
                }
            } else if (by == 112) {
                byte by5 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by == 111) {
                    byte by6 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (by == 115) {
                        byte by7 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (by == 59) {
                            return 39;
                        }
                        string = "apos";
                    } else {
                        string = "apo";
                    }
                } else {
                    string = "ap";
                }
            } else {
                string = "a";
            }
        } else if (by == 108) {
            byte by8 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (by == 116) {
                byte by9 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by == 59) {
                    return 60;
                }
                string = "lt";
            } else {
                string = "l";
            }
        } else if (by == 103) {
            byte by10 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (by == 116) {
                byte by11 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by == 59) {
                    return 62;
                }
                string = "gt";
            } else {
                string = "g";
            }
        } else if (by == 113) {
            byte by12 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (by == 117) {
                byte by13 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by == 111) {
                    byte by14 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (by == 116) {
                        byte by15 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (by == 59) {
                            return 34;
                        }
                        string = "quot";
                    } else {
                        string = "quo";
                    }
                } else {
                    string = "qu";
                }
            } else {
                string = "q";
            }
        } else {
            string = "";
        }
        int[] nArray = this._charTypes.NAME_CHARS;
        char[] cArray = this._nameBuffer;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            cArray[n] = string.charAt(n);
        }
        while (by != 59) {
            int n3 = by & 0xFF;
            switch (nArray[n3]) {
                case 0: 
                case 1: 
                case 2: {
                    n2 = n > 0 ? 1 : 0;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                case 5: {
                    n3 = this.decodeUtf8_2(n3);
                    n2 = XmlChars.is10NameStartChar(n3) ? 1 : 0;
                    break;
                }
                case 6: {
                    n3 = this.decodeUtf8_3(n3);
                    n2 = XmlChars.is10NameStartChar(n3) ? 1 : 0;
                    break;
                }
                case 7: {
                    n3 = this.decodeUtf8_4(n3);
                    n2 = XmlChars.is10NameStartChar(n3) ? 1 : 0;
                    if (n2 == 0) break;
                    if (n >= cArray.length) {
                        this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                    }
                    cArray[n++] = (char)(0xD800 | (n3 -= 65536) >> 10);
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (n2 == 0) {
                this.reportInvalidNameChar(n3, n);
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n++] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            by = this._inputBuffer[this._inputPtr++];
        }
        String string2 = new String(cArray, 0, n);
        this._tokenName = new PNameC(string2, null, string2, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + string2 + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (bl) {
            this.reportInputProblem("General entity reference (&" + string2 + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected final PName addPName(int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        return this.addUtfPName(this._charTypes, n, nArray, n2, n3);
    }

    @Override
    protected String parsePublicId(byte by) throws XMLStreamException {
        char[] cArray = this._nameBuffer;
        int n = 0;
        int[] nArray = XmlCharTypes.PUBID_CHARS;
        boolean bl = false;
        while (true) {
            byte by2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) == by) break;
            int n2 = by2 & 0xFF;
            if (nArray[n2] != 1) {
                this.throwUnexpectedChar(n2, " in public identifier");
            }
            if (n2 <= 32) {
                bl = true;
                continue;
            }
            if (bl) {
                if (n >= cArray.length) {
                    cArray = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = 32;
                bl = false;
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        return new String(cArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String parseSystemId(byte by) throws XMLStreamException {
        char[] cArray = this._nameBuffer;
        int n = 0;
        int[] nArray = this._charTypes.ATTR_CHARS;
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 5: {
                        n2 = this.decodeUtf8_2(n2);
                        break;
                    }
                    case 6: {
                        n2 = this.decodeUtf8_3(n2);
                        break;
                    }
                    case 7: {
                        n2 = this.decodeUtf8_4(n2);
                        if (n >= cArray.length) {
                            cArray = this._textBuilder.finishCurrentSegment();
                            n = 0;
                        }
                        cArray[n++] = (char)(0xD800 | n2 >> 10);
                        n2 = 0xDC00 | n2 & 0x3FF;
                        break;
                    }
                    case 4: {
                        this.reportInvalidInitial(n2);
                    }
                    case 14: {
                        if (n2 != by) break;
                        return new String(cArray, 0, n);
                    }
                }
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] nArray = this._charTypes.TEXT_CHARS;
        byte[] byArray = this._inputBuffer;
        block12: while (true) {
            int n;
            int n2;
            int n3;
            block19: {
                if ((n3 = this._inputPtr) >= (n2 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                    n2 = this._inputEnd;
                }
                while (n3 < n2) {
                    if (nArray[n = byArray[n3++] & 0xFF] == 0) continue;
                    break block19;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            switch (nArray[n]) {
                case 1: {
                    n = this.handleInvalidXmlChar(n);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (byArray[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(n);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(n);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(n);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(n);
                }
                case 9: {
                    --this._inputPtr;
                    return false;
                }
                case 10: {
                    n = this.handleEntityInText(false);
                    if (n != 0) break;
                    return true;
                }
                case 11: {
                    n3 = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((n2 = byArray[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++n3;
                    }
                    if (n2 != 62 || n3 <= 1) continue block12;
                    this.reportIllegalCDataEnd();
                }
            }
        }
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] nArray = this._charTypes.OTHER_CHARS;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n;
            int n2;
            block18: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            switch (nArray[n]) {
                case 1: {
                    n = this.handleInvalidXmlChar(n);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (byArray[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(n);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(n);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(n);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(n);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 45) break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != 62) {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] nArray = this._charTypes.OTHER_CHARS;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n;
            int n2;
            int n3;
            block18: {
                if ((n3 = this._inputPtr) >= (n2 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                    n2 = this._inputEnd;
                }
                while (n3 < n2) {
                    if (nArray[n = byArray[n3++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            switch (nArray[n]) {
                case 1: {
                    n = this.handleInvalidXmlChar(n);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (byArray[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(n);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(n);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(n);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(n);
                }
                case 11: {
                    n3 = 0;
                    do {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        ++n3;
                    } while ((n2 = this._inputBuffer[this._inputPtr++]) == 93);
                    if (n2 == 62) {
                        if (n3 <= 1) break;
                        return;
                    }
                    --this._inputPtr;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] nArray = this._charTypes.OTHER_CHARS;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n;
            int n2;
            block16: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block16;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            switch (nArray[n]) {
                case 1: {
                    n = this.handleInvalidXmlChar(n);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (byArray[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(n);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(n);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(n);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(n);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 62) break;
                    ++this._inputPtr;
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int n = this._inputPtr;
        while (true) {
            int n2;
            if (n >= this._inputEnd) {
                if (!this.loadMore()) break;
                n = this._inputPtr;
            }
            if ((n2 = this._inputBuffer[n] & 0xFF) > 32) break;
            ++n;
            if (n2 == 10) {
                this.markLF(n);
                continue;
            }
            if (n2 == 13) {
                if (n >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    n = this._inputPtr;
                }
                if (this._inputBuffer[n] == 10) {
                    ++n;
                }
                this.markLF(n);
                continue;
            }
            if (n2 == 32 || n2 == 9) continue;
            this._inputPtr = n;
            this.throwInvalidSpace(n2);
        }
        this._inputPtr = n;
    }

    private final void skipUtf8_2(int n) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(n & 0xFF, this._inputPtr);
        }
    }

    private final void skipUtf8_3(int n) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n &= 0xF) >= 13) {
            byte by;
            n <<= 6;
            if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(by & 0xFF, this._inputPtr);
            }
            n |= by & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(by & 0xFF, this._inputPtr);
            }
            if ((n = n << 6 | by & 0x3F) >= 55296 && (n < 57344 || n >= 65534 && n <= 65535)) {
                n = this.handleInvalidXmlChar(n);
            }
        } else {
            if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(n & 0xFF, this._inputPtr);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(n & 0xFF, this._inputPtr);
            }
        }
    }

    private final void skipUtf8_4(int n) throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCData() throws XMLStreamException {
        var1_1 = this._charTypes.OTHER_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.resetWithEmpty();
        var4_4 = 0;
        block10: while (true) {
            block26: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block26;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl75
                }
                case 6: {
                    var5_5 = this.decodeUtf8_3(var5_5);
                    ** GOTO lbl75
                }
                case 7: {
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 11: {
                    var6_6 = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((var7_7 = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++var6_6;
                    }
                    v0 = var8_8 = var7_7 == 62 && var6_6 >= 1 ? 1 : 0;
                    if (var8_8 != 0) {
                        --var6_6;
                    }
                    while (var6_6 > 0) {
                        var3_3[var4_4++] = 93;
                        if (var4_4 >= var3_3.length) {
                            var3_3 = this._textBuilder.finishCurrentSegment();
                            var4_4 = 0;
                        }
                        --var6_6;
                    }
                    if (var8_8 != 0) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var4_4);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        var2_1 = this._tmpChar;
        if (var2_1 < 0) {
            var2_1 = -var2_1;
            var3_2 = this._textBuilder.resetWithEmpty();
            var1_3 = 0;
            if (var2_1 >> 16 != 0) {
                var3_2[var1_3++] = (char)(55296 | (var2_1 -= 65536) >> 10);
                var2_1 = 56320 | var2_1 & 1023;
            }
            var3_2[var1_3++] = (char)var2_1;
        } else if (var2_1 == 13 || var2_1 == 10) {
            ++this._inputPtr;
            var1_3 = this.checkInTreeIndentation(var2_1);
            if (var1_3 < 0) {
                return;
            }
            var3_2 = this._textBuilder.getBufferWithoutReset();
        } else {
            var3_2 = this._textBuilder.resetWithEmpty();
            var1_3 = 0;
        }
        var4_4 = this._charTypes.TEXT_CHARS;
        var5_5 = this._inputBuffer;
        block12: while (true) {
            block35: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var1_3 >= var3_2.length) {
                    var3_2 = this._textBuilder.finishCurrentSegment();
                    var1_3 = 0;
                }
                if ((var8_8 = var6_6 + (var3_2.length - var1_3)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var4_4[var2_1 = var5_5[var6_6++] & 255] == 0) {
                        var3_2[var1_3++] = (char)var2_1;
                        continue;
                    }
                    break block35;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var4_4[var2_1]) {
                case 1: {
                    var2_1 = this.handleInvalidXmlChar(var2_1);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var5_5[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var2_1 = 10;
                    ** GOTO lbl103
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl103
                }
                case 5: {
                    var2_1 = this.decodeUtf8_2(var2_1);
                    ** GOTO lbl103
                }
                case 6: {
                    var2_1 = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(var2_1) : this.decodeUtf8_3(var2_1);
                    ** GOTO lbl103
                }
                case 7: {
                    var2_1 = this.decodeUtf8_4(var2_1);
                    var3_2[var1_3++] = (char)(55296 | var2_1 >> 10);
                    if (var1_3 >= var3_2.length) {
                        var3_2 = this._textBuilder.finishCurrentSegment();
                        var1_3 = 0;
                    }
                    var2_1 = 56320 | var2_1 & 1023;
                    ** GOTO lbl103
                }
                case 4: {
                    this.reportInvalidInitial(var2_1);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    var2_1 = this.handleEntityInText(false);
                    if (var2_1 == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (var2_1 >> 16 == 0) ** GOTO lbl103
                    var3_2[var1_3++] = (char)(55296 | (var2_1 -= 65536) >> 10);
                    if (var1_3 >= var3_2.length) {
                        var3_2 = this._textBuilder.finishCurrentSegment();
                        var1_3 = 0;
                    }
                    var2_1 = 56320 | var2_1 & 1023;
                    ** GOTO lbl103
                }
                case 11: {
                    var6_6 = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((var7_7 = var5_5[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++var6_6;
                    }
                    if (var7_7 == 62 && var6_6 > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (var6_6 > 1) {
                        var3_2[var1_3++] = 93;
                        if (var1_3 >= var3_2.length) {
                            var3_2 = this._textBuilder.finishCurrentSegment();
                            var1_3 = 0;
                        }
                        --var6_6;
                    }
                }
lbl103:
                // 9 sources

                default: {
                    var3_2[var1_3++] = (char)var2_1;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var1_3);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishComment() throws XMLStreamException {
        var1_1 = this._charTypes.OTHER_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.resetWithEmpty();
        var4_4 = 0;
        block10: while (true) {
            block22: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block22;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl63
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl63
                }
                case 5: {
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl63
                }
                case 6: {
                    var5_5 = this.decodeUtf8_3(var5_5);
                    ** GOTO lbl63
                }
                case 7: {
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 45) {
                        ++this._inputPtr;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr++] == 62) break block10;
                        this.reportDoubleHyphenInComments();
                        break block10;
                    }
                }
lbl63:
                // 8 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var4_4);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishDTD(boolean var1_1) throws XMLStreamException {
        var2_2 = var1_1 != false ? this._textBuilder.resetWithEmpty() : null;
        var3_3 = 0;
        var4_4 = this._charTypes.DTD_CHARS;
        var5_5 = false;
        var6_6 = 0;
        block13: while (true) {
            block31: {
                if ((var8_8 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var8_8 = this._inputPtr;
                }
                var9_9 = this._inputEnd;
                if (var2_2 != null) {
                    if (var3_3 >= var2_2.length) {
                        var2_2 = this._textBuilder.finishCurrentSegment();
                        var3_3 = 0;
                    }
                    if ((var10_10 = var8_8 + (var2_2.length - var3_3)) < var9_9) {
                        var9_9 = var10_10;
                    }
                }
                while (var8_8 < var9_9) {
                    if (var4_4[var7_7 = this._inputBuffer[var8_8++] & 255] == 0) {
                        if (var2_2 == null) continue;
                        var2_2[var3_3++] = (char)var7_7;
                        continue;
                    }
                    break block31;
                }
                this._inputPtr = var8_8;
                continue;
            }
            this._inputPtr = var8_8;
            switch (var4_4[var7_7]) {
                case 1: {
                    var7_7 = this.handleInvalidXmlChar(var7_7);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var7_7 = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    var7_7 = this.decodeUtf8_2(var7_7);
                    ** GOTO lbl75
                }
                case 6: {
                    var7_7 = this.decodeUtf8_3(var7_7);
                    ** GOTO lbl75
                }
                case 7: {
                    var7_7 = this.decodeUtf8_4(var7_7);
                    if (var2_2 != null) {
                        var2_2[var3_3++] = (char)(55296 | var7_7 >> 10);
                        var7_7 = 56320 | var7_7 & 1023;
                        if (var3_3 >= var2_2.length) {
                            var2_2 = this._textBuilder.finishCurrentSegment();
                            var3_3 = 0;
                        }
                    }
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(var7_7);
                }
                case 8: {
                    if (var6_6 == 0) {
                        var6_6 = var7_7;
                    } else if (var6_6 == var7_7) {
                        var6_6 = 0;
                    }
                    ** GOTO lbl75
                }
                case 9: {
                    if (!var5_5) {
                        var5_5 = true;
                    }
                    ** GOTO lbl75
                }
                case 10: {
                    if (var6_6 == 0) {
                        var5_5 = false;
                    }
                    ** GOTO lbl75
                }
                case 11: {
                    if (!var5_5 && var6_6 == 0) break block13;
                }
lbl75:
                // 11 sources

                default: {
                    if (var2_2 == null) continue block13;
                    var2_2[var3_3++] = (char)var7_7;
                    continue block13;
                }
            }
            break;
        }
        if (var2_2 != null) {
            this._textBuilder.setCurrentLength(var3_3);
        }
        if ((var7_7 = (int)this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)var7_7), " expected '>' after the internal subset");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishPI() throws XMLStreamException {
        var1_1 = this._charTypes.OTHER_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.resetWithEmpty();
        var4_4 = 0;
        block10: while (true) {
            block21: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block21;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl59
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl59
                }
                case 5: {
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl59
                }
                case 6: {
                    var5_5 = this.decodeUtf8_3(var5_5);
                    ** GOTO lbl59
                }
                case 7: {
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl59
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 62) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl59:
                // 8 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var4_4);
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] cArray;
        int n;
        int n2 = this._tmpChar;
        if (n2 == 13 || n2 == 10) {
            n = this.checkPrologIndentation(n2);
            if (n < 0) {
                return;
            }
            cArray = this._textBuilder.getBufferWithoutReset();
        } else {
            cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = (char)n2;
            n = 1;
        }
        int n3 = this._inputPtr;
        while (true) {
            int n4;
            if (n3 >= this._inputEnd) {
                if (!this.loadMore()) break;
                n3 = this._inputPtr;
            }
            if ((n4 = this._inputBuffer[n3] & 0xFF) > 32) break;
            ++n3;
            if (n4 == 10) {
                this.markLF(n3);
            } else if (n4 == 13) {
                if (n3 >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (n >= cArray.length) {
                            cArray = this._textBuilder.finishCurrentSegment();
                            n = 0;
                        }
                        cArray[n++] = 10;
                        break;
                    }
                    n3 = this._inputPtr;
                }
                if (this._inputBuffer[n3] == 10) {
                    ++n3;
                }
                this.markLF(n3);
                n4 = 10;
            } else if (n4 != 32 && n4 != 9) {
                this._inputPtr = n3;
                this.throwInvalidSpace(n4);
            }
            if (n >= cArray.length) {
                cArray = this._textBuilder.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n4;
        }
        this._inputPtr = n3;
        this._textBuilder.setCurrentLength(n);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte by;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((by = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int n = this.decodeCharForError(by);
                    this.reportTreeUnexpChar(n, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCharacters() throws XMLStreamException {
        var1_1 = this._charTypes.TEXT_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.getBufferWithoutReset();
        var4_4 = this._textBuilder.getCurrentLength();
        block12: while (true) {
            block28: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block28;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl86
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl86
                }
                case 5: {
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl86
                }
                case 6: {
                    var5_5 = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(var5_5) : this.decodeUtf8_3(var5_5);
                    ** GOTO lbl86
                }
                case 7: {
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl86
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    var5_5 = this.handleEntityInText(false);
                    if (var5_5 == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (var5_5 >> 16 == 0) ** GOTO lbl86
                    var3_3[var4_4++] = (char)(55296 | (var5_5 -= 65536) >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl86
                }
                case 11: {
                    var6_6 = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((var7_7 = var2_2[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++var6_6;
                    }
                    if (var7_7 == 62 && var6_6 > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (var6_6 > 1) {
                        var3_3[var4_4++] = 93;
                        if (var4_4 >= var3_3.length) {
                            var3_3 = this._textBuilder.finishCurrentSegment();
                            var4_4 = 0;
                        }
                        --var6_6;
                    }
                }
lbl86:
                // 9 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var4_4);
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCData() throws XMLStreamException {
        var1_1 = this._charTypes.OTHER_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.getBufferWithoutReset();
        var4_4 = this._textBuilder.getCurrentLength();
        block10: while (true) {
            block25: {
                if ((var6_6 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    var6_6 = this._inputPtr;
                }
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl75
                }
                case 6: {
                    var5_5 = this.decodeUtf8_3(var5_5);
                    ** GOTO lbl75
                }
                case 7: {
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 11: {
                    var6_6 = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((var7_7 = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++var6_6;
                    }
                    v0 = var8_8 = var7_7 == 62 && var6_6 >= 1 ? 1 : 0;
                    if (var8_8 != 0) {
                        --var6_6;
                    }
                    while (var6_6 > 0) {
                        var3_3[var4_4++] = 93;
                        if (var4_4 >= var3_3.length) {
                            var3_3 = this._textBuilder.finishCurrentSegment();
                            var4_4 = 0;
                        }
                        --var6_6;
                    }
                    if (var8_8 != 0) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(var4_4);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte by;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((by = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int n = this.decodeCharForError(by);
                    this.reportTreeUnexpChar(n, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    private final int decodeMultiByteChar(int n, int n2) throws XMLStreamException {
        byte by;
        int n3;
        if ((n & 0xE0) == 192) {
            n &= 0x1F;
            n3 = 1;
        } else if ((n & 0xF0) == 224) {
            n &= 0xF;
            n3 = 2;
        } else if ((n & 0xF8) == 240) {
            n &= 7;
            n3 = 3;
        } else {
            this.reportInvalidInitial(n & 0xFF);
            n3 = 1;
        }
        if (n2 >= this._inputEnd) {
            this.loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        if (((by = this._inputBuffer[n2++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, n2);
        }
        n = n << 6 | by & 0x3F;
        if (n3 > 1) {
            if (n2 >= this._inputEnd) {
                this.loadMoreGuaranteed();
                n2 = this._inputPtr;
            }
            if (((by = this._inputBuffer[n2++]) & 0xC0) != 128) {
                this.reportInvalidOther(by & 0xFF, n2);
            }
            n = n << 6 | by & 0x3F;
            if (n3 > 2) {
                if (n2 >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                }
                if (((by = this._inputBuffer[n2++]) & 0xC0) != 128) {
                    this.reportInvalidOther(by & 0xFF, n2);
                }
                n = n << 6 | by & 0x3F;
                n = -n;
            }
        }
        this._inputPtr = n2;
        return n;
    }

    private final int decodeUtf8_2(int n) throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    private final int decodeUtf8_3(int n) throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (n >= 13 && n2 >= 55296 && (n2 < 57344 || n2 >= 65534 && n2 <= 65535)) {
            n2 = this.handleInvalidXmlChar(n2);
        }
        return n2;
    }

    private final int decodeUtf8_3fast(int n) throws XMLStreamException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (n >= 13 && n2 >= 55296 && (n2 < 57344 || n2 >= 65534 && n2 <= 65535)) {
            n2 = this.handleInvalidXmlChar(n2);
        }
        return n2;
    }

    private final int decodeUtf8_4(int n) throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    @Override
    public int decodeCharForError(byte n) throws XMLStreamException {
        int n2;
        int n3 = n;
        if (n3 >= 0) {
            return n3;
        }
        if ((n3 & 0xE0) == 192) {
            n3 &= 0x1F;
            n2 = 1;
        } else if ((n3 & 0xF0) == 224) {
            n3 &= 0xF;
            n2 = 2;
        } else if ((n3 & 0xF8) == 240) {
            n3 &= 7;
            n2 = 3;
        } else {
            this.reportInvalidInitial(n3 & 0xFF);
            n2 = 1;
        }
        byte by = this.nextByte();
        if ((by & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF);
        }
        n3 = n3 << 6 | by & 0x3F;
        if (n2 > 1) {
            by = this.nextByte();
            if ((by & 0xC0) != 128) {
                this.reportInvalidOther(by & 0xFF);
            }
            n3 = n3 << 6 | by & 0x3F;
            if (n2 > 2) {
                by = this.nextByte();
                if ((by & 0xC0) != 128) {
                    this.reportInvalidOther(by & 0xFF);
                }
                n3 = n3 << 6 | by & 0x3F;
            }
        }
        return n3;
    }

    @Override
    protected void reportInvalidInitial(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    @Override
    protected void reportInvalidOther(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void reportInvalidOther(int n, int n2) throws XMLStreamException {
        this._inputPtr = n2;
        this.reportInvalidOther(n);
    }
}

