/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import java.util.LinkedHashMap;
import java.util.Map;

public final class UriCanonicalizer {
    private BoundedHashMap mURIs = null;

    private void init() {
        this.mURIs = new BoundedHashMap();
    }

    public synchronized String canonicalizeURI(char[] cArray, int n) {
        String string;
        CanonicalKey canonicalKey = new CanonicalKey(cArray, n);
        if (this.mURIs == null) {
            this.init();
        } else {
            string = (String)this.mURIs.get(canonicalKey);
            if (string != null) {
                return string;
            }
        }
        canonicalKey = canonicalKey.safeClone();
        string = new String(cArray, 0, n).intern();
        this.mURIs.put(canonicalKey, string);
        return string;
    }

    static final class CanonicalKey {
        final char[] mChars;
        final int mLength;
        final int mHash;

        public CanonicalKey(char[] cArray, int n) {
            this.mChars = cArray;
            this.mLength = n;
            this.mHash = CanonicalKey.calcKeyHash(cArray, n);
        }

        public CanonicalKey(char[] cArray, int n, int n2) {
            this.mChars = cArray;
            this.mLength = n;
            this.mHash = n2;
        }

        public CanonicalKey safeClone() {
            char[] cArray = new char[this.mLength];
            System.arraycopy(this.mChars, 0, cArray, 0, this.mLength);
            return new CanonicalKey(cArray, this.mLength, this.mHash);
        }

        public static int calcKeyHash(char[] cArray, int n) {
            if (n <= 8) {
                int n2 = cArray[0];
                for (int i = 1; i < n; ++i) {
                    n2 = n2 * 31 + cArray[i];
                }
                return n2;
            }
            int n3 = n ^ cArray[0];
            int n4 = 2;
            int n5 = 2;
            int n6 = n - 4;
            while (n4 < n6) {
                n3 = n3 * 31 + cArray[n4];
                n4 += n5;
                ++n5;
            }
            n3 = n3 * 31 ^ (cArray[n6] << 2) + cArray[n6 + 1];
            n3 = n3 * 31 + (cArray[n6 + 2] << 2) ^ cArray[n6 + 3];
            return n3;
        }

        public String toString() {
            return "{URI, hash: 0x" + Integer.toHexString(this.mHash) + "}";
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            CanonicalKey canonicalKey = (CanonicalKey)object;
            if (canonicalKey.mLength != this.mLength) {
                return false;
            }
            char[] cArray = this.mChars;
            char[] cArray2 = canonicalKey.mChars;
            int n = this.mLength;
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
            return true;
        }
    }

    static final class BoundedHashMap
    extends LinkedHashMap<CanonicalKey, String> {
        private static final int DEFAULT_SIZE = 64;
        private static final int MAX_SIZE = 716;

        public BoundedHashMap() {
            super(64, 0.7f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<CanonicalKey, String> entry) {
            return this.size() >= 716;
        }
    }
}

