/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.iteration.impl.RemovableEntryIterator;
import org.infinispan.transaction.impl.LocalTransaction;

public class TransactionAwareCloseableIterator<K, C>
extends RemovableEntryIterator<K, C> {
    private final TxInvocationContext<LocalTransaction> ctx;
    private final List<CacheEntry> contextEntries;
    private final Set<Object> seenContextKeys = new HashSet<Object>();

    public TransactionAwareCloseableIterator(CloseableIterator<CacheEntry<K, C>> realIterator, TxInvocationContext<LocalTransaction> ctx, Cache<K, ?> cache) {
        super(realIterator, cache, false);
        this.ctx = ctx;
        this.contextEntries = new ArrayList<CacheEntry>(ctx.getLookedUpEntries().values());
        this.currentValue = this.getNextFromIterator();
    }

    @Override
    protected CacheEntry<K, C> getNextFromIterator() {
        CacheEntry entry;
        CacheEntry returnedEntry = null;
        while (!this.contextEntries.isEmpty() && (entry = this.contextEntries.remove(0)) != null) {
            this.seenContextKeys.add(entry.getKey());
            if (this.ctx.isEntryRemovedInContext(entry.getKey())) continue;
            returnedEntry = entry;
        }
        if (returnedEntry == null) {
            while (this.realIterator.hasNext()) {
                CacheEntry iteratedEntry = (CacheEntry)this.realIterator.next();
                CacheEntry contextEntry = this.ctx.lookupEntry(iteratedEntry.getKey());
                if (contextEntry == null) {
                    returnedEntry = iteratedEntry;
                    break;
                }
                if (!this.seenContextKeys.add(contextEntry.getKey()) || contextEntry.isRemoved()) continue;
                returnedEntry = contextEntry;
                break;
            }
        }
        if (returnedEntry == null) {
            for (CacheEntry lookedUpEntry : this.ctx.getLookedUpEntries().values()) {
                if (this.seenContextKeys.contains(lookedUpEntry.getKey())) continue;
                if (returnedEntry == null) {
                    returnedEntry = lookedUpEntry;
                    continue;
                }
                this.contextEntries.add(lookedUpEntry);
            }
        }
        return returnedEntry;
    }
}

