/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partionhandling.AvailabilityMode;
import org.infinispan.partionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingManagerImpl
implements PartitionHandlingManager {
    private static final Log log = LogFactory.getLog(PartitionHandlingManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private DistributionManager distributionManager;
    private RpcManager rpcManager;
    private LocalTopologyManager localTopologyManager;
    private String cacheName;
    private CacheNotifier notifier;

    @Inject
    void init(DistributionManager distributionManager, RpcManager rpcManager, LocalTopologyManager localTopologyManager, Cache cache, CacheNotifier notifier) {
        this.distributionManager = distributionManager;
        this.rpcManager = rpcManager;
        this.localTopologyManager = localTopologyManager;
        this.cacheName = cache.getName();
        this.notifier = notifier;
    }

    @Start
    void start() {
    }

    @Override
    public void setAvailabilityMode(AvailabilityMode availabilityMode) {
        if (availabilityMode != this.availabilityMode) {
            log.debugf("Updating availability for cache %s: %s -> %s", this.cacheName, (Object)this.availabilityMode, (Object)availabilityMode);
            this.notifier.notifyPartitionStatusChanged(availabilityMode, true);
            this.availabilityMode = availabilityMode;
            this.notifier.notifyPartitionStatusChanged(availabilityMode, false);
        }
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    @Override
    public void checkWrite(Object key) {
        this.doCheck(key);
    }

    @Override
    public void checkRead(Object key) {
        this.doCheck(key);
    }

    private void doCheck(Object key) {
        if (trace) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)this.availabilityMode);
        }
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return;
        }
        List<Address> owners = this.distributionManager.locate(key);
        if (!this.rpcManager.getTransport().getMembers().containsAll(owners)) {
            if (trace) {
                log.tracef("Partition is in %s mode, access is not allowed for key %s", (Object)this.availabilityMode, key);
            }
            throw log.degradedModeKeyUnavailable(key);
        }
        if (trace) {
            log.tracef("Key %s is available.", key);
        }
    }

    @Override
    public void checkClear() {
        if (this.availabilityMode != AvailabilityMode.AVAILABLE) {
            throw log.clearDisallowedWhilePartitioned();
        }
    }

    @Override
    public CacheTopology getLastStableTopology() {
        return this.localTopologyManager.getStableCacheTopology(this.cacheName);
    }
}

