/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.mongojack.internal.object.BsonObjectGenerator;
import org.mongojack.internal.stream.DBEncoderBsonGenerator;

public abstract class MongoSerializer<T>
extends JsonSerializer<T> {
    public final void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (jgen instanceof DBEncoderBsonGenerator) {
            this.serialize(value, (DBEncoderBsonGenerator)jgen, provider);
        } else if (jgen instanceof BsonObjectGenerator) {
            this.serialize(value, (BsonObjectGenerator)jgen, provider);
        } else {
            throw new IllegalArgumentException("Mongo serializer may only be used for generating BSON");
        }
    }

    protected abstract void serialize(T var1, DBEncoderBsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;

    protected abstract void serialize(T var1, BsonObjectGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;
}

