/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler;

import java.util.Comparator;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.ProcessorSupport;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.ConstantConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.SelectorConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.util.Settings;

public class Preprocessor
extends ProcessorSupport {
    private static final Settings settings = Settings.getInstance();
    private static final boolean SORT_XML_COMPONENTS = settings.getBoolean("org.beanio.xml.sorted");
    protected StreamConfig stream;
    protected PropertyConfig propertyRoot;
    private boolean recordIgnored;

    public Preprocessor(StreamConfig stream) {
        this.stream = stream;
    }

    protected void initializeStream(StreamConfig stream) throws BeanIOConfigurationException {
        if (stream.getMinOccurs() == null) {
            stream.setMinOccurs(0);
        }
        if (stream.getMaxOccurs() == null) {
            stream.setMaxOccurs(1);
        }
        if (stream.getMaxOccurs() <= 0) {
            throw new BeanIOConfigurationException("Maximum occurrences must be greater than 0");
        }
        this.initializeGroup(stream);
    }

    protected void finalizeStream(StreamConfig stream) throws BeanIOConfigurationException {
        this.finalizeGroup(stream);
        boolean sorted = true;
        if ("xml".equals(stream.getFormat()) && !SORT_XML_COMPONENTS) {
            sorted = false;
        }
        if (sorted) {
            stream.sort(new Comparator<ComponentConfig>(){

                @Override
                public int compare(ComponentConfig c1, ComponentConfig c2) {
                    Integer p1 = this.getPosition(c1);
                    Integer p2 = this.getPosition(c2);
                    if (p1 == null) {
                        if (p2 == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (p2 == null) {
                        return -1;
                    }
                    return p1.compareTo(p2);
                }

                private Integer getPosition(ComponentConfig c) {
                    Integer p = null;
                    switch (c.getComponentType()) {
                        case 'F': 
                        case 'S': {
                            p = ((PropertyConfig)c).getPosition();
                            break;
                        }
                        case 'R': {
                            p = ((RecordConfig)c).getOrder();
                            break;
                        }
                        case 'G': {
                            p = ((GroupConfig)c).getOrder();
                        }
                    }
                    if (p != null && p.compareTo(0) < 0) {
                        p = Integer.MAX_VALUE + p;
                    }
                    return p;
                }
            });
        }
    }

    protected void initializeGroup(GroupConfig group) throws BeanIOConfigurationException {
        if (group.getMinOccurs() == null) {
            group.setMinOccurs(settings.getInt("org.beanio.group.minOccurs", 0));
        }
        if (group.getMaxOccurs() == null) {
            group.setMaxOccurs(Integer.MAX_VALUE);
        }
        if (group.getMaxOccurs() <= 0) {
            throw new BeanIOConfigurationException("Maximum occurrences must be greater than 0");
        }
        if (group.getMaxOccurs() < group.getMinOccurs()) {
            throw new BeanIOConfigurationException("Maximum occurences cannot be less than mininum occurences");
        }
        if (group.getType() != null && group.getTarget() != null) {
            throw new BeanIOConfigurationException("Cannot set both 'class' and 'value'");
        }
        if (this.propertyRoot != null) {
            group.setBound(true);
            if (group.getCollection() != null && group.getType() == null) {
                throw new BeanIOConfigurationException("Class required if collection is set");
            }
            if (group.getType() != null && group.getMaxOccurs() > 1 && group.getCollection() == null) {
                throw new BeanIOConfigurationException("Collection required when maxOccurs is greater than 1 and class is set");
            }
            if (group.isRepeating() && group.getCollection() == null) {
                group.setBound(false);
            }
        }
        if (this.propertyRoot == null && (group.getType() != null || group.getTarget() != null)) {
            this.propertyRoot = group;
        }
    }

    protected void finalizeGroup(GroupConfig group) throws BeanIOConfigurationException {
        int lastOrder = 0;
        Boolean orderSet = null;
        for (ComponentConfig node : group.getChildren()) {
            String typeDescription;
            SelectorConfig child = (SelectorConfig)((Object)node);
            String string = typeDescription = child.getComponentType() == 'R' ? "record" : "group";
            if (child.getOrder() != null && child.getOrder() < 0) {
                throw new BeanIOConfigurationException("Order must be 1 or greater");
            }
            if (orderSet == null) {
                orderSet = child.getOrder() != null;
            } else if (orderSet ^ child.getOrder() != null) {
                throw new BeanIOConfigurationException("Order must be set all children at a group level, or none at all");
            }
            if (orderSet.booleanValue()) {
                if (child.getOrder() < lastOrder) {
                    throw new BeanIOConfigurationException("'" + child.getName() + "' " + typeDescription + " configuration is out of order");
                }
                lastOrder = child.getOrder();
                continue;
            }
            if (this.stream.isStrict()) {
                child.setOrder(++lastOrder);
                continue;
            }
            child.setOrder(1);
        }
        if (this.propertyRoot == group) {
            this.propertyRoot = null;
        }
    }

    protected void initializeRecord(RecordConfig record) throws BeanIOConfigurationException {
        this.recordIgnored = false;
        if (record.getType() == null && record.getTarget() == null && (this.propertyRoot == null || record.isRepeating())) {
            this.recordIgnored = true;
        }
        if (record.getMinOccurs() == null) {
            record.setMinOccurs(settings.getInt("org.beanio.record.minOccurs", 0));
        }
        if (record.getMaxOccurs() == null) {
            record.setMaxOccurs(Integer.MAX_VALUE);
        }
        if (record.getMaxOccurs() <= 0) {
            throw new BeanIOConfigurationException("Maximum occurrences must be greater than 0");
        }
        if (this.propertyRoot == null) {
            this.propertyRoot = record;
            if (record.isLazy()) {
                throw new BeanIOConfigurationException("Lazy cannot be true for unbound records");
            }
        }
        this.initializeSegment(record);
    }

    protected void finalizeRecord(RecordConfig record) throws BeanIOConfigurationException {
        this.finalizeSegment(record);
        if (this.propertyRoot == record) {
            this.propertyRoot = null;
        }
    }

    protected void initializeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
        if (segment.getName() == null) {
            throw new BeanIOConfigurationException("name must be set");
        }
        if (segment.getLabel() == null) {
            segment.setLabel(segment.getName());
        }
        if (segment.getType() != null && segment.getTarget() != null) {
            throw new BeanIOConfigurationException("Cannot set both 'class' and 'value'");
        }
        if (segment.getMinOccurs() == null) {
            segment.setMinOccurs(segment.getOccursRef() != null ? 0 : 1);
        }
        if (segment.getMaxOccurs() == null) {
            segment.setMaxOccurs(segment.getOccursRef() != null ? Integer.MAX_VALUE : 1);
        }
        if (segment.getMaxOccurs() <= 0) {
            throw new BeanIOConfigurationException("Maximum occurrences must be greater than 0");
        }
        if (segment.getMaxOccurs() < segment.getMinOccurs()) {
            throw new BeanIOConfigurationException("Maximum occurrences cannot be less than mininum occurrences");
        }
        if (segment.getKey() != null && segment.getCollection() == null) {
            throw new BeanIOConfigurationException("Unexpected key value when collection not set");
        }
        if (segment.getCollection() != null && segment.getType() == null && segment.getTarget() == null) {
            throw new BeanIOConfigurationException("Class or value required if collection is set");
        }
        if (this.propertyRoot == null || this.propertyRoot != segment) {
            segment.setBound(true);
            if (segment.getMaxOccurs() > 1 && segment.getCollection() == null) {
                if (segment.getType() != null) {
                    throw new BeanIOConfigurationException("Collection required when maxOccurs is greater than 1 and class is set");
                }
                if (segment.getTarget() != null) {
                    throw new BeanIOConfigurationException("Collection required when maxOccurs is greater than 1 and value is set");
                }
            }
            if (segment.getComponentType() == 'R' && segment.isRepeating() && segment.getType() == null && segment.getTarget() == null) {
                segment.setBound(false);
            }
        } else if (segment.getCollection() != null) {
            throw new BeanIOConfigurationException("Collection cannot be set on unbound record or segment.");
        }
    }

    protected void finalizeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
        for (PropertyConfig child : segment.getPropertyList()) {
            if (!child.isIdentifier()) continue;
            segment.setIdentifier(true);
            break;
        }
    }

    protected void handleField(FieldConfig field) throws BeanIOConfigurationException {
        if (this.recordIgnored) {
            field.setBound(false);
        }
        if (field.getName() == null) {
            throw new BeanIOConfigurationException("name is required");
        }
        if (field.getLabel() == null) {
            field.setLabel(field.getName());
        }
        if (field.getMinOccurs() == null) {
            field.setMinOccurs(field.getOccursRef() != null ? 0 : settings.getInt("org.beanio.field.minOccurs." + this.stream.getFormat(), 0));
        }
        if (field.getMaxOccurs() == null) {
            field.setMaxOccurs(field.getOccursRef() != null ? Integer.MAX_VALUE : Math.max(field.getMinOccurs(), 1));
        }
        if (field.getMaxOccurs() <= 0) {
            throw new BeanIOConfigurationException("Maximum occurrences must be greater than 0");
        }
        if (field.getMaxOccurs() < field.getMinOccurs()) {
            throw new BeanIOConfigurationException("Maximum occurrences cannot be less than minimum occurrences");
        }
        if (field.getMinLength() == null) {
            field.setMinLength(0);
        }
        if (field.getMaxLength() == null) {
            field.setMaxLength(Integer.MAX_VALUE);
        }
        if (field.getMaxLength() < field.getMinLength()) {
            throw new BeanIOConfigurationException("maxLength must be greater than or equal to minLength");
        }
        if (field.getLiteral() != null) {
            int literalLength = field.getLiteral().length();
            if (literalLength < field.getMinLength()) {
                throw new BeanIOConfigurationException("literal text length is less than minLength");
            }
            if (literalLength > field.getMaxLength()) {
                throw new BeanIOConfigurationException("literal text length is greater than maxLength");
            }
        }
        if (field.isRepeating() && field.isIdentifier()) {
            throw new BeanIOConfigurationException("repeating fields cannot be used as identifiers");
        }
        if (field.isBound() && field.isRepeating() && field.getCollection() == null) {
            throw new BeanIOConfigurationException("collection not set");
        }
        if (field.isIdentifier()) {
            this.validateRecordIdentifyingCriteria(field);
        }
    }

    protected void handleConstant(ConstantConfig constant) throws BeanIOConfigurationException {
        constant.setBound(true);
        if (constant.getName() == null) {
            throw new BeanIOConfigurationException("Missing property name");
        }
    }

    protected void validateRecordIdentifyingCriteria(FieldConfig field) throws BeanIOConfigurationException {
        if (field.getLiteral() == null && field.getRegex() == null) {
            throw new BeanIOConfigurationException("Literal or regex pattern required for identifying fields");
        }
    }
}

