/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.beanio.BeanIOException;
import org.beanio.BeanWriterException;
import org.beanio.Marshaller;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Selector;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordWriter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerImpl
implements Marshaller {
    private Selector layout;
    private MarshallingContext context;
    private RecordMarshaller recordMarshaller;
    private Object recordValue;

    public MarshallerImpl(MarshallingContext context, Selector layout, RecordMarshaller recordMarshaller) {
        this.context = context;
        this.layout = layout;
        this.recordMarshaller = recordMarshaller;
        this.context.setRecordWriter(new RecordWriter(){

            public void write(Object record) {
                MarshallerImpl.this.recordValue = record;
            }

            public void flush() {
            }

            public void close() {
            }
        });
    }

    @Override
    public Marshaller marshal(Object bean) throws BeanWriterException {
        return this.marshal(null, bean);
    }

    @Override
    public Marshaller marshal(String recordName, Object bean) throws BeanWriterException {
        this.recordValue = null;
        if (recordName == null && bean == null) {
            throw new BeanWriterException("Bean identification failed: a record name or bean object must be provided");
        }
        try {
            this.context.setComponentName(recordName);
            this.context.setBean(bean);
            Selector matched = this.layout.matchNext(this.context);
            if (matched == null) {
                if (recordName != null) {
                    throw new BeanWriterException("Bean identification failed: record name '" + recordName + "' not matched at the current position" + (bean != null ? " for bean class '" + bean.getClass() + "'" : ""));
                }
                throw new BeanWriterException("Bean identification failed: no record or group mapping for bean class '" + bean.getClass() + "' at the current position");
            }
            if (matched.isRecordGroup()) {
                throw new BeanWriterException("Record groups not supported by Marshaller");
            }
            matched.marshal(this.context);
            MarshallerImpl marshallerImpl = this;
            return marshallerImpl;
        }
        catch (IOException e) {
            throw new BeanWriterException(e);
        }
        catch (BeanWriterException ex) {
            throw ex;
        }
        catch (BeanIOException ex) {
            throw new BeanWriterException(ex.getMessage(), ex);
        }
        finally {
            this.context.clear();
        }
    }

    @Override
    public String toString() {
        return this.recordValue == null ? null : this.recordMarshaller.marshal(this.recordValue);
    }

    @Override
    public String[] toArray() throws BeanWriterException {
        String[] array = this.context.toArray(this.recordValue);
        if (array == null) {
            throw new BeanWriterException("toArray() not supported by stream format");
        }
        return array;
    }

    @Override
    public List<String> toList() throws BeanWriterException {
        List<String> list = this.context.toList(this.recordValue);
        if (list == null) {
            throw new BeanWriterException("toList() not supported by stream format");
        }
        return list;
    }

    @Override
    public Document toDocument() throws BeanWriterException {
        Document document = this.context.toDocument(this.recordValue);
        if (document == null) {
            throw new BeanWriterException("toNode() not supported by stream format");
        }
        return document;
    }

    protected Object getRecordValue() {
        return this.recordValue;
    }

    @Override
    public void debug() {
        this.debug(System.out);
    }

    @Override
    public void debug(PrintStream out) {
        ((Component)((Object)this.layout)).print(out);
    }
}

