/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.ParserComponent;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.format.xml.XmlMarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNode;
import org.beanio.internal.parser.format.xml.XmlUnmarshallingContext;
import org.beanio.internal.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSelectorWrapper
extends ParserComponent
implements Selector,
XmlNode {
    private static final String WRITTEN_KEY = "written";
    private ParserLocal<Boolean> written = new ParserLocal<Boolean>(false);
    private boolean group;
    private int depth;
    private String localName;
    private String prefix;
    private String namespace;
    private boolean namespaceAware;

    public XmlSelectorWrapper() {
        super(1);
    }

    public Document createBaseDocument() {
        Document document = DomUtil.newDocument();
        this.createBaseDocument(document, document, this);
        return document;
    }

    private void createBaseDocument(Document document, Node parent, Component node) {
        if (node instanceof XmlSelectorWrapper) {
            XmlSelectorWrapper wrapper = (XmlSelectorWrapper)node;
            if (!wrapper.isGroup()) {
                return;
            }
            Element element = document.createElementNS(wrapper.getNamespace(), wrapper.getLocalName());
            parent.appendChild(element);
            if (!wrapper.isNamespaceAware()) {
                element.setUserData("namespaceIgnored", Boolean.TRUE, null);
            } else if ("".equals(this.getPrefix())) {
                element.setUserData("isDefaultNamespace", Boolean.TRUE, null);
            } else {
                element.setPrefix(this.getPrefix());
            }
            parent = element;
        }
        for (Component child : node.getChildren()) {
            this.createBaseDocument(document, parent, child);
        }
    }

    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        XmlMarshallingContext ctx = (XmlMarshallingContext)context;
        Node parent = ctx.getParent();
        Node node = parent.appendChild(ctx.getDocument().createElementNS(this.getNamespace(), this.getLocalName()));
        if (this.group && ctx.isStreaming()) {
            node.setUserData("isGroup", Boolean.TRUE, null);
        }
        if (!this.isNamespaceAware()) {
            node.setUserData("isNamespaceIgnored", Boolean.TRUE, null);
        } else if ("".equals(this.getPrefix())) {
            node.setUserData("isDefaultNamespace", Boolean.TRUE, null);
        } else {
            node.setPrefix(this.getPrefix());
        }
        ctx.setParent(node);
        boolean b = this.getDelegate().marshal(context);
        if (this.group && ctx.isStreaming()) {
            ((XmlMarshallingContext)context).closeGroup(this);
        }
        ctx.setParent(null);
        return b;
    }

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        return this.getDelegate().unmarshal(context);
    }

    @Override
    public void skip(UnmarshallingContext context) {
        this.getDelegate().skip(context);
    }

    @Override
    public Selector matchNext(MarshallingContext context) {
        XmlMarshallingContext ctx = (XmlMarshallingContext)context;
        int initialCount = this.getCount(context);
        Selector match = this.getDelegate().matchNext(context);
        if (match == null) {
            if (this.written.get(context).booleanValue()) {
                this.written.set(context, false);
                ctx.closeGroup(this);
            }
            return null;
        }
        if (this.group) {
            if (ctx.isStreaming()) {
                boolean w = this.written.get(context);
                if (w && this.getCount(context) > initialCount) {
                    ctx.closeGroup(this);
                    this.written.set(context, false);
                    w = false;
                }
                if (!w) {
                    ctx.openGroup(this);
                    this.written.set(context, true);
                }
            } else {
                ctx.openGroup(this);
            }
            return match;
        }
        return this;
    }

    @Override
    public Selector matchNext(UnmarshallingContext context) {
        return this.match(context, true);
    }

    @Override
    public Selector matchAny(UnmarshallingContext context) {
        return this.match(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector match(UnmarshallingContext context, boolean stateful) {
        XmlUnmarshallingContext ctx = (XmlUnmarshallingContext)context;
        Element matchedDomNode = ctx.pushPosition(this, this.depth, this.group);
        if (matchedDomNode == null) {
            return null;
        }
        Selector match = null;
        try {
            Integer n;
            if (stateful && (n = (Integer)matchedDomNode.getUserData("count")) != null && n > this.getCount(context)) {
                if (this.isMaxOccursReached(context)) {
                    Selector selector = null;
                    return selector;
                }
                this.setCount(context, n);
                this.reset(context);
            }
            Selector selector = match = this.getDelegate().matchNext(context);
            return selector;
        }
        finally {
            if (match == null) {
                ctx.popPosition();
            }
        }
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        return false;
    }

    @Override
    public void updateState(ParsingContext context, String namespace, Map<String, Object> state) {
        state.put(this.getKey(namespace, WRITTEN_KEY), this.written.get(context));
        for (Component node : this.getChildren()) {
            ((Selector)((Object)node)).updateState(context, namespace, state);
        }
    }

    @Override
    public void restoreState(ParsingContext context, String namespace, Map<String, Object> state) {
        String key = this.getKey(namespace, WRITTEN_KEY);
        Boolean written = (Boolean)state.get(key);
        if (written == null) {
            throw new IllegalStateException("Missing state information for key '" + key + "'");
        }
        this.written.set(context, written);
        for (Component child : this.getChildren()) {
            ((Selector)((Object)child)).restoreState(context, namespace, state);
        }
    }

    protected String getKey(String namespace, String name) {
        return namespace + "." + this.getName() + "." + name;
    }

    private final Selector getDelegate() {
        return (Selector)this.getFirst();
    }

    @Override
    public Object getValue(ParsingContext context) {
        return this.getDelegate().getValue(context);
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        this.getDelegate().setValue(context, value);
    }

    @Override
    public int getSize() {
        return this.getDelegate().getSize();
    }

    @Override
    public Selector close(ParsingContext context) {
        return this.getDelegate().close(context);
    }

    @Override
    public void reset(ParsingContext context) {
        this.written.set(context, false);
        this.getDelegate().reset(context);
    }

    @Override
    public int getCount(ParsingContext context) {
        return this.getDelegate().getCount(context);
    }

    @Override
    public void setCount(ParsingContext context, int count) {
        this.getDelegate().setCount(context, count);
    }

    @Override
    public int getMinOccurs() {
        return this.getDelegate().getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        return this.getDelegate().getMaxOccurs();
    }

    @Override
    public int getOrder() {
        return this.getDelegate().getOrder();
    }

    @Override
    public boolean isMaxOccursReached(ParsingContext context) {
        return this.getDelegate().isMaxOccursReached(context);
    }

    @Override
    public void clearValue(ParsingContext context) {
        this.getDelegate().clearValue(context);
    }

    @Override
    public boolean isIdentifier() {
        return this.getDelegate().isIdentifier();
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public boolean isOptional() {
        return this.getDelegate().isOptional();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean isNillable() {
        return false;
    }

    @Override
    public boolean isRepeating() {
        return false;
    }

    @Override
    public Property getProperty() {
        return this.getDelegate().getProperty();
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        return this.getDelegate().hasContent(context);
    }

    @Override
    public boolean isRecordGroup() {
        return false;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void registerLocals(Set<ParserLocal<?>> locals) {
        if (locals.add(this.written)) {
            super.registerLocals(locals);
        }
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", depth=").append(this.depth);
        s.append(", group=").append(this.group);
        s.append(", localName=").append(this.localName);
        if (this.prefix != null) {
            s.append(", prefix=").append(this.prefix);
        }
        if (this.namespace != null) {
            s.append(", xmlns=").append(this.isNamespaceAware() ? this.namespace : "*");
        }
    }
}

