/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.types.xml;

import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.beanio.types.DateTypeHandler;
import org.beanio.types.TypeConversionException;

public abstract class AbstractXmlDateTypeHandler
extends DateTypeHandler {
    protected static final DatatypeFactory dataTypeFactory;
    private boolean timeZoneAllowed = true;
    private boolean lenientDatatype = false;

    public Date parse(String text) throws TypeConversionException {
        if (this.pattern != null) {
            return super.parse(text);
        }
        if ("".equals(text)) {
            return null;
        }
        QName type = this.getDatatypeQName();
        try {
            XMLGregorianCalendar xcal = dataTypeFactory.newXMLGregorianCalendar(text);
            if (!this.lenientDatatype && type != null && !xcal.getXMLSchemaType().equals(type)) {
                throw new TypeConversionException("Invalid XML " + type.getLocalPart());
            }
            if (!this.isTimeZoneAllowed() && xcal.getTimezone() != Integer.MIN_VALUE) {
                String typeName = type == null ? "dateTime" : type.getLocalPart();
                throw new TypeConversionException("Invalid XML " + typeName + ", time zone not allowed");
            }
            return xcal.toGregorianCalendar().getTime();
        }
        catch (IllegalArgumentException ex) {
            String typeName = type == null ? "dateTime" : type.getLocalPart();
            throw new TypeConversionException("Invalid XML " + typeName);
        }
    }

    public abstract String format(Object var1);

    protected abstract QName getDatatypeQName();

    protected Calendar newCalendar() {
        return this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
    }

    protected int getTimeZoneOffset(Date date) {
        if (this.timeZone == null) {
            return Integer.MIN_VALUE;
        }
        return this.timeZone.getOffset(date.getTime()) / 60000;
    }

    public boolean isTimeZoneAllowed() {
        return this.timeZoneAllowed;
    }

    public void setTimeZoneAllowed(boolean timeZoneAllowed) {
        this.timeZoneAllowed = timeZoneAllowed;
    }

    public boolean isLenientDatatype() {
        return this.lenientDatatype;
    }

    public void setLenientDatatype(boolean lenientDatatype) {
        this.lenientDatatype = lenientDatatype;
    }

    static {
        try {
            dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Failed to create DatatypeFactory instance", e);
        }
    }
}

