/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.types.xml;

import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBooleanTypeHandler
implements TypeHandler {
    private boolean numericFormatEnabled = false;

    @Override
    public Boolean parse(String text) throws TypeConversionException {
        if (text == null || "".equals(text)) {
            return null;
        }
        if ("true".equals(text) || "1".equals(text)) {
            return Boolean.TRUE;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return Boolean.FALSE;
        }
        throw new TypeConversionException("Invalid XML boolean");
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        boolean b = (Boolean)value;
        if (this.isNumericFormatEnabled()) {
            return b ? "1" : "0";
        }
        return b ? "true" : "false";
    }

    @Override
    public Class<?> getType() {
        return Boolean.class;
    }

    public boolean isNumericFormatEnabled() {
        return this.numericFormatEnabled;
    }

    public void setNumericFormatEnabled(boolean numericFormatEnabled) {
        this.numericFormatEnabled = numericFormatEnabled;
    }
}

