/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Provider;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.BeanTypeAssignabilityRules;
import org.jboss.weld.resolution.DelegateInjectionPointAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractTypeSafeBeanResolver<T extends Bean<?>, C extends Collection<T>>
extends TypeSafeResolver<Resolvable, T, C> {
    private final BeanManagerImpl beanManager;
    private final LoadingCache<Set<Bean<?>>, Set<Bean<?>>> disambiguatedBeans;
    private final SpecializationAndEnablementRegistry registry;
    private final MetaAnnotationStore store;
    private final LazyValueHolder<Map<Type, ArrayList<T>>> beansByType;

    public AbstractTypeSafeBeanResolver(BeanManagerImpl beanManager, final Iterable<T> beans) {
        super(beans);
        this.beanManager = beanManager;
        this.registry = (SpecializationAndEnablementRegistry)beanManager.getServices().get(SpecializationAndEnablementRegistry.class);
        this.disambiguatedBeans = CacheBuilder.newBuilder().build((CacheLoader)new BeanDisambiguation());
        this.store = (MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class);
        this.beansByType = new LazyValueHolder<Map<Type, ArrayList<T>>>(){

            @Override
            protected Map<Type, ArrayList<T>> computeValue() {
                HashMap map = new HashMap();
                for (Bean bean : beans) {
                    this.mapBean(map, bean);
                }
                this.trimArrayListsToSize(map);
                return Collections.unmodifiableMap(map);
            }

            private void mapBean(Map<Type, ArrayList<T>> map, T bean) {
                for (Type type : bean.getTypes()) {
                    Class clazz;
                    this.mapTypeToBean(map, type, bean);
                    if (type instanceof ParameterizedType) {
                        Type rawType = ((ParameterizedType)type).getRawType();
                        this.mapTypeToBean(map, rawType, bean);
                        continue;
                    }
                    if (!(type instanceof Class) || !(clazz = (Class)type).isPrimitive()) continue;
                    Class wrapped = Primitives.wrap((Class)clazz);
                    this.mapTypeToBean(map, wrapped, bean);
                }
            }

            private void mapTypeToBean(Map<Type, ArrayList<T>> map, Type type, T bean) {
                if (!map.containsKey(type)) {
                    map.put(type, new ArrayList());
                }
                map.get(type).add(bean);
            }

            private void trimArrayListsToSize(Map<Type, ArrayList<T>> map) {
                for (Map.Entry entry : map.entrySet()) {
                    entry.getValue().trimToSize();
                }
            }
        };
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        BeanTypeAssignabilityRules rules = null;
        rules = resolvable.isDelegate() ? DelegateInjectionPointAssignabilityRules.instance() : BeanTypeAssignabilityRules.instance();
        return rules.matches(resolvable.getTypes(), bean.getTypes()) && Beans.containsAllQualifiers(resolvable.getQualifiers(), QualifierInstance.of(bean, this.store));
    }

    @Override
    protected Iterable<? extends T> getAllBeans(Resolvable resolvable) {
        if (resolvable.getTypes().contains(Object.class) || Instance.class.equals(resolvable.getJavaClass()) || Event.class.equals(resolvable.getJavaClass()) || Provider.class.equals(resolvable.getJavaClass()) || resolvable.getTypes().contains(Serializable.class)) {
            return super.getAllBeans(resolvable);
        }
        HashSet<T> beans = new HashSet<T>();
        for (Type type : resolvable.getTypes()) {
            beans.addAll(this.getBeans(type));
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                beans.addAll(this.getBeans(rawType));
                continue;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (!clazz.isPrimitive()) continue;
                clazz = Primitives.wrap((Class)clazz);
                beans.addAll(this.getBeans(clazz));
                continue;
            }
            if (!(type instanceof GenericArrayType)) continue;
            Class rawArrayType = Reflections.getRawType(type);
            beans.addAll(this.getBeans(rawArrayType));
        }
        return beans;
    }

    private List<T> getBeans(Type type) {
        List beansForType = this.beansByType.get().get(type);
        return beansForType == null ? Collections.emptyList() : beansForType;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.removeDisabledBeans(matched, this.beanManager, this.registry);
    }

    public <X> Set<Bean<? extends X>> resolve(Set<Bean<? extends X>> beans) {
        if (beans.size() <= 1) {
            return beans;
        }
        beans = ImmutableSet.copyOf(beans);
        return (Set)LoadingCacheUtils.getCastCacheValue(this.disambiguatedBeans, beans);
    }

    @Override
    public void clear() {
        super.clear();
        this.disambiguatedBeans.invalidateAll();
        this.beansByType.clear();
    }

    MetaAnnotationStore getStore() {
        return this.store;
    }

    public class BeanDisambiguation
    extends CacheLoader<Set<Bean<?>>, Set<Bean<?>>> {
        private BeanDisambiguation() {
        }

        public Set<Bean<?>> load(Set<Bean<?>> from) {
            if (from.size() > 1) {
                HashSet allBeans = new HashSet();
                HashSet priorityBeans = new HashSet();
                for (Bean<?> bean : from) {
                    AbstractProducerBean producer;
                    if (bean.isAlternative()) {
                        priorityBeans.add(bean);
                    } else if (bean instanceof AbstractProducerBean && (producer = (AbstractProducerBean)bean).getDeclaringBean().isAlternative()) {
                        priorityBeans.add(bean);
                    }
                    allBeans.add(bean);
                }
                if (priorityBeans.isEmpty()) {
                    return WeldCollections.immutableGuavaSet(allBeans);
                }
                if (priorityBeans.size() == 1) {
                    return Collections.singleton(priorityBeans.iterator().next());
                }
                return this.resolveAlternatives(priorityBeans);
            }
            return ImmutableSet.copyOf(from);
        }

        public Set<Bean<?>> resolveAlternatives(Set<Bean<?>> alternatives) {
            int highestPriority = Integer.MIN_VALUE;
            HashSet selectedAlternativesWithHighestPriority = new HashSet();
            for (Bean<?> bean : alternatives) {
                Integer priority = AbstractTypeSafeBeanResolver.this.beanManager.getEnabled().getAlternativePriority(bean.getBeanClass());
                if (priority == null) {
                    return WeldCollections.immutableGuavaSet(alternatives);
                }
                if (priority > highestPriority) {
                    highestPriority = priority;
                    selectedAlternativesWithHighestPriority.clear();
                }
                if (priority != highestPriority) continue;
                selectedAlternativesWithHighestPriority.add(bean);
            }
            return WeldCollections.immutableGuavaSet(selectedAlternativesWithHighestPriority);
        }
    }
}

