/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPointImpl;
import org.jboss.weld.injection.attributes.ForwardingFieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ForwardingParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionPoints {
    private InjectionPoints() {
    }

    public static <T extends WeldInjectionPointAttributes<?, ?>> Set<T> flattenInjectionPoints(List<? extends Set<T>> fieldInjectionPoints) {
        ArraySet<T> injectionPoints = new ArraySet<T>();
        for (Set<T> i : fieldInjectionPoints) {
            injectionPoints.addAll((Collection<T>)i);
        }
        return injectionPoints.trimToSize();
    }

    public static Set<ParameterInjectionPoint<?, ?>> flattenParameterInjectionPoints(List<Set<MethodInjectionPoint<?, ?>>> methodInjectionPoints) {
        ArraySet<ParameterInjectionPoint> injectionPoints = new ArraySet<ParameterInjectionPoint>();
        for (Set<MethodInjectionPoint<?, ?>> i : methodInjectionPoints) {
            for (MethodInjectionPoint<?, ?> method : i) {
                for (ParameterInjectionPoint parameter : method.getParameterInjectionPoints()) {
                    injectionPoints.add(parameter);
                }
            }
        }
        return injectionPoints.trimToSize();
    }

    public static <X> Set<ParameterInjectionPoint<?, X>> filterOutSpecialParameterInjectionPoints(List<ParameterInjectionPoint<?, X>> injectionPoints) {
        ArraySet filtered = new ArraySet();
        for (ParameterInjectionPoint<?, X> parameter : injectionPoints) {
            if (parameter instanceof SpecialParameterInjectionPoint) continue;
            filtered.add(parameter);
        }
        return filtered.trimToSize();
    }

    public static InjectionPoint getDelegateInjectionPoint(Decorator<?> decorator) {
        if (decorator instanceof DecoratorImpl) {
            return ((DecoratorImpl)decorator).getDelegateInjectionPoint();
        }
        for (InjectionPoint injectionPoint : decorator.getInjectionPoints()) {
            if (!injectionPoint.isDelegate()) continue;
            return injectionPoint;
        }
        return null;
    }

    public static <T, X> WeldInjectionPointAttributes<T, ?> getWeldInjectionPoint(InjectionPoint injectionPoint) {
        if (injectionPoint instanceof WeldInjectionPointAttributes) {
            return (WeldInjectionPointAttributes)Reflections.cast(injectionPoint);
        }
        if (injectionPoint.getAnnotated() instanceof AnnotatedField) {
            return FieldInjectionPoint.silent(ForwardingFieldInjectionPointAttributes.of(injectionPoint));
        }
        return ParameterInjectionPointImpl.silent(ForwardingParameterInjectionPointAttributes.of(injectionPoint));
    }

    public static boolean isInjectableReferenceLookupOptimizationAllowed(Bean<?> bean, Bean<?> resolvedBean) {
        Preconditions.checkArgumentNotNull(resolvedBean, "resolvedBean");
        return bean != null && (RequestScoped.class.equals((Object)bean.getScope()) || ApplicationScoped.class.equals((Object)bean.getScope()) && ApplicationScoped.class.equals((Object)resolvedBean.getScope()));
    }
}

